/*
 * Decompiled with CFR 0.152.
 */
package com.denni5x.dbtools.client.BlueprintTools.Conversions;

import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.blueprint.Blueprint;
import com.moulberry.axiom.blueprint.BlueprintIo;
import com.moulberry.axiom.downgrade.DowngradeVersion;
import com.moulberry.axiom.downgrade.DowngradeVersionList;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.editor.schematic.SchematicLoader;
import com.moulberry.axiom.editor.windows.save_world.SaveSchematicAction;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.restrictions.AxiomPermission;
import com.moulberry.axiom.tools.Tool;
import com.moulberry.axiom.utils.AsyncFileDialogs;
import com.moulberry.axiom.utils.Authorization;
import com.moulberry.axiom.utils.StringUtils;
import com.moulberry.axiom.world_modification.CompressedBlockEntity;
import imgui.ImGui;
import imgui.type.ImString;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2487;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class BlueprintToSchemTool
implements Tool {
    private final int[] downgradeVersion = new int[]{0};
    private SaveSchematicAction saveSchematicAction = null;
    private String extension = null;
    private DowngradeVersion version = null;
    private Path blueprintPath = Path.of(Axiom.getInstance().getBlueprintDirectory().toString(), new String[0]);
    private CompletableFuture<String> blueprintFolderFuture;
    private Path schematicPath = SchematicLoader.getDefaultSchematicDir();
    private CompletableFuture<String> schematicFolderFuture;
    private ArrayList<Blueprint> blueprintsQueue = new ArrayList();
    private int currentBlueprint = 0;
    private boolean conversionOngoing = false;
    private long startTime = System.currentTimeMillis();
    private long finishTime = System.currentTimeMillis();

    public void reset() {
        this.startTime = 0L;
        this.finishTime = 0L;
        this.currentBlueprint = 0;
        this.blueprintsQueue.clear();
        this.conversionOngoing = false;
    }

    public void render(class_4184 camera, float v, long l, class_4587 matrixStack, Matrix4f matrix4f) {
        String folderPath;
        if (this.blueprintFolderFuture != null && this.blueprintFolderFuture.isDone()) {
            folderPath = this.blueprintFolderFuture.join();
            if (folderPath != null && !folderPath.isEmpty()) {
                this.blueprintPath = Path.of(folderPath, new String[0]);
            }
            this.blueprintFolderFuture = null;
        }
        if (this.schematicFolderFuture != null && this.schematicFolderFuture.isDone()) {
            folderPath = this.schematicFolderFuture.join();
            if (folderPath != null && !folderPath.isEmpty()) {
                this.schematicPath = Path.of(folderPath, new String[0]);
            }
            this.schematicFolderFuture = null;
        }
        if (!this.blueprintsQueue.isEmpty() && !this.conversionOngoing && this.currentBlueprint < this.blueprintsQueue.size()) {
            this.conversionOngoing = true;
            Blueprint blueprint = this.blueprintsQueue.get(this.currentBlueprint);
            this.saveSchematic(this.version, this.extension, blueprint.header().author(), blueprint.header().name(), blueprint.blockRegion(), (Long2ObjectMap<CompressedBlockEntity>)blueprint.blockEntities());
            ++this.currentBlueprint;
            this.conversionOngoing = false;
        }
    }

    public void displayImguiOptions() {
        String[] versionStrings;
        ImGuiHelper.separatorWithText((String)"DBTools: Blueprint To Schematic");
        ImGui.inputText((String)"Blueprint Folder Path", (ImString)new ImString(this.blueprintPath.toString()), (int)16384);
        if (ImGui.button((String)"Set Blueprint Folder")) {
            try {
                this.blueprintFolderFuture = AsyncFileDialogs.openFolderDialog((String)this.blueprintPath.toString());
            }
            catch (Exception e) {
                this.blueprintPath = Path.of(Axiom.getInstance().getBlueprintDirectory().toString(), new String[0]);
            }
        }
        ImGui.inputText((String)"Schematic Folder Path", (ImString)new ImString(this.schematicPath.toString()), (int)16384);
        if (ImGui.button((String)"Set Schematic Folder")) {
            try {
                this.schematicFolderFuture = AsyncFileDialogs.openFolderDialog((String)this.schematicPath.toString());
            }
            catch (Exception e) {
                this.schematicPath = SchematicLoader.getDefaultSchematicDir();
            }
        }
        if ((versionStrings = DowngradeVersionList.getVersionStrings()) != null && versionStrings.length > 0) {
            if (!Authorization.hasCommercialLicense()) {
                ImGui.beginDisabled();
                ImGuiHelper.combo((String)"Version", (int[])this.downgradeVersion, (String[])versionStrings);
                ImGui.endDisabled();
                ImGuiHelper.tooltip((String)"Exporting to old versions is a Commercial License feature", (int)512);
            } else {
                ImGuiHelper.combo((String)"Version", (int[])this.downgradeVersion, (String[])versionStrings);
            }
        } else if (Authorization.hasCommercialLicense()) {
            ImGui.text((String)"\u26a0 Missing data for 1.20.1. Version exporting is unavailable.");
        }
        if (ImGui.button((String)AxiomI18n.get((String)"Convert blueprints"))) {
            this.convert();
        }
        if (!this.blueprintsQueue.isEmpty()) {
            if (!ImGui.isPopupOpen((String)"Blueprint To Schematic")) {
                ImGui.openPopup((String)"Blueprint To Schematic");
            }
            if (ImGuiHelper.beginPopupModal((String)"Blueprint To Schematic", (int)64)) {
                long currentTime;
                int maxIterations = Math.abs(this.blueprintsQueue.size());
                int percentage = this.currentBlueprint * 100 / maxIterations;
                ImGui.text((String)("Progress: " + percentage + "%"));
                if (this.currentBlueprint == maxIterations && this.finishTime == 0L) {
                    this.finishTime = System.currentTimeMillis();
                }
                if ((currentTime = System.currentTimeMillis()) < this.startTime) {
                    this.startTime = 0L;
                }
                long duration = this.startTime > 0L && this.finishTime == 0L ? (currentTime - this.startTime) / 1000L : (this.finishTime - this.startTime) / 1000L;
                String durationString = String.format("Elapsed Time: %02d:%02d", duration / 60L, duration % 60L);
                ImGui.text((String)durationString);
                if (this.currentBlueprint == maxIterations && this.saveSchematicAction == null) {
                    if (ImGui.button((String)"Close")) {
                        this.reset();
                    }
                } else if (ImGui.button((String)"Cancel")) {
                    this.reset();
                }
                ImGui.endPopup();
            }
        }
    }

    private void convert() {
        if (Authorization.hasCommercialLicense()) {
            this.version = (DowngradeVersion)DowngradeVersionList.getVersions().get(this.downgradeVersion[0]);
        }
        this.extension = this.version != null && this.version.getMaxDataVersion() < 1631 ? "schematic" : "schem";
        this.reset();
        this.startTime = System.currentTimeMillis();
        this.blueprintsQueue = this.getBlueprints();
    }

    private ArrayList<Blueprint> getBlueprints() {
        ArrayList<Blueprint> blueprints = new ArrayList<Blueprint>();
        try (Stream<Path> files = Files.list(this.blueprintPath);){
            files.filter(path -> path.toString().endsWith(".bp")).forEach(path -> {
                try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
                    Blueprint fullBlueprint = BlueprintIo.readBlueprint((InputStream)is);
                    blueprints.add(fullBlueprint);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return blueprints;
    }

    private void saveSchematic(DowngradeVersion version, String extension, String author, String name, ChunkedBlockRegion blockRegion, Long2ObjectMap<CompressedBlockEntity> blockEntities) {
        String schematicNameString = name.trim();
        Object snakeName = schematicNameString.isEmpty() ? "unnamed." + extension : schematicNameString.toLowerCase(Locale.ROOT).replace(' ', '_') + "." + extension;
        snakeName = StringUtils.sanitizePath((String)snakeName);
        Object filePathName = this.schematicPath.toString() + "/" + (String)snakeName;
        filePathName = ((String)filePathName).replace(".schem.schem", ".schem");
        filePathName = ((String)filePathName).replace(".schematic.schematic", ".schematic");
        Path path = Path.of((String)filePathName, new String[0]);
        String authorNameStr = author.trim();
        if (authorNameStr.isEmpty()) {
            authorNameStr = class_310.method_1551().field_1724 == null ? "Unknown" : class_310.method_1551().field_1724.method_5820();
        }
        this.saveSchematicAction = new SaveSchematicAction(path, blockRegion, blockEntities, version, name, authorNameStr, null);
        if (this.saveSchematicAction.run()) {
            this.saveSchematicAction = null;
        }
    }

    public String name() {
        return "DBTools: Blueprint To Schematic";
    }

    public char iconChar() {
        return '\ue958';
    }

    public void writeSettings(class_2487 tag) {
    }

    public EnumSet<AxiomPermission> requiredPermissions() {
        return EnumSet.of(AxiomPermission.TOOL, AxiomPermission.BUILD_SECTION);
    }

    public void loadSettings(class_2487 tag) {
    }

    public String keybindId() {
        return "";
    }
}

