/*
 * Decompiled with CFR 0.152.
 */
package com.denni5x.dbtools.client.UI;

import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.i18n.AxiomI18n;
import imgui.ImGui;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class RemoveTagListWidget {
    private final List<String> availableTags = new ArrayList<String>();
    private final Set<String> tagsToRemove = new HashSet<String>();

    public Set<String> tagsToRemove() {
        return this.tagsToRemove;
    }

    public void setAvailableTags(List<String> tags) {
        this.availableTags.clear();
        this.availableTags.addAll(tags);
        this.tagsToRemove.removeIf(tag -> !this.availableTags.contains(tag));
    }

    public void clear() {
        this.tagsToRemove.clear();
    }

    public void render(int width) {
        ArrayList<String> displayTags = new ArrayList<String>(this.availableTags);
        if (displayTags.isEmpty()) {
            ImGui.textDisabled((String)"(No tags in selected blueprints)");
            return;
        }
        ImGui.getWindowDrawList().addText(ImGui.getCursorScreenPosX() + (float)width + ImGui.getStyle().getItemInnerSpacingX(), ImGui.getCursorScreenPosY() + ImGui.getStyle().getFramePaddingY(), -1, AxiomI18n.get((String)"axiom.widget.blueprint_tags"));
        int selected = ImGuiHelper.elementList((String)AxiomI18n.get((String)"axiom.widget.blueprint_tags"), displayTags, (float)width, (int)1, (int)Math.min(8, displayTags.size()), (boolean)true, index -> {
            String tag = this.availableTags.get(index);
            if (this.tagsToRemove.contains(tag)) {
                float textWidth = ImGui.calcTextSize((String)tag).x;
                float itemPosX = ImGui.getItemRectMinX();
                float itemPosY = ImGui.getItemRectMinY();
                float itemHeight = ImGui.getItemRectSizeY();
                ImGui.getWindowDrawList().addLine(itemPosX + ImGui.getStyle().getFramePaddingX(), itemPosY + itemHeight / 2.0f, itemPosX + ImGui.getStyle().getFramePaddingX() + textWidth, itemPosY + itemHeight / 2.0f, ImGui.getColorU32((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f), 3.0f);
            }
        });
        if (selected >= 0 && selected < this.availableTags.size()) {
            String tag = this.availableTags.get(selected);
            if (this.tagsToRemove.contains(tag)) {
                this.tagsToRemove.remove(tag);
            } else {
                this.tagsToRemove.add(tag);
            }
        }
    }
}

