/*
 * Decompiled with CFR 0.152.
 */
package com.denni5x.dbtools.client.BlueprintTools;

import com.denni5x.dbtools.client.Utils.BlueprintUtils;
import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.RayCaster;
import com.moulberry.axiom.UserAction;
import com.moulberry.axiom.clipboard.Clipboard;
import com.moulberry.axiom.clipboard.ClipboardObject;
import com.moulberry.axiom.clipboard.Placement;
import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.clipboard.SelectionBuffer;
import com.moulberry.axiom.collections.PositionSet;
import com.moulberry.axiom.editor.BlueprintPreview;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.editor.widgets.TagListWidget;
import com.moulberry.axiom.exceptions.FaultyImplementationError;
import com.moulberry.axiom.gizmo.Gizmo;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.mask.MaskContext;
import com.moulberry.axiom.mask.MaskElement;
import com.moulberry.axiom.mask.MaskManager;
import com.moulberry.axiom.mask.elements.ConstantMaskElement;
import com.moulberry.axiom.render.EffectRenderer;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.restrictions.AxiomPermission;
import com.moulberry.axiom.tools.Tool;
import com.moulberry.axiom.tools.magic_select.MagicSelectionTask;
import com.moulberry.axiom.utils.AsyncFileDialogs;
import com.moulberry.axiom.utils.EntityDataUtils;
import com.moulberry.axiom.utils.PositionUtils;
import com.moulberry.axiom.world_modification.Dispatcher;
import imgui.ImGui;
import imgui.type.ImString;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class CreateTool
implements Tool {
    private static final TagListWidget tagListWidget = new TagListWidget();
    private static int SELECTION_TYPE_GRID = 0;
    private static int SELECTION_TYPE_MAGIC = 1;
    private final int[] position = new int[3];
    private final int[] size = new int[3];
    private final int[] stack = new int[3];
    private final ImString blueprintName = new ImString();
    private final ImString authorName = new ImString();
    private final ArrayList<BlueprintPositionSet> blueprintQueue = new ArrayList();
    private final int[] selectionType = new int[]{0};
    private final float[] limit = new float[]{100000.0f};
    private Path blueprintPath = Path.of(Axiom.getInstance().getBlueprintDirectory().toString(), new String[0]);
    private class_2338 dragOrigin = null;
    private boolean dragging = false;
    private Gizmo firstGizmo = null;
    private Gizmo secondGizmo = null;
    private Gizmo centerGizmo = null;
    private long startTime = System.currentTimeMillis();
    private long finishTime = System.currentTimeMillis();
    private class_2338 oldPosOne;
    private class_2338 oldPosTwo;
    private CompletableFuture<String> folderPathFuture;
    private boolean saveAir = false;
    private boolean saveEntities = true;
    private boolean leadingZeros = false;
    private final int[] suffixDigits = new int[]{3};
    private int currentBlueprint = 0;
    private int suffixOffset = 0;
    private int nextBlueprint = 0;
    private boolean blueprintCreationOngoing = false;
    private ClipboardObject savedClipboard = null;
    private CompletableFuture<class_1011> blueprintPreviewFuture = null;
    private BlueprintPreview blueprintPreview = null;
    private ChunkedBlockRegion blueprintPreviewRegion = null;
    private int maxImageCounter = 0;
    private final char iconChar;

    public CreateTool(char iconChar) {
        this.iconChar = iconChar;
    }

    public boolean handleScroll(int xScroll, int yScroll) {
        if (this.selectionType[0] == SELECTION_TYPE_GRID) {
            if (this.firstGizmo != null && this.secondGizmo != null && this.centerGizmo != null && !EditorUI.isCtrlOrCmdDown()) {
                class_243 lookDirection = Tool.getLookDirection();
                if (lookDirection == null) {
                    return false;
                }
                class_2350[] directions = PositionUtils.orderedByNearest((class_243)lookDirection);
                class_2350 mainDirection = directions[0];
                if (mainDirection != null) {
                    switch (mainDirection) {
                        case field_11036: {
                            this.stack[2] = this.stack[2] + yScroll;
                            break;
                        }
                        case field_11033: {
                            this.stack[2] = this.stack[2] - yScroll;
                            break;
                        }
                        case field_11043: {
                            this.stack[1] = this.stack[1] - yScroll;
                            break;
                        }
                        case field_11035: {
                            this.stack[1] = this.stack[1] + yScroll;
                            break;
                        }
                        case field_11039: {
                            this.stack[0] = this.stack[0] - yScroll;
                            break;
                        }
                        case field_11034: {
                            this.stack[0] = this.stack[0] + yScroll;
                        }
                    }
                    return true;
                }
            }
        } else if (this.firstGizmo != null && this.secondGizmo != null && this.centerGizmo != null) {
            if (EditorUI.isCtrlOrCmdDown() && !this.firstGizmo.isGrabbed() && !this.secondGizmo.isGrabbed() && !this.centerGizmo.isGrabbed()) {
                return false;
            }
            class_2338 oldCenterPos = this.centerGizmo.getTargetPosition();
            class_243 lookDirection = Tool.getLookDirection();
            if (this.centerGizmo.enableAxes && lookDirection != null) {
                this.centerGizmo.handleScroll(xScroll, yScroll, EditorUI.isCtrlOrCmdDown(), lookDirection);
            }
            class_2338 oldFirstPos = this.firstGizmo.getTargetPosition();
            class_2338 oldSecondPos = this.secondGizmo.getTargetPosition();
            if (!this.centerGizmo.getTargetPosition().equals((Object)oldCenterPos)) {
                class_2338 delta = this.centerGizmo.getTargetPosition().method_10059((class_2382)oldCenterPos);
                this.firstGizmo.moveTo(this.firstGizmo.getTargetPosition().method_10081((class_2382)delta));
                this.secondGizmo.moveTo(this.secondGizmo.getTargetPosition().method_10081((class_2382)delta));
            }
            if (this.firstGizmo.enableAxes && lookDirection != null) {
                this.firstGizmo.handleScroll(xScroll, yScroll, EditorUI.isCtrlOrCmdDown(), lookDirection);
            }
            if (this.secondGizmo.enableAxes && lookDirection != null) {
                this.secondGizmo.handleScroll(xScroll, yScroll, EditorUI.isCtrlOrCmdDown(), lookDirection);
            }
            if (!oldFirstPos.equals((Object)this.firstGizmo.getTargetPosition()) || !oldSecondPos.equals((Object)this.secondGizmo.getTargetPosition())) {
                this.updateGizmoState(oldFirstPos, oldSecondPos);
            }
            return true;
        }
        return false;
    }

    public UserAction.ActionResult callAction(UserAction action, Object object) {
        switch (action) {
            case CUT: 
            case COPY: 
            case DELETE: {
                if (this.dragOrigin != null) {
                    RayCaster.RaycastResult result = Tool.raycastBlock((boolean)false, (boolean)true, (boolean)true);
                    if (result == null) {
                        return UserAction.ActionResult.NOT_HANDLED;
                    }
                    this.setupGizmos(this.dragOrigin, result.getBlockPos());
                }
                if (this.firstGizmo == null) {
                    return UserAction.ActionResult.NOT_HANDLED;
                }
                this.reset();
                return UserAction.ActionResult.USED_CONT;
            }
            case ENTER: {
                if (this.dragOrigin != null) {
                    RayCaster.RaycastResult result = Tool.raycastBlock((boolean)false, (boolean)true, (boolean)true);
                    if (result == null) {
                        return UserAction.ActionResult.NOT_HANDLED;
                    }
                    this.setupGizmos(this.dragOrigin, result.getBlockPos());
                }
                if (this.firstGizmo == null) {
                    return UserAction.ActionResult.NOT_HANDLED;
                }
                this.createBlueprintQueue();
                return UserAction.ActionResult.USED_STOP;
            }
            case LEFT_MOUSE: {
                if (this.leftClick()) {
                    return UserAction.ActionResult.USED_STOP;
                }
                return UserAction.ActionResult.NOT_HANDLED;
            }
            case RIGHT_MOUSE: {
                this.rightClick();
                return UserAction.ActionResult.USED_STOP;
            }
            case SCROLL: {
                UserAction.ScrollAmount scrollObject = (UserAction.ScrollAmount)object;
                if (this.handleScroll(scrollObject.scrollX(), scrollObject.scrollY())) {
                    return UserAction.ActionResult.USED_STOP;
                }
                return UserAction.ActionResult.NOT_HANDLED;
            }
            case UNDO: {
                if (this.firstGizmo == null && this.dragOrigin == null) {
                    return UserAction.ActionResult.NOT_HANDLED;
                }
                this.reset();
                return UserAction.ActionResult.USED_STOP;
            }
        }
        return UserAction.ActionResult.NOT_HANDLED;
    }

    public void reset() {
        this.dragOrigin = null;
        this.firstGizmo = null;
        this.secondGizmo = null;
        this.centerGizmo = null;
        Arrays.fill(this.position, 0);
        Arrays.fill(this.size, 0);
        Arrays.fill(this.stack, 0);
        this.suffixOffset = 0;
        this.suffixDigits[0] = 3;
    }

    public void resetBlueprintCreation() {
        this.blueprintCreationOngoing = false;
        this.currentBlueprint = 0;
        this.nextBlueprint = 0;
        this.blueprintQueue.clear();
        this.finishTime = 0L;
        if (this.oldPosOne != null) {
            this.firstGizmo.moveTo(this.oldPosOne);
        }
        if (this.oldPosTwo != null) {
            this.secondGizmo.moveTo(this.oldPosTwo);
        }
    }

    private boolean leftClick() {
        if (this.firstGizmo != null && this.secondGizmo != null && this.centerGizmo != null) {
            if (EditorUI.isCtrlOrCmdDown() && !this.firstGizmo.isGrabbed() && !this.secondGizmo.isGrabbed() && !this.centerGizmo.isGrabbed()) {
                return false;
            }
            if (this.centerGizmo.leftClick()) {
                this.firstGizmo.enableAxes = false;
                this.secondGizmo.enableAxes = false;
                return true;
            }
            if (this.firstGizmo.leftClick()) {
                this.centerGizmo.enableAxes = false;
                this.secondGizmo.enableAxes = false;
                return true;
            }
            if (this.secondGizmo.leftClick()) {
                this.centerGizmo.enableAxes = false;
                this.firstGizmo.enableAxes = false;
                return true;
            }
        }
        return false;
    }

    private void rightClick() {
        RayCaster.RaycastResult result;
        if (this.dragOrigin == null) {
            RayCaster.RaycastResult result2 = Tool.raycastBlock((boolean)false, (boolean)true, (boolean)true);
            if (result2 != null) {
                this.reset();
                this.dragOrigin = result2.getBlockPos();
                this.dragging = true;
                boolean isEmpty = Selection.getSelectionBuffer().isEmpty();
                if (!isEmpty) {
                    Selection.clearSelection();
                }
            }
        } else if (!this.dragging && (result = Tool.raycastBlock((boolean)false, (boolean)true, (boolean)true)) != null) {
            for (int i = 0; i < 3; ++i) {
                class_2350.class_2351 axis = class_2350.class_2351.field_23780[i];
                this.position[i] = Math.min(this.dragOrigin.method_30558(axis), result.getBlockPos().method_30558(axis));
                this.size[i] = Math.abs(this.dragOrigin.method_30558(axis) - result.getBlockPos().method_30558(axis)) + 1;
            }
            this.setupGizmos(this.dragOrigin, result.getBlockPos());
        }
    }

    public void render(class_4184 camera, float tickDelta, long time, class_4587 matrices, Matrix4f projection) {
        if (this.folderPathFuture != null && this.folderPathFuture.isDone()) {
            String folderPath = this.folderPathFuture.join();
            if (folderPath != null && !folderPath.isEmpty()) {
                this.blueprintPath = Path.of(folderPath, new String[0]);
            }
            this.folderPathFuture = null;
        }
        if (this.firstGizmo != null) {
            if (this.secondGizmo == null && (this.stack[0] != 0 || this.stack[2] != 0 || this.stack[1] != 0)) {
                this.stack[0] = 0;
                this.stack[2] = 0;
                this.stack[1] = 0;
            }
            Objects.requireNonNull(this.secondGizmo);
            Objects.requireNonNull(this.centerGizmo);
            Selection.render((class_4184)camera, (long)time, (class_4587)matrices, (Matrix4f)projection, (int)4);
            class_2338 oldCenterPos = this.centerGizmo.getTargetPosition();
            class_243 lookDirection = Tool.getLookDirection();
            boolean isLeftDown = Tool.isMouseDown((int)0);
            boolean isCtrlDown = EditorUI.isCtrlOrCmdDown();
            boolean showGizmo = !EditorUI.isActive() || !isCtrlDown;
            this.centerGizmo.update(time, lookDirection, isLeftDown, isCtrlDown, showGizmo);
            this.centerGizmo.setAxisDirections(camera.method_19326().field_1352 > (double)this.centerGizmo.getTargetPosition().method_10263(), camera.method_19326().field_1351 > (double)this.centerGizmo.getTargetPosition().method_10264(), camera.method_19326().field_1350 > (double)this.centerGizmo.getTargetPosition().method_10260());
            class_2338 oldFirstPos = this.firstGizmo.getTargetPosition();
            class_2338 oldSecondPos = this.secondGizmo.getTargetPosition();
            if (!this.centerGizmo.getTargetPosition().equals((Object)oldCenterPos)) {
                class_2338 delta = this.centerGizmo.getTargetPosition().method_10059((class_2382)oldCenterPos);
                this.firstGizmo.moveTo(this.firstGizmo.getTargetPosition().method_10081((class_2382)delta));
                this.secondGizmo.moveTo(this.secondGizmo.getTargetPosition().method_10081((class_2382)delta));
            }
            this.firstGizmo.update(time, lookDirection, isLeftDown, isCtrlDown, showGizmo);
            this.secondGizmo.update(time, lookDirection, isLeftDown, isCtrlDown, showGizmo);
            if (!oldFirstPos.equals((Object)this.firstGizmo.getTargetPosition()) || !oldSecondPos.equals((Object)this.secondGizmo.getTargetPosition())) {
                this.updateGizmoState(oldFirstPos, oldSecondPos);
            }
            if (showGizmo || this.firstGizmo.isGrabbed() || this.secondGizmo.isGrabbed() || this.centerGizmo.isGrabbed()) {
                this.firstGizmo.render(matrices, camera, isCtrlDown);
                this.secondGizmo.render(matrices, camera, isCtrlDown);
                this.centerGizmo.render(matrices, camera, isCtrlDown);
            }
            for (int x = 0; x <= Math.abs(this.stack[0]); ++x) {
                for (int y = 0; y <= Math.abs(this.stack[2]); ++y) {
                    for (int z = 0; z <= Math.abs(this.stack[1]); ++z) {
                        int addX = this.stack[0] > 0 ? this.size[0] * x : this.size[0] * -x;
                        int addY = this.stack[2] > 0 ? this.size[1] * y : this.size[1] * -y;
                        int addZ = this.stack[1] > 0 ? this.size[2] * z : this.size[2] * -z;
                        class_243 firstPosition = new class_243(this.firstGizmo.getInterpPosition().field_1352 + (double)addX, this.firstGizmo.getInterpPosition().field_1351 + (double)addY, this.firstGizmo.getInterpPosition().field_1350 + (double)addZ);
                        class_243 secondPosition = new class_243(this.secondGizmo.getInterpPosition().field_1352 + (double)addX, this.secondGizmo.getInterpPosition().field_1351 + (double)addY, this.secondGizmo.getInterpPosition().field_1350 + (double)addZ);
                        EffectRenderer.renderBoundingBox((class_4184)camera, (long)time, (class_4587)matrices, (class_243)firstPosition, (class_243)secondPosition, (int)3);
                    }
                }
            }
            if (this.blueprintCreationOngoing && this.currentBlueprint == this.nextBlueprint && this.currentBlueprint + 1 <= this.blueprintQueue.size()) {
                this.createNextBlueprint();
            }
        } else if (this.dragOrigin == null) {
            Selection.render((class_4184)camera, (long)time, (class_4587)matrices, (Matrix4f)projection, (int)7);
        } else {
            class_2350.class_2351 axis;
            int i;
            Selection.render((class_4184)camera, (long)time, (class_4587)matrices, (Matrix4f)projection, (int)4);
            RayCaster.RaycastResult result = Tool.raycastBlock((boolean)false, (boolean)true, (boolean)true);
            if (result == null) {
                if (this.dragging) {
                    if (!Tool.isMouseDown((int)1)) {
                        this.dragOrigin = null;
                    }
                    Arrays.fill(this.position, 0);
                    Arrays.fill(this.size, 0);
                    return;
                }
                return;
            }
            for (i = 0; i < 3; ++i) {
                axis = class_2350.class_2351.field_23780[i];
                this.position[i] = Math.min(this.dragOrigin.method_30558(axis), result.getBlockPos().method_30558(axis));
                this.size[i] = Math.abs(this.dragOrigin.method_30558(axis) - result.getBlockPos().method_30558(axis)) + 1;
            }
            if (this.dragging && !Tool.isMouseDown((int)1)) {
                if (this.dragOrigin.equals((Object)result.getBlockPos())) {
                    this.dragging = false;
                } else {
                    for (i = 0; i < 3; ++i) {
                        axis = class_2350.class_2351.field_23780[i];
                        this.position[i] = Math.min(this.dragOrigin.method_30558(axis), result.getBlockPos().method_30558(axis));
                        this.size[i] = Math.abs(this.dragOrigin.method_30558(axis) - result.getBlockPos().method_30558(axis)) + 1;
                    }
                    this.setupGizmos(this.dragOrigin, result.getBlockPos());
                }
            } else {
                float minX = Math.min(this.dragOrigin.method_10263(), result.getBlockPos().method_10263());
                float minY = Math.min(this.dragOrigin.method_10264(), result.getBlockPos().method_10264());
                float minZ = Math.min(this.dragOrigin.method_10260(), result.getBlockPos().method_10260());
                float maxX = Math.max(this.dragOrigin.method_10263(), result.getBlockPos().method_10263());
                float maxY = Math.max(this.dragOrigin.method_10264(), result.getBlockPos().method_10264());
                float maxZ = Math.max(this.dragOrigin.method_10260(), result.getBlockPos().method_10260());
                EffectRenderer.renderBoundingBox((class_4184)camera, (long)time, (class_4587)matrices, (class_243)new class_243((double)minX, (double)minY, (double)minZ), (class_243)new class_243((double)(maxX + 1.0f), (double)(maxY + 1.0f), (double)(maxZ + 1.0f)), (int)3);
            }
        }
    }

    private void setupGizmos(class_2338 first, class_2338 second) {
        float offsetX = first.method_10263() <= second.method_10263() ? -0.5f : 0.5f;
        float offsetY = first.method_10264() <= second.method_10264() ? -0.5f : 0.5f;
        float offsetZ = first.method_10260() <= second.method_10260() ? -0.5f : 0.5f;
        float centerX = (float)(first.method_10263() + second.method_10263()) / 2.0f;
        float centerY = (float)(first.method_10264() + second.method_10264()) / 2.0f;
        float centerZ = (float)(first.method_10260() + second.method_10260()) / 2.0f;
        this.firstGizmo = new Gizmo(first, new class_243((double)offsetX, (double)offsetY, (double)offsetZ));
        this.secondGizmo = new Gizmo(second, new class_243((double)(-offsetX), (double)(-offsetY), (double)(-offsetZ)));
        this.centerGizmo = new Gizmo(class_2338.method_49637((double)centerX, (double)centerY, (double)centerZ), new class_243((double)centerX - Math.floor(centerX), (double)centerY - Math.floor(centerY), (double)centerZ - Math.floor(centerZ)));
        boolean firstXGreater = this.firstGizmo.getInterpPosition().field_1352 > this.secondGizmo.getInterpPosition().field_1352;
        boolean firstYGreater = this.firstGizmo.getInterpPosition().field_1351 > this.secondGizmo.getInterpPosition().field_1351;
        boolean firstZGreater = this.firstGizmo.getInterpPosition().field_1350 > this.secondGizmo.getInterpPosition().field_1350;
        this.firstGizmo.setAxisDirections(firstXGreater, firstYGreater, firstZGreater);
        this.secondGizmo.setAxisDirections(!firstXGreater, !firstYGreater, !firstZGreater);
        this.firstGizmo.enableAxes = false;
        this.secondGizmo.enableAxes = true;
        this.centerGizmo.enableAxes = false;
        this.dragOrigin = null;
    }

    private void updateGizmoState(class_2338 oldFirstPos, class_2338 oldSecondPos) {
        this.maybeSwapOffsetsForAxis(oldFirstPos, oldSecondPos, class_2350.class_2351.field_11048);
        this.maybeSwapOffsetsForAxis(oldFirstPos, oldSecondPos, class_2350.class_2351.field_11052);
        this.maybeSwapOffsetsForAxis(oldFirstPos, oldSecondPos, class_2350.class_2351.field_11051);
        class_2338 firstPos = this.firstGizmo.getTargetPosition();
        class_2338 secondPos = this.secondGizmo.getTargetPosition();
        boolean firstXGreater = this.firstGizmo.getInterpPosition().field_1352 > this.secondGizmo.getInterpPosition().field_1352;
        boolean firstYGreater = this.firstGizmo.getInterpPosition().field_1351 > this.secondGizmo.getInterpPosition().field_1351;
        boolean firstZGreater = this.firstGizmo.getInterpPosition().field_1350 > this.secondGizmo.getInterpPosition().field_1350;
        this.firstGizmo.setAxisDirections(firstXGreater, firstYGreater, firstZGreater);
        this.secondGizmo.setAxisDirections(!firstXGreater, !firstYGreater, !firstZGreater);
        float centerX = (float)(firstPos.method_10263() + secondPos.method_10263()) / 2.0f;
        float centerY = (float)(firstPos.method_10264() + secondPos.method_10264()) / 2.0f;
        float centerZ = (float)(firstPos.method_10260() + secondPos.method_10260()) / 2.0f;
        this.centerGizmo.moveTo(class_2338.method_49637((double)centerX, (double)centerY, (double)centerZ));
        this.centerGizmo.setOffset(new class_243((double)centerX - Math.floor(centerX), (double)centerY - Math.floor(centerY), (double)centerZ - Math.floor(centerZ)));
        for (int i = 0; i < 3; ++i) {
            class_2350.class_2351 axis = class_2350.class_2351.field_23780[i];
            this.position[i] = Math.min(firstPos.method_30558(axis), secondPos.method_30558(axis));
            this.size[i] = Math.abs(firstPos.method_30558(axis) - secondPos.method_30558(axis)) + 1;
        }
    }

    private void maybeSwapOffsetsForAxis(class_2338 oldFirstPos, class_2338 oldSecondPos, class_2350.class_2351 axis) {
        int size = this.firstGizmo.getTargetPosition().method_30558(axis) - this.secondGizmo.getTargetPosition().method_30558(axis);
        if (size > 0 && this.firstGizmo.getOffset().method_18043(axis) < 0.0 || size < 0 && this.firstGizmo.getOffset().method_18043(axis) > 0.0) {
            double temp = this.firstGizmo.getOffset().method_18043(axis);
            this.firstGizmo.setOffset(this.firstGizmo.getOffset().method_38499(axis, this.secondGizmo.getOffset().method_18043(axis)));
            this.secondGizmo.setOffset(this.secondGizmo.getOffset().method_38499(axis, temp));
            int firstDelta = oldFirstPos.method_30558(axis) - this.firstGizmo.getTargetPosition().method_30558(axis);
            if (firstDelta > 0) {
                this.firstGizmo.moveTo(this.firstGizmo.getTargetPosition().method_30513(axis, 1));
            } else if (firstDelta < 0) {
                this.firstGizmo.moveTo(this.firstGizmo.getTargetPosition().method_30513(axis, -1));
            }
            int secondDelta = oldSecondPos.method_30558(axis) - this.secondGizmo.getTargetPosition().method_30558(axis);
            if (secondDelta > 0) {
                this.secondGizmo.moveTo(this.secondGizmo.getTargetPosition().method_30513(axis, 1));
            } else if (secondDelta < 0) {
                this.secondGizmo.moveTo(this.secondGizmo.getTargetPosition().method_30513(axis, -1));
            }
        }
    }

    private void updateGizmosFromPositionSize() {
        for (int i = 0; i < 4; ++i) {
            if (i == 3) {
                return;
            }
            if (this.position[i] != 0 || this.size[i] != 0) break;
        }
        if (this.firstGizmo == null) {
            class_2338 first = new class_2338(this.position[0], this.position[1], this.position[2]);
            class_2338 second = first.method_10069(this.size[0], this.size[1], this.size[2]);
            this.setupGizmos(first, second);
        } else {
            class_2338 oldFirstPos = this.firstGizmo.getTargetPosition();
            class_2338 oldSecondPos = this.secondGizmo.getTargetPosition();
            class_2338.class_2339 newFirstPos = new class_2338.class_2339();
            class_2338.class_2339 newSecondPos = new class_2338.class_2339();
            block6: for (int i = 0; i < 3; ++i) {
                class_2338.class_2339 greater;
                class_2338.class_2339 lesser;
                int oldSecondPosAxis;
                class_2350.class_2351 axis = class_2350.class_2351.field_23780[i];
                int oldFirstPosAxis = oldFirstPos.method_30558(axis);
                if (oldFirstPosAxis < (oldSecondPosAxis = oldSecondPos.method_30558(axis))) {
                    lesser = newFirstPos;
                    greater = newSecondPos;
                } else if (oldFirstPosAxis > oldSecondPosAxis) {
                    lesser = newSecondPos;
                    greater = newFirstPos;
                } else {
                    double secondOffsetAxis;
                    double firstOffsetAxis = this.firstGizmo.getOffset().method_18043(axis);
                    if (firstOffsetAxis < (secondOffsetAxis = this.secondGizmo.getOffset().method_18043(axis))) {
                        lesser = newFirstPos;
                        greater = newSecondPos;
                    } else {
                        if (!(firstOffsetAxis > secondOffsetAxis)) {
                            throw new FaultyImplementationError("Offsets are equal");
                        }
                        lesser = newSecondPos;
                        greater = newFirstPos;
                    }
                }
                if (this.size[i] == 0) {
                    this.size[i] = 1;
                } else if (this.size[i] < 0) {
                    this.size[i] = Math.abs(this.size[i]);
                }
                switch (axis) {
                    case field_11048: {
                        lesser.method_33097(this.position[i]);
                        greater.method_33097(this.position[i] + this.size[i] - 1);
                        continue block6;
                    }
                    case field_11052: {
                        lesser.method_33098(this.position[i]);
                        greater.method_33098(this.position[i] + this.size[i] - 1);
                        continue block6;
                    }
                    case field_11051: {
                        lesser.method_33099(this.position[i]);
                        greater.method_33099(this.position[i] + this.size[i] - 1);
                    }
                }
            }
            this.firstGizmo.moveTo((class_2338)newFirstPos);
            this.secondGizmo.moveTo((class_2338)newSecondPos);
            if (!oldFirstPos.equals((Object)this.firstGizmo.getTargetPosition()) || !oldSecondPos.equals((Object)this.secondGizmo.getTargetPosition())) {
                this.updateGizmoState(oldFirstPos, oldSecondPos);
            }
        }
    }

    public void displayImguiOptions() {
        boolean sizePositive;
        ImGuiHelper.separatorWithText((String)"DBTools: Creation");
        ImGuiHelper.setupBorder();
        ImGuiHelper.separatorWithText((String)"Selection");
        boolean changed = ImGuiHelper.combo((String)"Type", (int[])this.selectionType, (String[])new String[]{"Grid", "Magic"});
        if (changed) {
            this.reset();
        }
        changed |= ImGuiHelper.inputInt((String)AxiomI18n.get((String)"axiom.tool.box_select.position"), (int[])this.position);
        changed |= ImGuiHelper.inputInt((String)AxiomI18n.get((String)"axiom.tool.box_select.size"), (int[])this.size);
        if (this.selectionType[0] == SELECTION_TYPE_GRID) {
            changed |= ImGuiHelper.inputInt((String)"Stack", (int[])this.stack);
        } else {
            ImGui.sliderFloat((String)"Limit per asset", (float[])this.limit, (float)2.0f, (float)1000000.0f, (String)"%'.0f", (int)32);
            if (ImGui.isItemHovered()) {
                ImGui.beginTooltip();
                ImGui.text((String)"Careful, this can cause performance issues when creating many blueprints!");
                ImGui.endTooltip();
            }
        }
        boolean bl = sizePositive = this.size[0] >= 0 && this.size[1] >= 0 && this.size[2] >= 0;
        if (!(!changed && sizePositive || ImGui.isAnyItemActive() && !sizePositive)) {
            this.updateGizmosFromPositionSize();
        }
        if (this.firstGizmo != null && ImGui.button((String)"Clear (Delete)")) {
            this.reset();
        }
        ImGuiHelper.finishBorder();
        if (this.firstGizmo != null) {
            ImGuiHelper.setupBorder();
            ImGuiHelper.separatorWithText((String)"Save Settings");
            assert (class_310.method_1551().field_1724 != null);
            String username = class_310.method_1551().field_1724.method_5477().getString();
            if (ImGui.checkbox((String)"Set number of suffix digits", (boolean)this.leadingZeros)) {
                boolean bl2 = this.leadingZeros = !this.leadingZeros;
            }
            if (ImGui.isItemHovered()) {
                ImGui.beginTooltip();
                ImGui.text((String)"If this is not checked, the suffix will be a simple number without leading 0.");
                ImGui.endTooltip();
            }
            if (this.leadingZeros) {
                ImGui.sliderInt((String)"Digits", (int[])this.suffixDigits, (int)1, (int)5);
                if (this.suffixDigits[0] < 1) {
                    this.suffixDigits[0] = 1;
                } else if (this.suffixDigits[0] > 5) {
                    this.suffixDigits[0] = 5;
                }
            }
            if (ImGui.checkbox((String)"Save Entities", (boolean)this.saveEntities)) {
                boolean bl3 = this.saveEntities = !this.saveEntities;
            }
            if (this.selectionType[0] == SELECTION_TYPE_GRID) {
                if (ImGui.checkbox((String)"Save Air", (boolean)this.saveAir)) {
                    this.saveAir = !this.saveAir;
                }
            } else {
                this.saveAir = false;
            }
            ImGui.inputTextWithHint((String)AxiomI18n.get((String)"axiom.editorui.window.create_blueprint.name"), (String)"unnamed", (ImString)this.blueprintName);
            ImGui.inputTextWithHint((String)AxiomI18n.get((String)"axiom.editorui.window.create_blueprint.author"), (String)username, (ImString)this.authorName);
            ImGui.inputText((String)"Folder Path", (ImString)new ImString(this.blueprintPath.toString()), (int)16384);
            if (ImGui.button((String)"Set Blueprint Folder")) {
                try {
                    this.folderPathFuture = AsyncFileDialogs.openFolderDialog((String)this.blueprintPath.toString());
                }
                catch (Exception e) {
                    this.blueprintPath = Path.of(Axiom.getInstance().getBlueprintDirectory().toString(), new String[0]);
                }
            }
            tagListWidget.render((int)ImGui.calcItemWidth());
            if (ImGui.button((String)"Create Blueprints (Enter)")) {
                this.createBlueprintQueue();
            }
            ImGuiHelper.finishBorder();
        }
        if (this.blueprintCreationOngoing) {
            if (!ImGui.isPopupOpen((String)"Blueprint Creation")) {
                ImGui.openPopup((String)"Blueprint Creation");
            }
            if (ImGuiHelper.beginPopupModal((String)"Blueprint Creation", (int)64)) {
                long currentTime;
                int maxIterations = this.blueprintQueue.size();
                int percentage = this.currentBlueprint * 100 / maxIterations;
                ImGui.text((String)("Progress: " + percentage + "%"));
                if (this.currentBlueprint == maxIterations && this.finishTime == 0L) {
                    this.finishTime = System.currentTimeMillis();
                }
                if ((currentTime = System.currentTimeMillis()) < this.startTime) {
                    this.startTime = 0L;
                }
                long duration = this.startTime > 0L && this.finishTime == 0L ? (currentTime - this.startTime) / 1000L : (this.finishTime - this.startTime) / 1000L;
                String durationString = String.format("Elapsed Time: %02d:%02d", duration / 60L, duration % 60L);
                ImGui.text((String)durationString);
                if (this.currentBlueprint == maxIterations) {
                    if (ImGui.button((String)"Close")) {
                        this.resetBlueprintCreation();
                    }
                } else {
                    ClipboardObject clipboard;
                    class_1011 nativeImage;
                    if (this.blueprintPreview != null && this.blueprintPreviewRegion != null && this.blueprintCreationOngoing && (nativeImage = this.tryGetImage()) != null && (clipboard = Clipboard.INSTANCE.getClipboard()) != null) {
                        String name = this.getBlueprintName();
                        BlueprintUtils.saveBlueprint(tagListWidget.tags(), name, this.authorName.get(), clipboard, nativeImage, this.blueprintPath, this.blueprintPreview, this.currentBlueprint, this.saveAir);
                        ++this.currentBlueprint;
                        if (this.currentBlueprint == this.blueprintQueue.size()) {
                            if (this.savedClipboard != null) {
                                Clipboard.INSTANCE.setClipboard(this.savedClipboard);
                                this.savedClipboard = null;
                            } else {
                                Clipboard.INSTANCE.clearClipboard();
                            }
                            Selection.clearSelection();
                        }
                        this.blueprintPreview = null;
                        this.blueprintPreviewRegion = null;
                    }
                    if (ImGui.button((String)"Cancel")) {
                        this.resetBlueprintCreation();
                    }
                }
                ImGui.endPopup();
            }
        }
    }

    private String getBlueprintName() {
        int suffix = this.currentBlueprint + 1 + this.suffixOffset;
        if (this.leadingZeros) {
            int digits = this.suffixDigits[0];
            if (digits < String.valueOf(this.suffixOffset + this.blueprintQueue.size()).length()) {
                digits = String.valueOf(this.suffixOffset + this.blueprintQueue.size()).length();
            }
            String format = "%0" + digits + "d";
            return this.blueprintName.get() + "_" + String.format(format, suffix);
        }
        return this.blueprintName.get() + "_" + suffix;
    }

    private int getSuffixOffset() {
        try {
            if (Files.exists(this.blueprintPath, new LinkOption[0])) {
                return Files.list(this.blueprintPath).map(Path::getFileName).map(Path::toString).filter(name -> name.startsWith(this.blueprintName.get().toLowerCase(Locale.ROOT) + "_") && name.endsWith(".bp")).map(name -> name.substring(this.blueprintName.get().length() + 1, name.length() - 3)).filter(suffix -> suffix.matches("\\d+")).mapToInt(Integer::parseInt).max().orElse(0);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return 0;
    }

    private void createBlueprintQueue() {
        this.blueprintQueue.clear();
        this.startTime = System.currentTimeMillis();
        this.finishTime = 0L;
        this.currentBlueprint = 0;
        this.nextBlueprint = 0;
        if (!Clipboard.INSTANCE.isEmpty()) {
            this.savedClipboard = Clipboard.INSTANCE.getClipboard();
            Clipboard.INSTANCE.clearClipboard();
        }
        this.oldPosOne = this.firstGizmo.getTargetPosition();
        this.oldPosTwo = this.secondGizmo.getTargetPosition();
        if (this.selectionType[0] == SELECTION_TYPE_GRID) {
            for (int x = 0; x <= Math.abs(this.stack[0]); ++x) {
                for (int y = 0; y <= Math.abs(this.stack[2]); ++y) {
                    for (int z = 0; z <= Math.abs(this.stack[1]); ++z) {
                        int addX = this.stack[0] > 0 ? this.size[0] * x : this.size[0] * -x;
                        int addY = this.stack[2] > 0 ? this.size[1] * y : this.size[1] * -y;
                        int addZ = this.stack[1] > 0 ? this.size[2] * z : this.size[2] * -z;
                        class_2338 firstBlockPos = this.firstGizmo.getTargetPosition();
                        class_2338 secondBlockPos = this.secondGizmo.getTargetPosition();
                        this.blueprintQueue.add(new BlueprintPositionSet(this.getPositionSetFromAABB(new class_243((double)(firstBlockPos.method_10263() + addX), (double)(firstBlockPos.method_10264() + addY), (double)(firstBlockPos.method_10260() + addZ)), new class_243((double)(secondBlockPos.method_10263() + addX), (double)(secondBlockPos.method_10264() + addY), (double)(secondBlockPos.method_10260() + addZ)))));
                    }
                }
            }
        } else {
            int compareAny = 4;
            class_638 level = class_310.method_1551().field_1687;
            MaskElement maskElement = MaskManager.getSelectionMask();
            assert (level != null);
            class_2338 pos1 = this.firstGizmo.getTargetPosition();
            class_2338 pos2 = this.secondGizmo.getTargetPosition();
            int minX = Math.min(pos1.method_10263(), pos2.method_10263());
            int minY = Math.min(pos1.method_10264(), pos2.method_10264());
            int minZ = Math.min(pos1.method_10260(), pos2.method_10260());
            int maxX = Math.max(pos1.method_10263(), pos2.method_10263());
            int maxY = Math.max(pos1.method_10264(), pos2.method_10264());
            int maxZ = Math.max(pos1.method_10260(), pos2.method_10260());
            for (int x = minX; x <= maxX; ++x) {
                for (int y = minY; y <= maxY; ++y) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        if (this.isAir(x, y, z, (class_1937)level) || this.isInAnyPositionSet(x, y, z)) continue;
                        PositionSet positionSet = new PositionSet();
                        MagicSelectionTask task = new MagicSelectionTask(positionSet, (class_1937)level, new class_2338(x, y, z), compareAny, maskElement, this.getPropagationFlags());
                        task.fill((int)this.limit[0]);
                        this.blueprintQueue.add(new BlueprintPositionSet(positionSet));
                    }
                }
            }
        }
        this.suffixOffset = this.getSuffixOffset();
        this.blueprintCreationOngoing = true;
    }

    private boolean isAir(int x, int y, int z, @NotNull class_1937 level) {
        class_2680 state = level.method_8320(new class_2338(x, y, z));
        return state.method_26215() || state.method_27852(class_2246.field_10243) || state.method_27852(class_2246.field_10543);
    }

    private boolean isInAnyPositionSet(int x, int y, int z) {
        for (BlueprintPositionSet blueprintPositionSet : this.blueprintQueue) {
            if (!blueprintPositionSet.positions().contains(x, y, z)) continue;
            return true;
        }
        return false;
    }

    private PositionSet getPositionSetFromAABB(class_243 first, class_243 second) {
        PositionSet positionSet = new PositionSet();
        int minX = (int)Math.min(first.field_1352, second.field_1352);
        int minY = (int)Math.min(first.field_1351, second.field_1351);
        int minZ = (int)Math.min(first.field_1350, second.field_1350);
        int maxX = (int)Math.max(first.field_1352, second.field_1352);
        int maxY = (int)Math.max(first.field_1351, second.field_1351);
        int maxZ = (int)Math.max(first.field_1350, second.field_1350);
        MaskElement maskElement = MaskManager.getSelectionMask();
        MaskContext maskContext = new MaskContext((class_1937)class_310.method_1551().field_1687);
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    if (maskElement instanceof ConstantMaskElement) {
                        ConstantMaskElement constantMaskElement = (ConstantMaskElement)maskElement;
                        if (!constantMaskElement.getConstant()) continue;
                        positionSet.add(x, y, z);
                        continue;
                    }
                    if (!maskElement.test(maskContext.reset(), x, y, z)) continue;
                    positionSet.add(x, y, z);
                }
            }
        }
        return positionSet;
    }

    private int getPropagationFlags() {
        int flags = 0;
        flags |= MagicSelectionTask.PROPAGATION_FLAG_UP;
        flags |= MagicSelectionTask.PROPAGATION_FLAG_DOWN;
        flags |= MagicSelectionTask.PROPAGATION_FLAG_HORIZONTAL;
        return flags |= MagicSelectionTask.PROPAGATION_FLAG_CORNERS;
    }

    private void createNextBlueprint() {
        ++this.nextBlueprint;
        Selection.clearSelection();
        Selection.addSet((PositionSet)this.blueprintQueue.get(this.currentBlueprint).positions());
        this.callCopy(Selection.getSelectionBuffer(), this.saveAir, this.saveEntities);
    }

    private void callCopy(SelectionBuffer buffer, boolean copyAir, boolean copyEntities) {
        class_638 level;
        float preferredYaw;
        class_1297 cameraEntity;
        if (!this.blueprintCreationOngoing) {
            return;
        }
        class_2338 center = buffer.center();
        if (center == null) {
            return;
        }
        if (Placement.INSTANCE.isPlacing()) {
            Placement.INSTANCE.stopPlacement();
        }
        if ((cameraEntity = class_310.method_1551().method_1560()) != null) {
            double dx = cameraEntity.method_23317() - (double)center.method_10263();
            double dz = cameraEntity.method_23321() - (double)center.method_10260();
            preferredYaw = (float)(-Math.toDegrees(Math.atan2(dx, dz)));
        } else {
            preferredYaw = 135.0f;
        }
        ArrayList<UUID> requestedEntities = new ArrayList<UUID>();
        if (copyEntities && (level = class_310.method_1551().field_1687) != null) {
            for (class_1297 entity : level.method_18112()) {
                if (entity == null || entity.method_31481() || !entity.method_5864().method_5893() || !buffer.contains(entity.method_31477(), entity.method_31478(), entity.method_31479())) continue;
                requestedEntities.add(entity.method_5667());
            }
        }
        buffer.callCopy(false, copyAir).thenAccept(copyResult -> {
            if (copyResult != null && !copyResult.chunkedBlockRegion().isEmpty()) {
                if (requestedEntities.isEmpty()) {
                    Clipboard.INSTANCE.setClipboard(copyResult.chunkedBlockRegion(), copyResult.blockEntities(), List.of(), "", preferredYaw, copyAir);
                    this.blueprintPreview = new BlueprintPreview();
                    this.blueprintPreview.setBlockRegion(copyResult.chunkedBlockRegion());
                    this.blueprintPreviewRegion = copyResult.chunkedBlockRegion();
                } else {
                    Dispatcher.requestEntityData((List)requestedEntities, entityData -> {
                        ArrayList entities = new ArrayList(entityData.values());
                        for (class_2487 entity : entities) {
                            EntityDataUtils.offsetEntityRecursive((class_2487)entity, (class_243)class_243.method_24953((class_2382)copyResult.realOffset()));
                        }
                        Clipboard.INSTANCE.setClipboard(copyResult.chunkedBlockRegion(), copyResult.blockEntities(), entities, "", preferredYaw, copyAir);
                        this.blueprintPreview = new BlueprintPreview();
                        this.blueprintPreview.setBlockRegion(copyResult.chunkedBlockRegion());
                        this.blueprintPreviewRegion = copyResult.chunkedBlockRegion();
                    });
                }
            } else {
                ++this.currentBlueprint;
            }
        });
    }

    private class_1011 tryGetImage() {
        if (this.maxImageCounter > 10) {
            this.maxImageCounter = 0;
            this.blueprintPreviewFuture = null;
            return new class_1011(96, 96, true);
        }
        if (this.blueprintPreviewFuture != null) {
            if (this.blueprintPreviewFuture.isDone()) {
                class_1011 nativeImage = this.blueprintPreviewFuture.join();
                this.blueprintPreviewFuture = null;
                return nativeImage;
            }
            ++this.maxImageCounter;
            return null;
        }
        if (this.blueprintPreviewRegion.count() < 0x1000000) {
            this.blueprintPreview.render(960, false, false);
            this.blueprintPreviewFuture = this.blueprintPreview.toNativeImage(96, true);
            return null;
        }
        return new class_1011(96, 96, true);
    }

    public String name() {
        return "DBTools: Creation";
    }

    public void writeSourceInfo(class_2487 tag, boolean includeSettings) {
        throw new UnsupportedOperationException("Blueprint Creation Tool is not a source");
    }

    public char iconChar() {
        return this.iconChar;
    }

    public void writeSettings(class_2487 tag) {
    }

    public void loadSettings(class_2487 tag) {
    }

    public String keybindId() {
        return "";
    }

    public EnumSet<AxiomPermission> requiredPermissions() {
        return EnumSet.of(AxiomPermission.TOOL, AxiomPermission.BUILD_SECTION);
    }

    @Environment(value=EnvType.CLIENT)
    private record BlueprintPositionSet(PositionSet positions) {
    }
}

