/*
 * Decompiled with CFR 0.152.
 */
package com.denni5x.dbtools.client.RuinsTool;

import com.moulberry.axiom.RayCaster;
import com.moulberry.axiom.UserAction;
import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.editor.widgets.BrushWidget;
import com.moulberry.axiom.editor.widgets.PresetWidget;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.mask.MaskContext;
import com.moulberry.axiom.mask.MaskElement;
import com.moulberry.axiom.mask.MaskManager;
import com.moulberry.axiom.noise.SimplexDomainWarp;
import com.moulberry.axiom.pather.async.AsyncToolPathProvider;
import com.moulberry.axiom.pather.async.AsyncToolPather;
import com.moulberry.axiom.pather.async.AsyncToolPatherMinSDF;
import com.moulberry.axiom.pather.async.AsyncToolPatherUnique;
import com.moulberry.axiom.render.ChunkRenderOverrider;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.restrictions.AxiomPermission;
import com.moulberry.axiom.tools.Tool;
import com.moulberry.axiom.utils.RegionHelper;
import imgui.ImGui;
import it.unimi.dsi.fastutil.objects.Object2FloatArrayMap;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import java.text.NumberFormat;
import java.util.EnumSet;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import org.joml.Matrix4f;
import org.joml.Vector3d;

@Environment(value=EnvType.CLIENT)
public class RuinsTool
implements Tool {
    private final ChunkedBlockRegion blockRegion = new ChunkedBlockRegion();
    private final ChunkedBlockRegion gravityRegion = new ChunkedBlockRegion();
    private boolean usingTool = false;
    private AsyncToolPathProvider pathProvider = null;
    private final BrushWidget brushWidget = new BrushWidget();
    private final float[] distance = new float[]{2.0f};
    private final int[] scale = new int[]{16};
    private final int[] iterations = new int[]{2};
    private final int[] seed = new int[]{0};
    private boolean separateAxis = false;
    private final float[] distanceX = new float[]{2.0f};
    private final float[] distanceY = new float[]{2.0f};
    private final float[] distanceZ = new float[]{2.0f};
    private boolean smoothEdges = true;
    private final PresetWidget presetWidget = new PresetWidget((Tool)this, "ruins");
    private static final class_2680 AIR = class_2246.field_10124.method_9564();

    public void reset() {
        if (this.usingTool) {
            this.usingTool = false;
            ChunkRenderOverrider.INSTANCE.release("ruins");
        }
        this.blockRegion.clear();
        if (this.pathProvider != null) {
            this.pathProvider.close();
            this.pathProvider = null;
        }
    }

    public UserAction.ActionResult callAction(UserAction action, Object object) {
        switch (action) {
            case RIGHT_MOUSE: {
                float amplitudeZ;
                float amplitudeY;
                float amplitudeX;
                class_638 level;
                this.reset();
                if (!this.usingTool) {
                    this.usingTool = true;
                    ChunkRenderOverrider.INSTANCE.acquire("ruins");
                }
                if ((level = class_310.method_1551().field_1687) == null) {
                    return UserAction.ActionResult.NOT_HANDLED;
                }
                class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
                int iterations = this.iterations[0];
                if (this.separateAxis) {
                    amplitudeX = this.distanceX[0] * 50.0f / (float)iterations;
                    amplitudeY = this.distanceY[0] * 50.0f / (float)iterations;
                    amplitudeZ = this.distanceZ[0] * 50.0f / (float)iterations;
                } else {
                    amplitudeY = amplitudeZ = this.distance[0] * 50.0f / (float)iterations;
                    amplitudeX = amplitudeZ;
                }
                float frequency = 1.0f / (float)this.scale[0];
                int seed = this.seed[0];
                AsyncToolPather pather = this.smoothEdges ? this.createToolPatherSmoothEdges(level, mutableBlockPos, iterations, amplitudeX, amplitudeY, amplitudeZ, frequency, seed) : this.createToolPatherNoSmoothEdges(level, mutableBlockPos, iterations, amplitudeX, amplitudeY, amplitudeZ, frequency, seed);
                this.pathProvider = new AsyncToolPathProvider(pather);
                return UserAction.ActionResult.USED_STOP;
            }
            case ESCAPE: {
                if (!this.usingTool) break;
                this.reset();
                return UserAction.ActionResult.USED_STOP;
            }
        }
        return UserAction.ActionResult.NOT_HANDLED;
    }

    public void render(class_4184 camera, float tickDelta, long time, class_4587 matrix, Matrix4f projection) {
        if (!this.usingTool) {
            RayCaster.RaycastResult result = Tool.raycastBlock();
            if (result == null) {
                Selection.render((class_4184)camera, (long)time, (class_4587)matrix, (Matrix4f)projection, (int)7);
                return;
            }
            Selection.render((class_4184)camera, (long)time, (class_4587)matrix, (Matrix4f)projection, (int)4);
            this.brushWidget.renderPreview(camera, class_243.method_24954((class_2382)result.getBlockPos()), matrix, projection, time, 3);
        } else if (Tool.cancelUsing()) {
            this.reset();
        } else if (!Tool.isMouseDown((int)1)) {
            String countString = NumberFormat.getInstance().format(this.blockRegion.count());
            String historyDescription = "Ruined " + countString + " blocks";
            RegionHelper.pushBlockRegionChange((ChunkedBlockRegion)this.applyGravity(this.blockRegion), (String)historyDescription);
            this.reset();
        } else {
            this.pathProvider.update();
            float opacity = (float)Math.sin((float)time / 1000000.0f / 50.0f / 8.0f);
            this.blockRegion.render(camera, class_243.field_1353, matrix, projection, 0.75f + opacity * 0.25f, 0.3f - opacity * 0.2f);
        }
    }

    private ChunkedBlockRegion applyGravity(ChunkedBlockRegion localRegion) {
        if (localRegion.max() == null) {
            return localRegion;
        }
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return localRegion;
        }
        ChunkedBlockRegion returnRegion = new ChunkedBlockRegion();
        int maxY = Objects.requireNonNull(localRegion.max()).method_10264();
        int minY = localRegion.method_31607();
        while (minY <= maxY) {
            int finalMinY = minY++;
            localRegion.forEachEntry((arg_0, arg_1, arg_2, arg_3) -> RuinsTool.lambda$applyGravity$0(finalMinY, returnRegion, (class_1937)level, localRegion, arg_0, arg_1, arg_2, arg_3));
        }
        return returnRegion;
    }

    private AsyncToolPather createToolPatherNoSmoothEdges(class_638 level, class_2338.class_2339 mutableBlockPos, int iterations, float amplitudeX, float amplitudeY, float amplitudeZ, float frequency, int seed) {
        MaskElement sourceMaskElement = MaskManager.getSourceMask();
        MaskElement destMaskElement = MaskManager.getDestMask();
        MaskContext maskContext = new MaskContext((class_1937)level);
        class_2680 air = class_2246.field_10124.method_9564();
        return new AsyncToolPatherUnique(this.brushWidget.getBrushShape(), (x, y, z) -> {
            if (destMaskElement.test(maskContext.reset(), x, y, z)) {
                Vector3d vector3d = new Vector3d((double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
                for (int i = 0; i < iterations; ++i) {
                    SimplexDomainWarp.SingleDomainWarpOpenSimplex2Gradient((int)seed, (float)amplitudeX, (float)amplitudeY, (float)amplitudeZ, (float)frequency, (Vector3d)vector3d);
                }
                float replacableWeight = 0.0f;
                float nonreplacableWeight = 0.0f;
                Object2FloatArrayMap blockWeights = new Object2FloatArrayMap();
                int blockX = (int)Math.floor(vector3d.x);
                int blockY = (int)Math.floor(vector3d.y);
                int blockZ = (int)Math.floor(vector3d.z);
                float fracX = (float)(vector3d.x - (double)blockX);
                float fracY = (float)(vector3d.y - (double)blockY);
                float fracZ = (float)(vector3d.z - (double)blockZ);
                for (int xo = -1; xo <= 1; ++xo) {
                    float weightX = 1.0f - Math.min(1.0f, Math.abs((float)xo - fracX + 0.5f));
                    for (int yo = -1; yo <= 1; ++yo) {
                        float weightXY = weightX * (1.0f - Math.min(1.0f, Math.abs((float)yo - fracY + 0.5f)));
                        for (int zo = -1; zo <= 1; ++zo) {
                            float weightXYZ = weightXY * (1.0f - Math.min(1.0f, Math.abs((float)zo - fracZ + 0.5f)));
                            if (weightXYZ <= 0.0f) continue;
                            class_2680 blockState = !sourceMaskElement.test(maskContext.reset(), blockX + xo, blockY + yo, blockZ + zo) ? air : level.method_8320((class_2338)mutableBlockPos.method_10103(blockX + xo, blockY + yo, blockZ + zo));
                            if (blockState.method_26215()) {
                                blockState = class_2246.field_10124.method_9564();
                            }
                            if (blockState.method_45474()) {
                                replacableWeight += weightXYZ;
                            } else {
                                nonreplacableWeight += weightXYZ;
                            }
                            blockWeights.computeFloat((Object)blockState, (block, value) -> Float.valueOf(value == null ? weightXYZ : value.floatValue() + weightXYZ));
                        }
                    }
                }
                boolean useCanBeReplaced = replacableWeight >= nonreplacableWeight;
                class_2680 closestState = AIR;
                float closestWeight = Float.MIN_VALUE;
                for (Object2FloatMap.Entry blockStateEntry : blockWeights.object2FloatEntrySet()) {
                    class_2680 blockState = (class_2680)blockStateEntry.getKey();
                    if (blockState.method_45474() != useCanBeReplaced || !(blockStateEntry.getFloatValue() > closestWeight)) continue;
                    closestState = blockState;
                    closestWeight = blockStateEntry.getFloatValue();
                }
                if (!closestState.method_26216()) {
                    ChunkRenderOverrider.INSTANCE.setBlock(x, y, z, AIR);
                }
                this.blockRegion.addBlock(x, y, z, closestState);
            }
        });
    }

    private AsyncToolPather createToolPatherSmoothEdges(class_638 level, class_2338.class_2339 mutableBlockPos, int iterations, float amplitudeX, float amplitudeY, float amplitudeZ, float frequency, int seed) {
        MaskElement sourceMaskElement = MaskManager.getSourceMask();
        MaskElement destMaskElement = MaskManager.getDestMask();
        MaskContext maskContext = new MaskContext((class_1937)level);
        class_2680 air = class_2246.field_10124.method_9564();
        return new AsyncToolPatherMinSDF(this.brushWidget.getBrushShape(), (x, y, z, distance) -> {
            if (destMaskElement.test(maskContext.reset(), x, y, z)) {
                float falloff = 0.0f;
                if ((double)distance > 0.6) {
                    falloff = (distance - 0.6f) / 0.4f;
                }
                float scaledAmplitudeX = amplitudeX * (1.0f - falloff);
                float scaledAmplitudeY = amplitudeY * (1.0f - falloff);
                float scaledAmplitudeZ = amplitudeZ * (1.0f - falloff);
                Vector3d vector3d = new Vector3d((double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
                for (int i = 0; i < iterations; ++i) {
                    SimplexDomainWarp.SingleDomainWarpOpenSimplex2Gradient((int)seed, (float)scaledAmplitudeX, (float)scaledAmplitudeY, (float)scaledAmplitudeZ, (float)frequency, (Vector3d)vector3d);
                }
                float replacableWeight = 0.0f;
                float nonreplacableWeight = 0.0f;
                Object2FloatArrayMap blockWeights = new Object2FloatArrayMap();
                int blockX = (int)Math.floor(vector3d.x);
                int blockY = (int)Math.floor(vector3d.y);
                int blockZ = (int)Math.floor(vector3d.z);
                float fracX = (float)(vector3d.x - (double)blockX);
                float fracY = (float)(vector3d.y - (double)blockY);
                float fracZ = (float)(vector3d.z - (double)blockZ);
                for (int xo = -1; xo <= 1; ++xo) {
                    float weightX = 1.0f - Math.min(1.0f, Math.abs((float)xo - fracX + 0.5f));
                    for (int yo = -1; yo <= 1; ++yo) {
                        float weightXY = weightX * (1.0f - Math.min(1.0f, Math.abs((float)yo - fracY + 0.5f)));
                        for (int zo = -1; zo <= 1; ++zo) {
                            float weightXYZ = weightXY * (1.0f - Math.min(1.0f, Math.abs((float)zo - fracZ + 0.5f)));
                            class_2680 blockState = !sourceMaskElement.test(maskContext.reset(), blockX + xo, blockY + yo, blockZ + zo) ? air : level.method_8320((class_2338)mutableBlockPos.method_10103(blockX + xo, blockY + yo, blockZ + zo));
                            if (blockState.method_26215()) {
                                blockState = class_2246.field_10124.method_9564();
                            }
                            if (blockState.method_45474()) {
                                replacableWeight += weightXYZ;
                            } else {
                                nonreplacableWeight += weightXYZ;
                            }
                            blockWeights.computeFloat((Object)blockState, (block, value) -> Float.valueOf(value == null ? weightXYZ : value.floatValue() + weightXYZ));
                        }
                    }
                }
                boolean useCanBeReplaced = replacableWeight >= nonreplacableWeight;
                class_2680 closestState = class_2246.field_10124.method_9564();
                float closestWeight = Float.MIN_VALUE;
                for (Object2FloatMap.Entry blockStateEntry : blockWeights.object2FloatEntrySet()) {
                    class_2680 blockState = (class_2680)blockStateEntry.getKey();
                    if (blockState.method_45474() != useCanBeReplaced || !(blockStateEntry.getFloatValue() > closestWeight)) continue;
                    closestState = blockState;
                    closestWeight = blockStateEntry.getFloatValue();
                }
                if (!closestState.method_26216()) {
                    ChunkRenderOverrider.INSTANCE.setBlock(x, y, z, AIR);
                }
                this.blockRegion.addBlock(x, y, z, closestState);
            }
        });
    }

    public void displayImguiOptions() {
        ImGuiHelper.separatorWithText((String)AxiomI18n.get((String)"axiom.tool.generic.brush"));
        boolean changed = this.brushWidget.displayImgui();
        ImGuiHelper.separatorWithText((String)AxiomI18n.get((String)"axiom.tool.distort.distortion"));
        changed |= ImGui.sliderInt((String)AxiomI18n.get((String)"axiom.tool.distort.scale"), (int[])this.scale, (int)2, (int)32);
        if (this.separateAxis) {
            changed |= ImGui.sliderFloat((String)AxiomI18n.get((String)"axiom.tool.distort.distance_x"), (float[])this.distanceX, (float)0.0f, (float)16.0f, (String)"%.2f");
            changed |= ImGui.sliderFloat((String)AxiomI18n.get((String)"axiom.tool.distort.distance_y"), (float[])this.distanceY, (float)0.0f, (float)16.0f, (String)"%.2f");
            changed |= ImGui.sliderFloat((String)AxiomI18n.get((String)"axiom.tool.distort.distance_z"), (float[])this.distanceZ, (float)0.0f, (float)16.0f, (String)"%.2f");
        } else {
            changed |= ImGui.sliderFloat((String)AxiomI18n.get((String)"axiom.tool.distort.distance"), (float[])this.distance, (float)1.0f, (float)16.0f, (String)"%.2f");
        }
        changed |= ImGui.sliderInt((String)AxiomI18n.get((String)"axiom.tool.distort.iterations"), (int[])this.iterations, (int)1, (int)5);
        if (ImGui.checkbox((String)AxiomI18n.get((String)"axiom.tool.distort.separate_axis"), (boolean)this.separateAxis)) {
            boolean bl = this.separateAxis = !this.separateAxis;
            if (this.separateAxis) {
                this.distanceX[0] = this.distance[0];
                this.distanceY[0] = this.distance[0];
                this.distanceZ[0] = this.distance[0];
            } else {
                this.distance[0] = (this.distanceX[0] + this.distanceY[0] + this.distanceZ[0]) / 3.0f;
            }
            changed = true;
        }
        ImGuiHelper.separatorWithText((String)AxiomI18n.get((String)"axiom.tool.generic.noise"));
        changed |= ImGuiHelper.inputInt((String)AxiomI18n.get((String)"axiom.tool.generic.noise_seed"), (int[])this.seed);
        if (ImGui.button((String)AxiomI18n.get((String)"axiom.tool.generic.noise_seed_do_randomize"))) {
            this.seed[0] = ThreadLocalRandom.current().nextInt();
            changed = true;
        }
        ImGuiHelper.separatorWithText((String)AxiomI18n.get((String)"axiom.tool.generic.advanced_options"));
        if (ImGui.checkbox((String)AxiomI18n.get((String)"axiom.tool.distort.smooth_edges"), (boolean)this.smoothEdges)) {
            this.smoothEdges = !this.smoothEdges;
            changed = true;
        }
        ImGuiHelper.separatorWithText((String)AxiomI18n.get((String)"axiom.widget.presets"));
        this.presetWidget.displayImgui(changed);
    }

    public String listenForEsc() {
        return !this.usingTool ? null : AxiomI18n.get((String)"axiom.widget.cancel");
    }

    public boolean initiateAdjustment() {
        return this.brushWidget.initiateAdjustment();
    }

    public class_241 renderAdjustment(float mouseX, float mouseY, class_241 mouseDelta) {
        return this.brushWidget.renderAdjustment(mouseX, mouseY, mouseDelta);
    }

    public String name() {
        return "DBTools: Ruins Tool";
    }

    public void writeSourceInfo(class_2487 tag, boolean includeSettings) {
        tag.method_10582("SourceName", "Ruins Tool");
        if (includeSettings) {
            class_2487 settings = new class_2487();
            this.writeSettings(settings);
            tag.method_10566("SourceSettings", (class_2520)settings);
        }
    }

    public void writeSettings(class_2487 tag) {
        this.brushWidget.writeSettings(tag);
        tag.method_10569("RuinsScale", this.scale[0]);
        tag.method_10556("SeparateAxis", this.separateAxis);
        if (this.separateAxis) {
            tag.method_10548("DistanceX", this.distanceX[0]);
            tag.method_10548("DistanceY", this.distanceY[0]);
            tag.method_10548("DistanceZ", this.distanceZ[0]);
        } else {
            tag.method_10548("Distance", this.distance[0]);
        }
        tag.method_10567("Iterations", (byte)this.iterations[0]);
        tag.method_10569("Seed", this.seed[0]);
        tag.method_10556("SmoothEdges", this.smoothEdges);
    }

    public void loadSettings(class_2487 nbtCompound) {
    }

    public char iconChar() {
        return '\u0000';
    }

    public String keybindId() {
        return "";
    }

    public EnumSet<AxiomPermission> requiredPermissions() {
        return EnumSet.of(AxiomPermission.TOOL, AxiomPermission.BUILD_SECTION);
    }

    private static /* synthetic */ void lambda$applyGravity$0(int finalMinY, ChunkedBlockRegion returnRegion, class_1937 level, ChunkedBlockRegion localRegion, int x, int y, int z, class_2680 blockState) {
        if (y < finalMinY) {
            return;
        }
        if (blockState.method_26215()) {
            returnRegion.addBlock(x, y, z, blockState);
            return;
        }
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        for (int searchY = 1; searchY < 256; ++searchY) {
            class_2680 belowLevel = level.method_8320((class_2338)mutableBlockPos.method_10103(x, y - searchY, z));
            class_2680 belowTool = localRegion.method_8320((class_2338)mutableBlockPos.method_10103(x, y - searchY, z));
            if (belowLevel.method_26204() != class_2246.field_10243 && belowLevel.method_45474() || belowTool.method_26204() != class_2246.field_10243 && belowTool.method_45474()) continue;
            returnRegion.addBlock(x, y - searchY + 1, z, blockState);
            returnRegion.addBlock(x, y + 1, z, class_2246.field_10124.method_9564());
            break;
        }
    }
}

