/*
 * Decompiled with CFR 0.152.
 */
package com.denni5x.dbtools.client.BlueprintTools;

import com.denni5x.dbtools.client.DBToolsClient;
import com.denni5x.dbtools.client.Utils.BlueprintUtils;
import com.denni5x.dbtools.client.Utils.CreateBpToPathAdditionalUndoOperation;
import com.moulberry.axiom.RayCaster;
import com.moulberry.axiom.UserAction;
import com.moulberry.axiom.VersionUtilsNbt;
import com.moulberry.axiom.clipboard.Clipboard;
import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.collections.PositionSet;
import com.moulberry.axiom.core_rendering.AxiomRenderPipeline;
import com.moulberry.axiom.core_rendering.AxiomRenderPipelines;
import com.moulberry.axiom.core_rendering.AxiomRenderer;
import com.moulberry.axiom.custom_blocks.CustomBlockState;
import com.moulberry.axiom.custom_blocks.ServerCustomBlocks;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.editor.EditorWindowType;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.editor.keybinds.Keybinds;
import com.moulberry.axiom.editor.widgets.PresetWidget;
import com.moulberry.axiom.gizmo.ExtrudedGizmo;
import com.moulberry.axiom.gizmo.Gizmo;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.mask.MaskContext;
import com.moulberry.axiom.mask.MaskElement;
import com.moulberry.axiom.mask.MaskManager;
import com.moulberry.axiom.render.ChunkRenderOverrider;
import com.moulberry.axiom.render.Shapes;
import com.moulberry.axiom.render.VertexConsumerProvider;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.restrictions.AxiomPermission;
import com.moulberry.axiom.tools.Tool;
import com.moulberry.axiom.tools.path.CatmullRomSpline;
import com.moulberry.axiom.tools.path.Easings;
import com.moulberry.axiom.tools.path.PointConfig;
import com.moulberry.axiom.utils.BezierOperator;
import com.moulberry.axiom.utils.NbtHelper;
import com.moulberry.axiom.utils.RegionHelper;
import com.moulberry.axiom.world_modification.HistoryEntry;
import com.moulberry.axiom.world_modification.undo.AdditionalUndoOperation;
import imgui.ImGui;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.floats.FloatUnaryOperator;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2404;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

@Environment(value=EnvType.CLIENT)
public class BpToPathTool
implements Tool {
    private final ChunkedBlockRegion chunkedBlockRegion = new ChunkedBlockRegion();
    private final List<Gizmo> gizmos = new ArrayList<Gizmo>();
    private final int[] curveType = new int[]{0};
    private final List<PointConfig> pointConfigs = new ArrayList<PointConfig>();
    private final PresetWidget presetWidget = new PresetWidget((Tool)this, "BPToPath");
    private boolean extendToGround = false;
    private boolean recalculate = false;
    private class_2680 lastActiveBlock = null;
    private boolean maskWindowOpen = false;
    private ExtrudedGizmo extrudedGizmo = null;
    private final int[] slack = new int[]{20};
    private boolean looped = false;
    private final int[] distance = new int[]{10};
    private int activePoint = -1;
    private int justDeselectedPoint = -1;
    private boolean inverted = false;
    private boolean keepExisting = false;
    private static final int CURVE_TYPE_DDA = 0;
    private static final int CURVE_TYPE_CATENARY = 1;
    private static final int CURVE_TYPE_CATMULLROM = 2;
    private static final int CURVE_TYPE_BEZIER = 3;
    private final char iconChar;

    public BpToPathTool(char iconChar) {
        this.iconChar = iconChar;
    }

    private static double atanh(double v) {
        return 0.5 * Math.log((1.0 + v) / (1.0 - v));
    }

    private static double findBigA(double r) {
        double bigA = r < 3.0 ? Math.sqrt(6.0 * (r - 1.0)) : Math.log(2.0 * r) + Math.log(Math.log(2.0 * r));
        for (int i = 0; i < 5; ++i) {
            bigA -= (Math.sinh(bigA) - r * bigA) / (Math.cosh(bigA) - r);
        }
        return bigA;
    }

    public void reset() {
        this.gizmos.clear();
        this.pointConfigs.clear();
        this.chunkedBlockRegion.clear();
        this.activePoint = -1;
        this.recalculate = true;
    }

    public void restore(List<class_2338> positions, List<PointConfig> pointConfigs, int curveType, boolean looped, boolean inverted, int slack, boolean keepExisting, boolean extendToGround) {
        this.reset();
        for (class_2338 position : positions) {
            this.gizmos.add(new Gizmo(position));
        }
        for (PointConfig pointConfig : pointConfigs) {
            this.pointConfigs.add(new PointConfig(pointConfig));
        }
        this.extendToGround = extendToGround;
        this.curveType[0] = curveType;
        this.looped = looped;
        this.inverted = inverted;
        this.slack[0] = slack;
        this.keepExisting = keepExisting;
    }

    public void markDirty() {
        this.recalculate = true;
    }

    public UserAction.ActionResult callAction(UserAction action, Object object) {
        assert (class_310.method_1551().field_1724 != null);
        switch (action) {
            case EXTRUDE: {
                for (Gizmo gizmo : this.gizmos) {
                    if (!gizmo.enableAxes) continue;
                    this.extrudedGizmo = new ExtrudedGizmo(class_310.method_1551().field_1724, gizmo);
                    gizmo.enableAxes = false;
                    return UserAction.ActionResult.USED_STOP;
                }
                break;
            }
            case ENTER: {
                if (this.extrudedGizmo != null) {
                    this.finishExtrudeGizmo();
                    return UserAction.ActionResult.USED_STOP;
                }
                if (this.gizmos.isEmpty()) {
                    return UserAction.ActionResult.NOT_HANDLED;
                }
                this.pastePath();
                this.gizmos.clear();
                this.chunkedBlockRegion.clear();
                this.activePoint = -1;
                this.recalculate = true;
                return UserAction.ActionResult.USED_STOP;
            }
            case RIGHT_MOUSE: {
                if (Clipboard.INSTANCE.isEmpty()) {
                    return UserAction.ActionResult.NOT_HANDLED;
                }
                if (this.extrudedGizmo != null) {
                    this.finishExtrudeGizmo();
                    return UserAction.ActionResult.USED_STOP;
                }
                RayCaster.RaycastResult result = Tool.raycastBlock((boolean)false, (boolean)true, (boolean)true);
                if (result != null) {
                    if (this.gizmos.size() >= this.getPointLimit()) {
                        return UserAction.ActionResult.USED_STOP;
                    }
                    this.recalculate = true;
                    for (Gizmo gizmo : this.gizmos) {
                        gizmo.enableAxes = false;
                    }
                    int activePoint = this.activePoint;
                    if (activePoint < 0) {
                        activePoint = this.justDeselectedPoint;
                    }
                    if (activePoint >= 0 && activePoint < this.gizmos.size() - 1) {
                        this.gizmos.add(activePoint + 1, new Gizmo(result.getBlockPos()));
                        if (this.pointConfigs.size() < this.gizmos.size()) {
                            this.pointConfigs.add(activePoint + 1, new PointConfig(false, false, (CustomBlockState)class_2246.field_10340.method_9564(), 0));
                        }
                        this.activePoint = activePoint + 1;
                    } else {
                        this.gizmos.add(new Gizmo(result.getBlockPos()));
                        while (this.pointConfigs.size() < this.gizmos.size()) {
                            this.pointConfigs.add(new PointConfig(false, false, (CustomBlockState)class_2246.field_10340.method_9564(), 0));
                        }
                        this.activePoint = this.gizmos.size() - 1;
                    }
                }
                return UserAction.ActionResult.USED_STOP;
            }
            case LEFT_MOUSE: {
                if (this.extrudedGizmo != null) {
                    this.finishExtrudeGizmo();
                    return UserAction.ActionResult.USED_STOP;
                }
                for (Gizmo gizmo : this.gizmos) {
                    if (!gizmo.enableAxes || !gizmo.leftClick()) continue;
                    return UserAction.ActionResult.USED_STOP;
                }
                Gizmo disableExcept = null;
                for (int i = 0; i < this.gizmos.size(); ++i) {
                    Gizmo gizmo = this.gizmos.get(i);
                    if (gizmo.enableAxes || !gizmo.leftClick()) continue;
                    this.activePoint = i;
                    disableExcept = gizmo;
                    break;
                }
                if (disableExcept != null) {
                    for (Gizmo gizmo : this.gizmos) {
                        if (gizmo == disableExcept) continue;
                        gizmo.enableAxes = false;
                    }
                    return UserAction.ActionResult.USED_STOP;
                }
                if (!EditorUI.isCtrlOrCmdDown()) {
                    if (this.activePoint >= 0) {
                        this.justDeselectedPoint = this.activePoint;
                    }
                    for (Gizmo gizmo : this.gizmos) {
                        gizmo.enableAxes = false;
                    }
                    this.activePoint = -1;
                }
                return UserAction.ActionResult.NOT_HANDLED;
            }
            case ESCAPE: {
                if (this.extrudedGizmo != null) {
                    this.extrudedGizmo = null;
                    return UserAction.ActionResult.USED_STOP;
                }
                if (this.activePoint < 0 || this.activePoint >= this.gizmos.size()) break;
                for (Gizmo gizmo : this.gizmos) {
                    gizmo.enableAxes = false;
                }
                this.activePoint = -1;
                return UserAction.ActionResult.USED_STOP;
            }
            case DELETE: {
                if (this.activePoint >= 0 && this.activePoint < this.gizmos.size()) {
                    this.gizmos.remove(this.activePoint);
                    this.pointConfigs.remove(this.activePoint);
                    this.activePoint = -1;
                    this.recalculate = true;
                    return UserAction.ActionResult.USED_STOP;
                }
                if (this.gizmos.isEmpty()) break;
                this.reset();
                return UserAction.ActionResult.USED_STOP;
            }
        }
        return UserAction.ActionResult.NOT_HANDLED;
    }

    private void pastePath() {
        this.recalculate();
        if (!this.chunkedBlockRegion.isEmpty()) {
            int modifiers = this.keepExisting ? HistoryEntry.MODIFIER_KEEP_EXISTING : 0;
            String countString = NumberFormat.getInstance().format(this.chunkedBlockRegion.count());
            String historyDescription = AxiomI18n.get((String)"axiom.history_description.placed", (Object[])new Object[]{countString});
            ArrayList<class_2338> positions = new ArrayList<class_2338>();
            ArrayList<PointConfig> pointConfigs = new ArrayList<PointConfig>();
            for (Gizmo gizmo : this.gizmos) {
                positions.add(gizmo.getTargetPosition());
            }
            for (PointConfig pointConfig : this.pointConfigs) {
                pointConfigs.add(new PointConfig(pointConfig));
            }
            CreateBpToPathAdditionalUndoOperation operation = new CreateBpToPathAdditionalUndoOperation(positions, pointConfigs, this.curveType[0], this.looped, false, this.slack[0], this.keepExisting, false);
            RegionHelper.pushBlockRegionChange((ChunkedBlockRegion)this.chunkedBlockRegion, null, (String)historyDescription, (int)modifiers, (AdditionalUndoOperation)operation);
        }
    }

    private void finishExtrudeGizmo() {
        class_243 lookDirection = Tool.getLookDirection();
        if (lookDirection != null && this.gizmos.size() < this.getPointLimit()) {
            this.recalculate = true;
            for (Gizmo gizmo : this.gizmos) {
                gizmo.enableAxes = false;
            }
            class_2338 pos = this.extrudedGizmo.getBlockPos(lookDirection);
            if (pos != null) {
                if (this.activePoint >= 0 && this.activePoint < this.gizmos.size() - 1) {
                    this.gizmos.add(this.activePoint + 1, new Gizmo(pos));
                    if (this.pointConfigs.size() < this.gizmos.size()) {
                        this.pointConfigs.add(this.activePoint + 1, new PointConfig(false, false, (CustomBlockState)class_2246.field_10340.method_9564(), 0));
                    }
                    ++this.activePoint;
                } else {
                    this.gizmos.add(new Gizmo(pos));
                    while (this.pointConfigs.size() < this.gizmos.size()) {
                        this.pointConfigs.add(new PointConfig(false, false, (CustomBlockState)class_2246.field_10340.method_9564(), 0));
                    }
                    this.activePoint = this.gizmos.size() - 1;
                }
            }
        }
        this.extrudedGizmo = null;
    }

    public void render(class_4184 camera, float tickDelta, long time, class_4587 matrices, Matrix4f projection) {
        RayCaster.RaycastResult raycastResult;
        boolean maskWindowOpen;
        boolean showGizmo;
        if (Clipboard.INSTANCE.isEmpty()) {
            return;
        }
        class_243 lookDirection = Tool.getLookDirection();
        boolean isLeftDown = Tool.isMouseDown((int)0);
        boolean isCtrlDown = EditorUI.isCtrlOrCmdDown();
        boolean renderGizmos = showGizmo = !EditorUI.isActive() || !isCtrlDown;
        Selection.render((class_4184)camera, (long)time, (class_4587)matrices, (Matrix4f)projection, (int)4);
        if (lookDirection != null && this.extrudedGizmo != null) {
            this.extrudedGizmo.render(matrices, camera, lookDirection);
        }
        int pointLimit = this.getPointLimit();
        while (this.gizmos.size() > pointLimit) {
            this.gizmos.removeLast();
            this.recalculate = true;
        }
        this.justDeselectedPoint = -1;
        boolean hasGrabbed = false;
        for (Gizmo gizmo : this.gizmos) {
            class_2338 before = gizmo.getTargetPosition();
            gizmo.update(time, lookDirection, isLeftDown, isCtrlDown, showGizmo);
            gizmo.setAxisDirections(camera.method_19326().field_1352 > (double)gizmo.getTargetPosition().method_10263(), camera.method_19326().field_1351 > (double)gizmo.getTargetPosition().method_10264(), camera.method_19326().field_1350 > (double)gizmo.getTargetPosition().method_10260());
            if (gizmo.isGrabbed()) {
                renderGizmos = true;
                hasGrabbed = true;
            }
            if (gizmo.getTargetPosition().equals((Object)before)) continue;
            this.recalculate = true;
        }
        if (!hasGrabbed && this.extrudedGizmo == null && this.gizmos.size() < this.getPointLimit()) {
            RayCaster.RaycastResult result = Tool.raycastBlock((boolean)false, (boolean)true, (boolean)true);
            Tool.renderRaycastOverlay((RayCaster.RaycastResult)result, (class_4587)matrices, (class_4184)camera);
        }
        if (Tool.getActiveBlock() != this.lastActiveBlock) {
            this.lastActiveBlock = Tool.getActiveBlock();
            this.recalculate = true;
        }
        if (this.maskWindowOpen != (maskWindowOpen = EditorWindowType.TOOL_MASKS.isOpen())) {
            this.maskWindowOpen = maskWindowOpen;
            this.recalculate = true;
        }
        if (this.recalculate) {
            this.recalculate();
        }
        matrices.method_22903();
        matrices.method_22904(-camera.method_19326().field_1352, -camera.method_19326().field_1351, -camera.method_19326().field_1350);
        class_2338 raycastPos = null;
        if (this.activePoint >= 0 && !hasGrabbed && this.extrudedGizmo == null && this.gizmos.size() < this.getPointLimit() && (raycastResult = Tool.raycastBlock()) != null) {
            raycastPos = raycastResult.blockPos();
        }
        this.drawPoints(matrices, raycastPos);
        matrices.method_22909();
        float opacity = (float)Math.sin((float)time / 1000000.0f / 50.0f / 8.0f);
        this.chunkedBlockRegion.render(camera, class_243.field_1353, matrices, projection, 0.75f + opacity * 0.25f, 0.3f - opacity * 0.2f);
        if (renderGizmos) {
            for (Gizmo gizmo : this.gizmos) {
                gizmo.render(matrices, camera, isCtrlDown);
            }
        }
    }

    private int getPointLimit() {
        return this.curveType[0] == 3 ? 50 : 256;
    }

    private void drawPoints(class_4587 matrices, class_2338 raycastPos) {
        VertexConsumerProvider provider = VertexConsumerProvider.shared();
        class_287 bufferBuilder = provider.begin(class_293.class_5596.field_27377, class_290.field_29337);
        class_4587.class_4665 pose = matrices.method_23760();
        int count = this.activePoint >= 0 && raycastPos != null ? this.gizmos.size() : this.gizmos.size() - 1;
        for (int i = 0; i < count; ++i) {
            class_243 to;
            class_243 from;
            if (this.activePoint >= 0 && raycastPos != null) {
                if (i == this.activePoint) {
                    from = this.gizmos.get(i).getInterpPosition();
                    to = class_243.method_24953((class_2382)raycastPos);
                } else if (i == this.activePoint + 1) {
                    from = class_243.method_24953((class_2382)raycastPos);
                    to = this.gizmos.get(i).getInterpPosition();
                } else if (i > this.activePoint + 1) {
                    from = this.gizmos.get(i - 1).getInterpPosition();
                    to = this.gizmos.get(i).getInterpPosition();
                } else {
                    from = this.gizmos.get(i).getInterpPosition();
                    to = this.gizmos.get(i + 1).getInterpPosition();
                }
            } else {
                from = this.gizmos.get(i).getInterpPosition();
                to = this.gizmos.get(i + 1).getInterpPosition();
            }
            Shapes.line((class_287)bufferBuilder, (class_4587.class_4665)pose, (class_243)from, (class_243)to);
        }
        class_287.class_7433 meshData = provider.build();
        AxiomRenderer.setShaderColour((float)1.0f, (float)0.1f, (float)0.1f, (float)1.0f);
        AxiomRenderer.renderPipeline((AxiomRenderPipeline)AxiomRenderPipelines.LINES_WITHOUT_WRITE_DEPTH, null, (class_287.class_7433)meshData, (boolean)false);
        AxiomRenderer.setShaderColour((float)1.0f, (float)0.1f, (float)0.1f, (float)0.35f);
        AxiomRenderer.renderPipeline((AxiomRenderPipeline)AxiomRenderPipelines.LINES_IGNORE_DEPTH, null, (class_287.class_7433)meshData, (boolean)true);
        AxiomRenderer.setShaderColour((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void recalculate() {
        this.recalculate = false;
        this.chunkedBlockRegion.clear();
        if (!this.gizmos.isEmpty() && !Clipboard.INSTANCE.isEmpty() && this.gizmos.size() != 1) {
            MaskContext maskContext = new MaskContext((class_1937)class_310.method_1551().field_1687);
            MaskElement destinationMask = MaskManager.getDestMask();
            ChunkedBlockRegion targetRegion = this.chunkedBlockRegion;
            if (this.gizmos.size() == 1) {
                Gizmo gizmo = this.gizmos.getFirst();
                PointConfig pointConfig = this.pointConfigs.getFirst();
                class_2338 pos = gizmo.getTargetPosition();
                class_2680 blockState = pointConfig.overrideBlock ? pointConfig.block.getVanillaState() : Tool.getActiveBlock();
                int radius = pointConfig.overrideRadius ? pointConfig.radius[0] : 0;
                int depth = 0;
                for (int xo = -radius; xo <= radius; ++xo) {
                    for (int yo = -depth; yo <= 0; ++yo) {
                        for (int zo = -radius; zo <= radius; ++zo) {
                            if (!destinationMask.test(maskContext.reset(), pos.method_10263() + xo, pos.method_10264() + yo, pos.method_10260() + zo)) continue;
                            targetRegion.addBlockWithoutDirty(pos.method_10263() + xo, pos.method_10264() + yo, pos.method_10260() + zo, blockState);
                        }
                    }
                }
                this.chunkedBlockRegion.dirtyAll();
                if (blockState.method_26215() || blockState.method_26204() instanceof class_2404) {
                    ChunkRenderOverrider.INSTANCE.acquire("BP To Path Tool");
                    PositionSet positionSet = new PositionSet();
                    this.chunkedBlockRegion.forEachEntry((xx, yx, zx, bx) -> positionSet.add(xx, yx, zx));
                    ChunkRenderOverrider.INSTANCE.cutoutBoolean(positionSet, class_2338.field_10980);
                }
            } else {
                boolean loop = this.gizmos.size() >= 3 && this.looped;
                boolean forceDDA = this.gizmos.size() < 3 && (this.curveType[0] == 2 || this.curveType[0] == 3);
                HashSet<class_2680> blockSet = new HashSet<class_2680>();
                ArrayList<class_2680> blocks = new ArrayList<class_2680>();
                IntArrayList radii = new IntArrayList();
                ArrayList<class_2338> positions = new ArrayList<class_2338>();
                ArrayList<FloatUnaryOperator> easings = new ArrayList<FloatUnaryOperator>();
                FloatArrayList angles = new FloatArrayList();
                for (int i = 0; i < this.gizmos.size(); ++i) {
                    int j;
                    FloatUnaryOperator easing;
                    Gizmo gizmo = this.gizmos.get(i);
                    PointConfig pointConfig = this.pointConfigs.get(i);
                    class_2338 targetPos = gizmo.getTargetPosition();
                    positions.add(targetPos);
                    if (pointConfig.overrideBlock) {
                        blockSet.add(pointConfig.block.getVanillaState());
                        blocks.add(pointConfig.block.getVanillaState());
                    } else {
                        blockSet.add(Tool.getActiveBlock());
                        blocks.add(Tool.getActiveBlock());
                    }
                    radii.add(0);
                    block0 : switch (pointConfig.easing[0]) {
                        case 1: {
                            switch (pointConfig.easingType[0]) {
                                case 1: {
                                    easing = Easings.EASE_OUT_SLIGHT;
                                    break;
                                }
                                case 2: {
                                    easing = Easings.EASE_IN_OUT_SLIGHT;
                                    break;
                                }
                                default: {
                                    easing = Easings.EASE_IN_SLIGHT;
                                }
                            }
                        }
                        case 2: {
                            switch (pointConfig.easingType[0]) {
                                case 1: {
                                    easing = Easings.EASE_OUT_QUAD;
                                    break;
                                }
                                case 2: {
                                    easing = Easings.EASE_IN_OUT_QUAD;
                                    break;
                                }
                                default: {
                                    easing = Easings.EASE_IN_QUAD;
                                }
                            }
                        }
                        case 3: {
                            switch (pointConfig.easingType[0]) {
                                case 1: {
                                    easing = Easings.EASE_OUT_CUBIC;
                                    break;
                                }
                                case 2: {
                                    easing = Easings.EASE_IN_OUT_CUBIC;
                                    break;
                                }
                                default: {
                                    easing = Easings.EASE_IN_CUBIC;
                                }
                            }
                        }
                        case 4: {
                            switch (pointConfig.easingType[0]) {
                                case 1: {
                                    easing = Easings.EASE_OUT_QUARTIC;
                                    break block0;
                                }
                                case 2: {
                                    easing = Easings.EASE_IN_OUT_QUARTIC;
                                    break block0;
                                }
                            }
                            easing = Easings.EASE_IN_QUARTIC;
                        }
                    }
                    easing = Easings.LINEAR;
                    easings.add(easing);
                    float angleLeft = Float.NaN;
                    float angleRight = Float.NaN;
                    if (i < this.gizmos.size() - 1 || loop) {
                        j = i < this.gizmos.size() - 1 ? i + 1 : 0;
                        class_2338 to = this.gizmos.get(j).getTargetPosition();
                        angleLeft = (float)Math.atan2(to.method_10263() - targetPos.method_10263(), to.method_10260() - targetPos.method_10260());
                    }
                    if (i > 0 || loop) {
                        j = i > 0 ? i - 1 : this.gizmos.size() - 1;
                        class_2338 from = this.gizmos.get(j).getTargetPosition();
                        angleRight = (float)Math.atan2(targetPos.method_10263() - from.method_10263(), targetPos.method_10260() - from.method_10260());
                    }
                    if (Float.isNaN(angleLeft) && Float.isNaN(angleRight)) {
                        angles.add(0.0f);
                        continue;
                    }
                    if (Float.isNaN(angleLeft)) {
                        angles.add(angleRight);
                        continue;
                    }
                    if (Float.isNaN(angleRight)) {
                        angles.add(angleLeft);
                        continue;
                    }
                    float delta = angleLeft - angleRight;
                    if ((double)(delta = (float)((double)delta % (Math.PI * 2))) < -Math.PI) {
                        delta = (float)((double)delta + Math.PI * 2);
                    }
                    if ((double)delta > Math.PI) {
                        delta = (float)((double)delta - Math.PI * 2);
                    }
                    angles.add(angleRight + delta / 2.0f);
                }
                if (loop) {
                    positions.add((class_2338)positions.getFirst());
                    blocks.add((class_2680)blocks.getFirst());
                    radii.add(radii.getInt(0));
                    easings.add((FloatUnaryOperator)easings.getFirst());
                    angles.add(angles.getFloat(0));
                }
                BlueprintUtils.AdvancedBPRasterize pathRasterizer = new BlueprintUtils.AdvancedBPRasterize(this.distance[0], this.chunkedBlockRegion, Clipboard.INSTANCE.getClipboard(), this.extendToGround, (class_1937)class_310.method_1551().field_1687);
                if (this.curveType[0] != 0 && !forceDDA) {
                    if (this.curveType[0] == 1) {
                        for (int i = 0; i < positions.size() - 1; ++i) {
                            fromBlock = (class_2338)positions.get(i);
                            toBlock = (class_2338)positions.get(i + 1);
                            int fromX = fromBlock.method_10263();
                            int fromY = fromBlock.method_10264();
                            int fromZ = fromBlock.method_10260();
                            int toX = toBlock.method_10263();
                            int toY = toBlock.method_10264();
                            int toZ = toBlock.method_10260();
                            if (fromX == toX && fromZ == toZ) {
                                class_243 from = new class_243((double)((float)fromBlock.method_10263() + 0.5f), (double)((float)fromBlock.method_10264() + 0.5f), (double)((float)fromBlock.method_10260() + 0.5f));
                                class_243 to = new class_243((double)((float)toBlock.method_10263() + 0.5f), (double)((float)toBlock.method_10264() + 0.5f), (double)((float)toBlock.method_10260() + 0.5f));
                                pathRasterizer.rasterize(targetRegion, from, to);
                                continue;
                            }
                            double dx = toX - fromX;
                            double dy = toY - fromY;
                            double dz = toZ - fromZ;
                            double dh = Math.sqrt(dx * dx + dz * dz);
                            double distanceSq = dx * dx + dy * dy + dz * dz;
                            double l = Math.sqrt(distanceSq) * (1.0 + (double)this.slack[0] / 100.0);
                            double r = Math.sqrt(l * l - dy * dy) / dh;
                            if (r <= 1.0) {
                                class_243 from = new class_243((double)((float)fromBlock.method_10263() + 0.5f), (double)((float)fromBlock.method_10264() + 0.5f), (double)((float)fromBlock.method_10260() + 0.5f));
                                class_243 to = new class_243((double)((float)toBlock.method_10263() + 0.5f), (double)((float)toBlock.method_10264() + 0.5f), (double)((float)toBlock.method_10260() + 0.5f));
                                pathRasterizer.rasterize(targetRegion, from, to);
                                continue;
                            }
                            double bigA = BpToPathTool.findBigA(r);
                            double a = dh / (2.0 * bigA);
                            double b = dh / 2.0 - a * BpToPathTool.atanh(dy / l);
                            double c = (double)(toY + fromY) / 2.0 - l / (2.0 * Math.tanh(bigA));
                            int iterations = Math.max((int)Math.ceil(l / 2.0), 4) - 1;
                            class_243 last = null;
                            for (int j = 0; j <= iterations; ++j) {
                                double amount = (double)j / (double)iterations;
                                float y = (float)(a * Math.cosh((dh * amount - b) / a) + c);
                                if (this.inverted) {
                                    amount = 1.0 - amount;
                                    y = (float)(fromY + toY) - y;
                                }
                                float x = (float)((double)toX * amount + (double)fromX * (1.0 - amount));
                                float z = (float)((double)toZ * amount + (double)fromZ * (1.0 - amount));
                                class_243 pos = new class_243((double)(x + 0.5f), (double)(y + 0.5f), (double)(z + 0.5f));
                                if (last != null) {
                                    pathRasterizer.rasterize(targetRegion, last, pos);
                                }
                                last = pos;
                            }
                        }
                    } else if (this.curveType[0] == 2) {
                        if (loop) {
                            positions.removeLast();
                        }
                        ArrayList<Vector3f> positionsF = new ArrayList<Vector3f>();
                        for (Gizmo gizmo : this.gizmos) {
                            class_2338 pos = gizmo.getTargetPosition();
                            positionsF.add(new Vector3f((float)pos.method_10263() + 0.5f, (float)pos.method_10264() + 0.5f, (float)pos.method_10260() + 0.5f));
                        }
                        int size = positionsF.size();
                        int maxI = loop ? size : size - 1;
                        for (int i = 0; i < maxI; ++i) {
                            int i0 = i - 1;
                            int i1 = i + 1;
                            int i2 = i + 2;
                            if (loop) {
                                i1 %= size;
                                i2 %= size;
                                if ((i0 %= size) < 0) {
                                    i0 += size;
                                }
                            } else {
                                if (i0 < 0) {
                                    i0 = 0;
                                }
                                if (i1 >= size) {
                                    i1 = size - 1;
                                }
                                if (i2 >= size) {
                                    i2 = size - 1;
                                }
                            }
                            if (i == i1) continue;
                            float distance = ((Vector3f)positionsF.get(i)).distance((Vector3fc)positionsF.get(i1));
                            int numPoints = Math.max(4, (int)Math.ceil(distance / 2.0f));
                            List spline = CatmullRomSpline.createCatmullRomSplineWithPartial((Vector3f)((Vector3f)positionsF.get(i0)), (Vector3f)((Vector3f)positionsF.get(i)), (Vector3f)((Vector3f)positionsF.get(i1)), (Vector3f)((Vector3f)positionsF.get(i2)), (int)numPoints, (float)0.0f);
                            for (int k = 0; k < spline.size() - 1; ++k) {
                                Vector4f item1 = (Vector4f)spline.get(k);
                                Vector4f item2 = (Vector4f)spline.get(k + 1);
                                class_243 pos1 = new class_243((double)item1.x, (double)item1.y, (double)item1.z);
                                class_243 pos2 = new class_243((double)item2.x, (double)item2.y, (double)item2.z);
                                pathRasterizer.rasterize(targetRegion, pos1, pos2);
                            }
                        }
                    } else if (this.curveType[0] == 3) {
                        float totalLength = 0.0f;
                        int count = loop ? this.gizmos.size() + 1 : this.gizmos.size();
                        BezierOperator[] factors = new BezierOperator[count];
                        class_2338 lastBlockPos = null;
                        for (int i = 0; i < this.gizmos.size(); ++i) {
                            class_2338 pos = this.gizmos.get(i).getTargetPosition();
                            if (lastBlockPos != null) {
                                totalLength = (float)((double)totalLength + Math.sqrt(pos.method_10262(lastBlockPos)));
                            }
                            factors[i] = new BezierOperator(i, count);
                            lastBlockPos = pos;
                        }
                        if (loop) {
                            factors[count - 1] = new BezierOperator(count - 1, count);
                        }
                        int iterations = Math.max((int)Math.ceil(totalLength / 2.0f), 4) - 1;
                        class_243 last = null;
                        double lastAmount = 0.0;
                        for (int i = 0; i <= iterations; ++i) {
                            double amount = (double)i / (double)iterations;
                            double x = 0.0;
                            double y = 0.0;
                            double z = 0.0;
                            for (int j = 0; j < positions.size(); ++j) {
                                class_2338 position = (class_2338)positions.get(j);
                                double factor = factors[j].applyAsDouble(amount);
                                x += factor * (double)position.method_10263();
                                y += factor * (double)position.method_10264();
                                z += factor * (double)position.method_10260();
                            }
                            class_243 pos = new class_243((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f));
                            if (last != null) {
                                double lastFull = lastAmount * (double)(count - 1);
                                double lastPartial = lastFull % 1.0;
                                int lastIndex = (int)Math.floor(lastFull);
                                if (lastPartial == 0.0 && lastIndex > 0) {
                                    lastPartial = 1.0;
                                    --lastIndex;
                                }
                                double currFull = amount * (double)(count - 1);
                                double currPartial = currFull % 1.0;
                                int currIndex = (int)Math.floor(currFull);
                                if (currPartial == 0.0 && currIndex > 0) {
                                    currPartial = 1.0;
                                    --currIndex;
                                }
                                if (lastIndex != currIndex) {
                                    double to = 1.0 - lastPartial;
                                    float mid = (float)(to / (to + currPartial));
                                    double midX = last.field_1352 * (double)(1.0f - mid) + pos.field_1352 * (double)mid;
                                    double midY = last.field_1351 * (double)(1.0f - mid) + pos.field_1351 * (double)mid;
                                    double midZ = last.field_1350 * (double)(1.0f - mid) + pos.field_1350 * (double)mid;
                                    class_243 midVec = new class_243(midX, midY, midZ);
                                    pathRasterizer.rasterize(targetRegion, last, midVec);
                                    pathRasterizer.rasterize(targetRegion, midVec, pos);
                                } else {
                                    pathRasterizer.rasterize(targetRegion, last, pos);
                                }
                            }
                            last = pos;
                            lastAmount = amount;
                        }
                    }
                } else {
                    for (int i = 0; i < positions.size() - 1; ++i) {
                        fromBlock = (class_2338)positions.get(i);
                        toBlock = (class_2338)positions.get(i + 1);
                        class_243 from = new class_243((double)((float)fromBlock.method_10263() + 0.5f), (double)((float)fromBlock.method_10264() + 0.5f), (double)((float)fromBlock.method_10260() + 0.5f));
                        class_243 to = new class_243((double)((float)toBlock.method_10263() + 0.5f), (double)((float)toBlock.method_10264() + 0.5f), (double)((float)toBlock.method_10260() + 0.5f));
                        pathRasterizer.rasterize(targetRegion, from, to);
                    }
                }
                this.chunkedBlockRegion.dirtyAll();
                boolean hasInvisible = false;
                boolean hasVisible = false;
                for (class_2680 blockState : blockSet) {
                    if (!blockState.method_26215() && !(blockState.method_26204() instanceof class_2404)) {
                        hasVisible = true;
                        continue;
                    }
                    hasInvisible = true;
                }
                if (hasInvisible) {
                    PositionSet positionSet = new PositionSet();
                    if (hasVisible) {
                        this.chunkedBlockRegion.forEachEntry((xx, yx, zx, bx) -> {
                            if (bx.method_26215() || bx.method_26204() instanceof class_2404) {
                                positionSet.add(xx, yx, zx);
                            }
                        });
                    } else {
                        this.chunkedBlockRegion.forEachEntry((xx, yx, zx, bx) -> positionSet.add(xx, yx, zx));
                    }
                    ChunkRenderOverrider.INSTANCE.cutoutBoolean(positionSet, class_2338.field_10980);
                }
            }
        }
    }

    public void displayImguiOptions() {
        ImGuiHelper.separatorWithText((String)"DBTools: Blueprint To Path Tool");
        if (Clipboard.INSTANCE.isEmpty()) {
            ImGui.text((String)"Clipboard empty. \nPlease select a blueprint or copy a selection");
        } else {
            boolean changed = ImGuiHelper.combo((String)AxiomI18n.get((String)"axiom.tool.path.curve_type"), (int[])this.curveType, (String[])new String[]{"Line", AxiomI18n.get((String)"axiom.tool.path.curve_catenary"), AxiomI18n.get((String)"axiom.tool.path.curve_catmull_rom"), AxiomI18n.get((String)"axiom.tool.path.curve_bezier")});
            if (changed) {
                DBToolsClient.LOGGER.info("info");
            }
            if (ImGui.checkbox((String)AxiomI18n.get((String)"axiom.tool.path.looped"), (boolean)this.looped)) {
                this.looped = !this.looped;
                changed = true;
            }
            changed |= ImGui.sliderInt((String)"Distance", (int[])this.distance, (int)0, (int)50);
            if (ImGui.isItemHovered()) {
                ImGui.beginTooltip();
                ImGui.text((String)"This is the distance between each point of insertion, not between each blueprint.");
                ImGui.endTooltip();
            }
            if (this.curveType[0] == 1) {
                if (ImGui.checkbox((String)AxiomI18n.get((String)"axiom.tool.path.inverted"), (boolean)this.inverted)) {
                    this.inverted = !this.inverted;
                    changed = true;
                }
                changed |= ImGui.sliderInt((String)AxiomI18n.get((String)"axiom.tool.path.slack"), (int[])this.slack, (int)0, (int)200, (String)"%d%%");
            }
            if (this.activePoint >= 0 && this.activePoint < this.pointConfigs.size() && this.activePoint < this.gizmos.size()) {
                PointConfig pointConfig = this.pointConfigs.get(this.activePoint);
                Gizmo gizmo = this.gizmos.get(this.activePoint);
                class_2338 pos = gizmo.getTargetPosition();
                ImGuiHelper.separatorWithText((String)AxiomI18n.get((String)"axiom.tool.ruler.point_i", (Object[])new Object[]{this.activePoint + 1}));
                int[] positionInput = new int[]{pos.method_10263(), pos.method_10264(), pos.method_10260()};
                if (ImGuiHelper.inputInt((String)AxiomI18n.get((String)"axiom.tool.box_select.position"), (int[])positionInput)) {
                    gizmo.moveTo(new class_2338(positionInput[0], positionInput[1], positionInput[2]));
                    changed = true;
                }
                if (ImGui.button((String)AxiomI18n.get((String)"axiom.tool.path.remove"))) {
                    this.gizmos.remove(this.activePoint);
                    this.pointConfigs.remove(this.activePoint);
                    this.activePoint = -1;
                    changed = true;
                }
            }
            ImGuiHelper.separatorWithText((String)AxiomI18n.get((String)"axiom.tool.shape.paste_options"));
            if (ImGui.checkbox((String)AxiomI18n.get((String)"axiom.editorui.window.clipboard.placement_options.keep_existing"), (boolean)this.keepExisting)) {
                this.keepExisting = !this.keepExisting;
                changed = true;
            }
            if (ImGui.checkbox((String)AxiomI18n.get((String)"axiom.tool.path.extend_to_ground"), (boolean)this.extendToGround)) {
                this.extendToGround = !this.extendToGround;
                changed = true;
            }
            if (ImGui.button((String)"Paste Copy")) {
                this.pastePath();
            }
            ImGuiHelper.separatorWithText((String)AxiomI18n.get((String)"axiom.widget.presets"));
            this.presetWidget.displayImgui(changed);
            if (this.activePoint >= 0) {
                ImGui.separator();
                ImGui.text((String)AxiomI18n.get((String)"axiom.tool.shape.extrude_tip", (Object[])new Object[]{Keybinds.EXTRUDE_POINT.longKeyIdentifier()}));
            }
            this.recalculate |= changed;
        }
    }

    public String listenForEsc() {
        return this.activePoint >= 0 && this.activePoint < this.gizmos.size() ? AxiomI18n.get((String)"axiom.tool.path.deselect_point_n", (Object[])new Object[]{this.activePoint + 1}) : null;
    }

    public String listenForEnter() {
        return !this.chunkedBlockRegion.isEmpty() ? AxiomI18n.get((String)"axiom.widget.confirm") : null;
    }

    public String name() {
        return "DBTools: Blueprint To Path Tool";
    }

    public void writeSourceInfo(class_2487 tag, boolean includeSettings) {
        throw new UnsupportedOperationException();
    }

    public void writeSettings(class_2487 tag) {
        tag.method_10569("CurveType", this.curveType[0]);
        tag.method_10556("Looped", this.looped);
        tag.method_10556("CatenaryInverted", this.inverted);
        tag.method_10569("CatenarySlack", this.slack[0]);
        tag.method_10556("KeepExisting", this.keepExisting);
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            class_2338 pos = player.method_24515();
            tag.method_10569("PlayerPosX", pos.method_10263());
            tag.method_10569("PlayerPosY", pos.method_10264());
            tag.method_10569("PlayerPosZ", pos.method_10260());
        }
        class_2499 pathPointsTag = new class_2499();
        for (int i = 0; i < this.gizmos.size(); ++i) {
            class_2338 position = this.gizmos.get(i).getTargetPosition();
            PointConfig pointConfig = this.pointConfigs.get(i);
            class_2487 pathPoint = new class_2487();
            pathPoint.method_10569("X", position.method_10263());
            pathPoint.method_10569("Y", position.method_10264());
            pathPoint.method_10569("Z", position.method_10260());
            pathPoint.method_10556("OverrideBlock", pointConfig.overrideBlock);
            pathPoint.method_10556("OverrideRadius", pointConfig.overrideRadius);
            if (pointConfig.overrideBlock) {
                pathPoint.method_10582("Block", ServerCustomBlocks.serialize((CustomBlockState)pointConfig.block));
            }
            if (pointConfig.overrideRadius) {
                pathPoint.method_10569("Radius", pointConfig.radius[0]);
            }
            pathPoint.method_10569("Easing", pointConfig.easing[0]);
            pathPoint.method_10569("EasingType", pointConfig.easingType[0]);
            pathPointsTag.add((Object)pathPoint);
        }
        tag.method_10566("PathPoints", (class_2520)pathPointsTag);
    }

    public void loadSettings(class_2487 tag) {
        this.curveType[0] = VersionUtilsNbt.helperCompoundTagGetIntOr((class_2487)tag, (String)"CurveType", (int)1);
        this.looped = VersionUtilsNbt.helperCompoundTagGetBooleanOr((class_2487)tag, (String)"Looped", (boolean)false);
        this.inverted = VersionUtilsNbt.helperCompoundTagGetBooleanOr((class_2487)tag, (String)"CatenaryInverted", (boolean)false);
        this.slack[0] = VersionUtilsNbt.helperCompoundTagGetIntOr((class_2487)tag, (String)"CatenarySlack", (int)20);
        this.keepExisting = VersionUtilsNbt.helperCompoundTagGetBooleanOr((class_2487)tag, (String)"KeepExisting", (boolean)false);
        class_2338 offset = class_2338.field_10980;
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            if (tag.method_10545("PlayerPosX")) {
                offset = new class_2338(player.method_31477() - VersionUtilsNbt.helperCompoundTagGetIntOr((class_2487)tag, (String)"PlayerPosX", (int)0), offset.method_10264(), offset.method_10260());
            }
            if (tag.method_10545("PlayerPosY")) {
                offset = new class_2338(offset.method_10263(), player.method_31478() - VersionUtilsNbt.helperCompoundTagGetIntOr((class_2487)tag, (String)"PlayerPosY", (int)0), offset.method_10260());
            }
            if (tag.method_10545("PlayerPosZ")) {
                offset = new class_2338(offset.method_10263(), offset.method_10264(), player.method_31479() - VersionUtilsNbt.helperCompoundTagGetIntOr((class_2487)tag, (String)"PlayerPosZ", (int)0));
            }
        }
        this.gizmos.clear();
        this.pointConfigs.clear();
        for (class_2520 pathPointTag : NbtHelper.getList((class_2487)tag, (String)"PathPoints", (int)10)) {
            String blockString;
            class_2487 pathPoint = (class_2487)pathPointTag;
            int x = VersionUtilsNbt.helperCompoundTagGetIntOr((class_2487)pathPoint, (String)"X", (int)0) + offset.method_10263();
            int y = VersionUtilsNbt.helperCompoundTagGetIntOr((class_2487)pathPoint, (String)"Y", (int)0) + offset.method_10264();
            int z = VersionUtilsNbt.helperCompoundTagGetIntOr((class_2487)pathPoint, (String)"Z", (int)0) + offset.method_10260();
            boolean overrideBlock = VersionUtilsNbt.helperCompoundTagGetBooleanOr((class_2487)pathPoint, (String)"OverrideBlock", (boolean)false);
            boolean overrideRadius = VersionUtilsNbt.helperCompoundTagGetBooleanOr((class_2487)pathPoint, (String)"OverrideRadius", (boolean)false);
            CustomBlockState customBlockState = (CustomBlockState)class_2246.field_10340.method_9564();
            if (overrideBlock && !(blockString = VersionUtilsNbt.helperCompoundTagGetStringOr((class_2487)pathPoint, (String)"Block", (String)"")).isEmpty()) {
                customBlockState = Objects.requireNonNullElse(ServerCustomBlocks.deserialize((String)blockString), customBlockState);
            }
            int easing = VersionUtilsNbt.helperCompoundTagGetIntOr((class_2487)tag, (String)"Easing", (int)0);
            int easingType = VersionUtilsNbt.helperCompoundTagGetIntOr((class_2487)tag, (String)"EasingType", (int)0);
            this.gizmos.add(new Gizmo(new class_2338(x, y, z)));
            this.pointConfigs.add(new PointConfig(overrideBlock, overrideRadius, customBlockState, 0, easing, easingType));
        }
        this.recalculate = true;
    }

    public char iconChar() {
        return this.iconChar;
    }

    public String keybindId() {
        return "";
    }

    public EnumSet<AxiomPermission> requiredPermissions() {
        return EnumSet.of(AxiomPermission.TOOL, AxiomPermission.BUILD_SECTION);
    }
}

