/*
 * Decompiled with CFR 0.152.
 */
package com.denni5x.dbtools.client.BlueprintTools;

import com.moulberry.axiom.RayCaster;
import com.moulberry.axiom.UserAction;
import com.moulberry.axiom.clipboard.Clipboard;
import com.moulberry.axiom.clipboard.ClipboardObject;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.mask.MaskContext;
import com.moulberry.axiom.mask.MaskElement;
import com.moulberry.axiom.mask.elements.ConstantMaskElement;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.restrictions.AxiomPermission;
import com.moulberry.axiom.tools.Tool;
import com.moulberry.axiom.tools.stamp.StampPlacement;
import com.moulberry.axiom.tools.stamp.TransformedBlockRegions;
import com.moulberry.axiom.utils.PositionUtils;
import com.moulberry.axiom.utils.RegionHelper;
import com.moulberry.axiom.world_modification.CompressedBlockEntity;
import com.moulberry.axiom.world_modification.HistoryEntry;
import imgui.ImGui;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class PlaceTool
implements Tool {
    private final int[] position = new int[3];
    private final int[] offset = new int[3];
    public int pasteModifiers;
    private boolean livePreview = true;
    private boolean keepExisting = false;
    private boolean pasteAir = true;
    private boolean pasteEntities = true;
    private boolean prioritizeFullBlocks = true;
    private boolean includeNonSolid = false;
    private boolean autoRotate = true;
    private int rotation = 0;
    private int userRotation = 0;
    private boolean flipX = false;
    private boolean flipZ = false;
    private StampPlacement placement;
    private ChunkedBlockRegion blockRegion;
    private Long2ObjectMap<CompressedBlockEntity> blockEntities;
    private ClipboardObject clipboard;
    private ChunkedBlockRegion clipboardRegion;
    private Long2ObjectMap<CompressedBlockEntity> clipboardBlockEntities;
    private TransformedBlockRegions transformedBlockRegions;
    private List<class_2487> entities;
    private final char iconChar;

    public PlaceTool(char iconChar) {
        this.iconChar = iconChar;
        this.pasteModifiers = HistoryEntry.MODIFIER_PASTE;
        this.blockRegion = new ChunkedBlockRegion();
        this.blockEntities = new Long2ObjectOpenHashMap();
    }

    public void reset() {
        this.clipboard = null;
        this.clipboardRegion = null;
        this.clipboardBlockEntities = null;
        this.entities = null;
        this.transformedBlockRegions = null;
    }

    public void render(class_4184 camera, float tickDelta, long time, class_4587 poseStack, Matrix4f projection) {
        RayCaster.RaycastResult result = Tool.raycastBlock((boolean)false, (boolean)this.includeNonSolid, (boolean)Tool.defaultIncludeFluids());
        ClipboardObject localClipboard = Clipboard.INSTANCE.getClipboard();
        if (result == null || localClipboard == null) {
            return;
        }
        if (this.clipboard == null || !Objects.equals(localClipboard.name(), this.clipboard.name())) {
            this.reset();
            Arrays.fill(this.offset, 0);
            Arrays.fill(this.position, 0);
            this.clipboard = localClipboard;
            this.clipboardRegion = this.clipboard.blockRegion();
            this.clipboardBlockEntities = this.clipboard.blockEntities();
            this.entities = this.clipboard.entities();
            this.transformedBlockRegions = new TransformedBlockRegions(this.clipboardRegion, this.clipboardBlockEntities);
        }
        class_2338 adjustedBlockPos = this.getAdjustedBlockPos(result);
        if (this.autoRotate) {
            int offsetX = result.getDirection().method_10148();
            int offsetZ = result.getDirection().method_10165();
            if (offsetX != 0) {
                int n = this.rotation = offsetX > 0 ? 1 : 3;
            }
            if (offsetZ != 0) {
                int n = this.rotation = offsetZ > 0 ? 0 : 2;
            }
            if (offsetX == 0 && offsetZ == 0) {
                this.rotation = 0;
            }
            this.rotation -= this.userRotation;
        } else {
            this.rotation = this.userRotation;
        }
        this.rotation = this.rotation > 3 ? this.rotation - 4 : this.rotation;
        this.rotation = this.rotation < 0 ? this.rotation + 4 : this.rotation;
        this.position[0] = adjustedBlockPos.method_10263();
        this.position[1] = adjustedBlockPos.method_10264();
        this.position[2] = adjustedBlockPos.method_10260();
        this.placement = new StampPlacement(this.transformedBlockRegions.getBlocks(this.rotation, this.flipX, this.flipZ), this.transformedBlockRegions.getBlockEntities(this.rotation, this.flipX, this.flipZ), this.transformedBlockRegions, this.rotation, this.flipX, this.flipZ, adjustedBlockPos.method_10263() + this.offset[0], adjustedBlockPos.method_10264() + this.offset[1], adjustedBlockPos.method_10260() + this.offset[2], result.getBlockPos().method_10263(), result.getBlockPos().method_10264(), result.getBlockPos().method_10260());
        this.blockRegion.clear();
        ConstantMaskElement mask = new ConstantMaskElement(true);
        MaskContext maskContext = new MaskContext((class_1937)class_310.method_1551().field_1687);
        this.placement.pasteInto(this.blockRegion, this.blockEntities, maskContext, (MaskElement)mask);
        float opacity = (float)Math.sin((float)time / 1000000.0f / 50.0f / 8.0f);
        if (this.livePreview) {
            this.blockRegion.render(camera, class_243.field_1353, poseStack, projection, 0.75f + opacity * 0.25f, 0.3f - opacity * 0.2f);
        }
    }

    public UserAction.ActionResult callAction(UserAction action, Object object) {
        return switch (action) {
            default -> throw new MatchException(null, null);
            case UserAction.ESCAPE, UserAction.CUT, UserAction.DUPLICATE, UserAction.COPY, UserAction.DELETE, UserAction.UNDO, UserAction.REDO, UserAction.SAVE, UserAction.EXTRUDE, UserAction.RIGHT_MOUSE, UserAction.MIDDLE_MOUSE -> UserAction.ActionResult.NOT_HANDLED;
            case UserAction.ROTATE_PLACEMENT -> {
                this.userRotation = this.userRotation == 3 ? 0 : ++this.userRotation;
                yield UserAction.ActionResult.USED_STOP;
            }
            case UserAction.FLIP_PLACEMENT -> {
                class_243 lookDirection = Tool.getLookDirection();
                if (lookDirection == null) {
                    if (!$assertionsDisabled && class_310.method_1551().method_1560() == null) {
                        throw new AssertionError();
                    }
                    lookDirection = class_310.method_1551().method_1560().method_5720();
                }
                class_2350 direction = PositionUtils.orderedByNearest((class_243)lookDirection)[0];
                this.flip(direction.method_10166());
                yield UserAction.ActionResult.USED_STOP;
            }
            case UserAction.ENTER, UserAction.PASTE, UserAction.LEFT_MOUSE -> {
                this.pasteBlueprint();
                yield UserAction.ActionResult.USED_STOP;
            }
            case UserAction.SCROLL -> {
                UserAction.ScrollAmount scrollObject = (UserAction.ScrollAmount)object;
                if (this.handleScroll(scrollObject.scrollY())) {
                    yield UserAction.ActionResult.USED_STOP;
                }
                yield UserAction.ActionResult.NOT_HANDLED;
            }
        };
    }

    public boolean handleScroll(int scroll) {
        if (this.blockRegion != null) {
            class_243 lookDirection = Tool.getLookDirection();
            if (lookDirection == null) {
                return false;
            }
            class_2350[] directions = PositionUtils.orderedByNearest((class_243)lookDirection);
            class_2350 mainDirection = directions[0];
            if (mainDirection != null) {
                switch (mainDirection) {
                    case field_11036: {
                        this.offset[1] = this.offset[1] + scroll;
                        break;
                    }
                    case field_11033: {
                        this.offset[1] = this.offset[1] - scroll;
                        break;
                    }
                    case field_11043: {
                        this.offset[2] = this.offset[2] - scroll;
                        break;
                    }
                    case field_11035: {
                        this.offset[2] = this.offset[2] + scroll;
                        break;
                    }
                    case field_11039: {
                        this.offset[0] = this.offset[0] - scroll;
                        break;
                    }
                    case field_11034: {
                        this.offset[0] = this.offset[0] + scroll;
                    }
                }
                return true;
            }
        }
        return false;
    }

    public void pasteBlueprint() {
        int i = this.keepExisting ? HistoryEntry.MODIFIER_KEEP_EXISTING : 0;
        String countString = NumberFormat.getInstance().format(this.blockRegion.count());
        String historyDescription = AxiomI18n.get((String)"axiom.history_description.placed", (Object[])new Object[]{countString});
        RegionHelper.pushBlockRegionChange((ChunkedBlockRegion)this.blockRegion, null, (String)historyDescription, (int)i);
    }

    public void displayImguiOptions() {
        ImGuiHelper.separatorWithText((String)"DBTools: Place");
        ImGuiHelper.setupBorder();
        ImGuiHelper.separatorWithText((String)"Flags");
        if (ImGui.checkbox((String)"Live Preview", (boolean)this.livePreview)) {
            boolean bl = this.livePreview = !this.livePreview;
        }
        if (ImGui.checkbox((String)"Auto Rotate", (boolean)this.autoRotate)) {
            this.autoRotate = !this.autoRotate;
        }
        ImGuiHelper.tooltip((String)"Disables auto rotation according to targeted surface");
        if (ImGui.checkbox((String)"Include Non-Solid Blocks", (boolean)this.includeNonSolid)) {
            this.includeNonSolid = !this.includeNonSolid;
        }
        ImGuiHelper.tooltip((String)"When checked, also includes flowers etc. as raytrace target");
        ImGuiHelper.finishBorder();
        ImGuiHelper.setupBorder();
        ImGuiHelper.separatorWithText((String)"Coordinate Settings");
        if (Clipboard.INSTANCE.getClipboard() != null) {
            ImGuiHelper.inputInt((String)AxiomI18n.get((String)"axiom.tool.box_select.position"), (int[])this.position);
            ImGuiHelper.inputInt((String)AxiomI18n.get((String)"axiom.tool.stamp.offset"), (int[])this.offset);
        } else {
            ImGui.text((String)"Clipboard empty. \nPlease select a blueprint or copy a selection");
        }
        ImGuiHelper.finishBorder();
        ImGuiHelper.setupBorder();
        ImGuiHelper.separatorWithText((String)"Paste Settings");
        if (ImGui.checkbox((String)AxiomI18n.get((String)"axiom.editorui.window.clipboard.placement_options.keep_existing"), (boolean)this.keepExisting)) {
            this.keepExisting = !this.keepExisting;
        }
        ImGui.sameLine();
        if (ImGui.checkbox((String)"Merge Blocks", (boolean)this.prioritizeFullBlocks)) {
            boolean bl = this.prioritizeFullBlocks = !this.prioritizeFullBlocks;
        }
        if (this.keepExisting) {
            ImGuiHelper.tooltip((String)"Merges new blocks with existing blocks based on block shape:\nIf the new block completely overlaps the old block, the new block is used\nOtherwise, the old block is used\n(Inverts if Keep Existing is disabled)");
        } else {
            ImGuiHelper.tooltip((String)"Merges new blocks with existing blocks based on block shape:\nIf the old block completely overlaps the new block, the old block is used\nOtherwise, the new block is used\n(Inverts if Keep Existing is enabled)");
        }
        if (ImGui.checkbox((String)AxiomI18n.get((String)"axiom.editorui.window.clipboard.placement_options.paste_air"), (boolean)this.pasteAir)) {
            this.pasteAir = !this.pasteAir;
        }
        ImGui.sameLine();
        if (this.entities != null && !this.entities.isEmpty()) {
            if (ImGui.checkbox((String)"Paste Entities", (boolean)this.pasteEntities)) {
                this.pasteEntities = !this.pasteEntities;
            }
        } else {
            ImGui.beginDisabled();
            ImGui.checkbox((String)"Paste Entities", (boolean)false);
            ImGui.endDisabled();
            ImGuiHelper.tooltip((String)"Placement does not contain any entities", (int)512);
        }
        ImGuiHelper.finishBorder();
    }

    public class_2338 getAdjustedBlockPos(RayCaster.RaycastResult result) {
        class_2338 targetPos = result.getBlockPos();
        int[] minY = new int[]{this.clipboardRegion.min().method_10264()};
        int[] maxY = new int[]{this.clipboardRegion.max().method_10264()};
        return targetPos.method_10069(0, (maxY[0] - minY[0]) / 2, 0);
    }

    public void flip(class_2350.class_2351 axis) {
        switch (axis) {
            case field_11048: {
                if (this.rotation == 1 || this.rotation == 3) {
                    this.flipZ = !this.flipZ;
                    break;
                }
                this.flipX = !this.flipX;
                break;
            }
            case field_11051: {
                if (this.rotation == 1 || this.rotation == 3) {
                    this.flipX = !this.flipX;
                    break;
                }
                this.flipZ = !this.flipZ;
            }
        }
    }

    public String name() {
        return "DBTools: Place";
    }

    public char iconChar() {
        return this.iconChar;
    }

    public void writeSettings(class_2487 nbtCompound) {
    }

    public void loadSettings(class_2487 nbtCompound) {
    }

    public String keybindId() {
        return "";
    }

    public EnumSet<AxiomPermission> requiredPermissions() {
        return EnumSet.of(AxiomPermission.TOOL, AxiomPermission.BUILD_SECTION);
    }
}

