/*
 * Decompiled with CFR 0.152.
 */
package com.denni5x.dbtools.client.BlueprintTools;

import com.denni5x.dbtools.client.Utils.UndoOperations.CreateGridPlaceUndoOperation;
import com.moulberry.axiom.AxiomClient;
import com.moulberry.axiom.RayCaster;
import com.moulberry.axiom.UserAction;
import com.moulberry.axiom.blueprint.Blueprint;
import com.moulberry.axiom.clipboard.ClipboardObject;
import com.moulberry.axiom.custom_blocks.CustomBlockState;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.editor.widgets.BlockStateWidget;
import com.moulberry.axiom.editor.windows.clipboard.BlueprintBrowserWindow;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.render.EffectRenderer;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.restrictions.AxiomPermission;
import com.moulberry.axiom.tools.Tool;
import com.moulberry.axiom.tools.ToolManager;
import com.moulberry.axiom.utils.RegionHelper;
import com.moulberry.axiom.world_modification.CompressedBlockEntity;
import com.moulberry.axiom.world_modification.HistoryEntry;
import com.moulberry.axiom.world_modification.undo.AdditionalUndoOperation;
import imgui.ImGui;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class GridPlaceTool
implements Tool {
    private static final BlockStateWidget platformInnerBlockWidget = new BlockStateWidget(class_2246.field_10340);
    private static final BlockStateWidget platformOuterBlockWidget = new BlockStateWidget(class_2246.field_10056);
    private final char iconChar;
    private final int[] gridSizeX = new int[]{10};
    private final int[] gridSizeY = new int[]{1};
    private final int[] space = new int[]{0, 0, 0};
    private final List<ClipboardObject> blueprints = new ArrayList<ClipboardObject>();
    private final int[] maxBlueprintSize = new int[]{0, 0, 0};
    private final int[] minBlueprintSize = new int[]{0, 0, 0};
    private final ChunkedBlockRegion previewRegion = new ChunkedBlockRegion();
    private final Long2ObjectMap<CompressedBlockEntity> previewBlockEntities = new Long2ObjectOpenHashMap();
    private CustomBlockState platformInnerBlock = (CustomBlockState)class_2246.field_10353.method_9564();
    private CustomBlockState platformOuterBlock = (CustomBlockState)class_2246.field_10038.method_9564();
    private class_2338 originPos = null;
    private boolean keepExisting = false;
    private boolean forceSingleBlockCenter = true;
    private boolean createPlatform = false;
    private boolean overrideBlueprintSize = false;
    private boolean useRelativePosition = true;
    private boolean livePreview = false;
    private boolean previewDirty = true;

    public GridPlaceTool(char iconChar) {
        this.iconChar = iconChar;
    }

    private int calculateGridZ() {
        if (this.blueprints.isEmpty()) {
            return 1;
        }
        int blueprintCount = this.blueprints.size();
        int layerSize = this.gridSizeX[0] * this.gridSizeY[0];
        return (int)Math.ceil((double)blueprintCount / (double)layerSize);
    }

    public void reset() {
        this.originPos = null;
        this.blueprints.clear();
        this.gridSizeX[0] = 1;
        this.gridSizeY[0] = 1;
        this.space[0] = 0;
        this.space[1] = 0;
        this.space[2] = 0;
        this.maxBlueprintSize[0] = 0;
        this.maxBlueprintSize[1] = 0;
        this.maxBlueprintSize[2] = 0;
        this.minBlueprintSize[0] = 0;
        this.minBlueprintSize[1] = 0;
        this.minBlueprintSize[2] = 0;
        this.keepExisting = false;
        this.forceSingleBlockCenter = true;
        this.createPlatform = false;
        this.overrideBlueprintSize = false;
        this.useRelativePosition = true;
        this.livePreview = false;
        this.previewDirty = true;
        this.previewRegion.clear();
        this.previewBlockEntities.clear();
    }

    public void toolDeselected() {
        BlueprintBrowserWindow.resetCallback();
    }

    public void restore(class_2338 originPos, List<ClipboardObject> blueprints, int gridSizeX, int gridSizeY, int[] space, boolean keepExisting, boolean forceSingleBlockCenter, boolean createPlatform, CustomBlockState platformInner, CustomBlockState platformOuter, boolean overrideBlueprintSize, int[] maxBlueprintSize, boolean useRelativePosition, boolean livePreview) {
        this.reset();
        this.originPos = originPos;
        this.blueprints.addAll(blueprints);
        this.gridSizeX[0] = gridSizeX;
        this.gridSizeY[0] = gridSizeY;
        this.space[0] = space[0];
        this.space[1] = space[1];
        this.space[2] = space[2];
        this.keepExisting = keepExisting;
        this.forceSingleBlockCenter = forceSingleBlockCenter;
        this.createPlatform = createPlatform;
        this.overrideBlueprintSize = overrideBlueprintSize;
        this.useRelativePosition = useRelativePosition;
        this.livePreview = livePreview;
        this.maxBlueprintSize[0] = maxBlueprintSize[0];
        this.maxBlueprintSize[1] = maxBlueprintSize[1];
        this.maxBlueprintSize[2] = maxBlueprintSize[2];
        this.platformInnerBlock = platformInner;
        this.platformOuterBlock = platformOuter;
        if (this.livePreview) {
            this.previewDirty = true;
        }
    }

    public void render(class_4184 camera, float tickDelta, long time, class_4587 poseStack, Matrix4f matrices) {
        RayCaster.RaycastResult result = Tool.raycastBlock((boolean)false, (boolean)true, (boolean)Tool.defaultIncludeFluids());
        if (result != null) {
            if (this.useRelativePosition) {
                Tool.renderRaycastOverlay((class_2338)result.blockPos().method_10093(result.direction()), (class_4587)poseStack, (class_4184)camera);
            } else {
                Tool.renderRaycastOverlay((RayCaster.RaycastResult)result, (class_4587)poseStack, (class_4184)camera);
            }
        }
        if (this.originPos != null && !this.blueprints.isEmpty()) {
            int platformOffset;
            int gridZ = this.calculateGridZ();
            int n = platformOffset = this.createPlatform ? 1 : 0;
            if (this.livePreview) {
                if (this.previewDirty) {
                    this.updatePreview();
                }
                float opacity = (float)Math.sin((float)time / 1000000.0f / 50.0f / 8.0f);
                this.previewRegion.render(camera, class_243.field_1353, poseStack, matrices, 0.75f + opacity * 0.25f, 0.3f - opacity * 0.2f);
            } else {
                for (int x = 0; x < this.gridSizeX[0]; ++x) {
                    for (int y = 0; y < this.gridSizeY[0]; ++y) {
                        for (int z = 0; z < gridZ; ++z) {
                            int offsetX = x * (this.maxBlueprintSize[0] + this.space[0]);
                            int offsetY = y * (this.maxBlueprintSize[1] + this.space[1]);
                            int offsetZ = z * (this.maxBlueprintSize[2] + this.space[2]);
                            class_243 firstPosition = new class_243((double)(this.originPos.method_10263() + offsetX), (double)(this.originPos.method_10264() + offsetY), (double)(this.originPos.method_10260() + offsetZ));
                            class_243 secondPosition = new class_243((double)(this.originPos.method_10263() + offsetX + this.maxBlueprintSize[0]), (double)(this.originPos.method_10264() + offsetY + this.maxBlueprintSize[1] + platformOffset), (double)(this.originPos.method_10260() + offsetZ + this.maxBlueprintSize[2]));
                            EffectRenderer.renderBoundingBox((class_4184)camera, (long)time, (class_4587)poseStack, (class_243)firstPosition, (class_243)secondPosition, (int)3);
                        }
                    }
                }
            }
        }
    }

    private void updateBlueprintsPreview() {
        int maxX = 0;
        int maxY = 0;
        int maxZ = 0;
        for (ClipboardObject blueprint : this.blueprints) {
            class_2338 min = blueprint.blockRegion().min();
            class_2338 max = blueprint.blockRegion().max();
            if (min == null || max == null) continue;
            int sizeX = max.method_10263() - min.method_10263() + 1;
            int sizeY = max.method_10264() - min.method_10264() + 1;
            int sizeZ = max.method_10260() - min.method_10260() + 1;
            maxX = Math.max(maxX, sizeX);
            maxY = Math.max(maxY, sizeY);
            maxZ = Math.max(maxZ, sizeZ);
        }
        if (this.forceSingleBlockCenter && !this.overrideBlueprintSize) {
            if (maxX % 2 == 0) {
                ++maxX;
            }
            if (maxZ % 2 == 0) {
                // empty if block
            }
        }
        this.minBlueprintSize[0] = maxX;
        this.minBlueprintSize[1] = maxY;
        this.minBlueprintSize[2] = ++maxZ;
        if (!this.overrideBlueprintSize) {
            this.maxBlueprintSize[0] = maxX;
            this.maxBlueprintSize[1] = maxY;
            this.maxBlueprintSize[2] = maxZ;
        } else {
            this.maxBlueprintSize[0] = Math.max(this.maxBlueprintSize[0], this.minBlueprintSize[0]);
            this.maxBlueprintSize[1] = Math.max(this.maxBlueprintSize[1], this.minBlueprintSize[1]);
            this.maxBlueprintSize[2] = Math.max(this.maxBlueprintSize[2], this.minBlueprintSize[2]);
        }
        if (this.livePreview) {
            this.previewDirty = true;
        }
    }

    private void updatePreview() {
        this.previewRegion.clear();
        this.previewBlockEntities.clear();
        if (this.originPos == null || this.blueprints.isEmpty()) {
            this.previewDirty = false;
            return;
        }
        class_2338.class_2339 blockPos = new class_2338.class_2339();
        int blueprintIndex = 0;
        int gridZ = this.calculateGridZ();
        int insertX = (int)((double)this.maxBlueprintSize[0] / 2.0 - 0.5);
        int insertZ = (int)((double)this.maxBlueprintSize[2] / 2.0 - 0.5);
        int platformOffset = this.createPlatform ? 1 : 0;
        for (int x = 0; x < this.gridSizeX[0]; ++x) {
            for (int y = 0; y < this.gridSizeY[0]; ++y) {
                for (int z = 0; z < gridZ && blueprintIndex < this.blueprints.size(); ++z, ++blueprintIndex) {
                    int cellX = this.originPos.method_10263() + x * (this.maxBlueprintSize[0] + this.space[0]);
                    int cellY = this.originPos.method_10264() + y * (this.maxBlueprintSize[1] + this.space[1]);
                    int cellZ = this.originPos.method_10260() + z * (this.maxBlueprintSize[2] + this.space[2]);
                    if (this.createPlatform) {
                        this.createPlatformForCell(this.previewRegion, cellX, cellY, cellZ);
                    }
                    blockPos.method_10103(cellX + insertX, cellY += platformOffset, cellZ + insertZ);
                    this.pasteInto(this.blueprints.get(blueprintIndex), this.previewRegion, this.previewBlockEntities, blockPos);
                }
            }
        }
        this.previewDirty = false;
    }

    public UserAction.ActionResult callAction(UserAction action, Object object) {
        return switch (action) {
            case UserAction.RIGHT_MOUSE -> {
                RayCaster.RaycastResult result = Tool.raycastBlock((boolean)false, (boolean)true, (boolean)Tool.defaultIncludeFluids());
                if (result != null) {
                    this.originPos = this.useRelativePosition ? result.blockPos().method_10093(result.direction()) : result.blockPos();
                    this.updateBlueprintsPreview();
                }
                yield UserAction.ActionResult.USED_STOP;
            }
            case UserAction.ESCAPE -> {
                if (this.originPos != null) {
                    this.originPos = null;
                    yield UserAction.ActionResult.USED_STOP;
                }
                yield UserAction.ActionResult.NOT_HANDLED;
            }
            case UserAction.ENTER -> {
                if (this.originPos != null) {
                    this.placeGrid();
                    this.originPos = null;
                    yield UserAction.ActionResult.USED_STOP;
                }
                yield UserAction.ActionResult.NOT_HANDLED;
            }
            case UserAction.DELETE -> {
                this.originPos = null;
                yield UserAction.ActionResult.USED_STOP;
            }
            default -> UserAction.ActionResult.NOT_HANDLED;
        };
    }

    private void placeGrid() {
        if (this.blueprints.isEmpty() || this.originPos == null) {
            return;
        }
        ChunkedBlockRegion chunkedBlockRegion = new ChunkedBlockRegion();
        Long2ObjectOpenHashMap blockEntities = new Long2ObjectOpenHashMap();
        class_2338.class_2339 blockPos = new class_2338.class_2339();
        int blueprintIndex = 0;
        int gridZ = this.calculateGridZ();
        int insertX = (int)((double)this.maxBlueprintSize[0] / 2.0 - 0.5);
        int insertZ = (int)((double)this.maxBlueprintSize[2] / 2.0 - 0.5);
        int platformOffset = this.createPlatform ? 1 : 0;
        for (int x = 0; x < this.gridSizeX[0]; ++x) {
            for (int y = 0; y < this.gridSizeY[0]; ++y) {
                for (int z = 0; z < gridZ && blueprintIndex < this.blueprints.size(); ++z, ++blueprintIndex) {
                    int cellX = this.originPos.method_10263() + x * (this.maxBlueprintSize[0] + this.space[0]);
                    int cellY = this.originPos.method_10264() + y * (this.maxBlueprintSize[1] + this.space[1]);
                    int cellZ = this.originPos.method_10260() + z * (this.maxBlueprintSize[2] + this.space[2]);
                    if (this.createPlatform) {
                        this.createPlatformForCell(chunkedBlockRegion, cellX, cellY, cellZ);
                    }
                    blockPos.method_10103(cellX + insertX, cellY += platformOffset, cellZ + insertZ);
                    this.pasteInto(this.blueprints.get(blueprintIndex), chunkedBlockRegion, (Long2ObjectMap<CompressedBlockEntity>)blockEntities, blockPos);
                }
            }
        }
        int modifiers = this.keepExisting ? HistoryEntry.MODIFIER_KEEP_EXISTING : 0;
        String countString = NumberFormat.getInstance().format(chunkedBlockRegion.count());
        String historyDescription = AxiomI18n.get((String)"axiom.history_description.placed", (Object[])new Object[]{countString});
        CreateGridPlaceUndoOperation undoOperation = new CreateGridPlaceUndoOperation(this.originPos, new ArrayList<ClipboardObject>(this.blueprints), this.gridSizeX[0], this.gridSizeY[0], new int[]{this.space[0], this.space[1], this.space[2]}, this.keepExisting, this.forceSingleBlockCenter, this.createPlatform, this.platformInnerBlock, this.platformOuterBlock, this.overrideBlueprintSize, new int[]{this.maxBlueprintSize[0], this.maxBlueprintSize[1], this.maxBlueprintSize[2]}, this.useRelativePosition, this.livePreview);
        RegionHelper.pushBlockRegionChange((ChunkedBlockRegion)chunkedBlockRegion, (Long2ObjectMap)blockEntities, (String)historyDescription, (int)modifiers, (AdditionalUndoOperation)undoOperation);
    }

    private void createPlatformForCell(ChunkedBlockRegion targetRegion, int cellX, int cellY, int cellZ) {
        class_2680 innerBlock = this.platformInnerBlock.getVanillaState();
        class_2680 outerBlock = this.platformOuterBlock.getVanillaState();
        int sizeX = this.maxBlueprintSize[0];
        int sizeZ = this.maxBlueprintSize[2];
        for (int px = 0; px < sizeX; ++px) {
            for (int pz = 0; pz < sizeZ; ++pz) {
                boolean isOuter = px == 0 || px == sizeX - 1 || pz == 0 || pz == sizeZ - 1;
                class_2680 blockToPlace = isOuter ? outerBlock : innerBlock;
                targetRegion.addBlock(cellX + px, cellY, cellZ + pz, blockToPlace);
            }
        }
    }

    private void pasteInto(ClipboardObject source, ChunkedBlockRegion targetRegion, Long2ObjectMap<CompressedBlockEntity> targetEntities, class_2338.class_2339 blockPos) {
        int minY = Objects.requireNonNull(source.blockRegion().min()).method_10264() * -1;
        int xo = blockPos.method_10263();
        int yo = blockPos.method_10264() + minY;
        int zo = blockPos.method_10260();
        source.blockRegion().forEachEntry((x, y, z, state) -> {
            CompressedBlockEntity blockEntity = (CompressedBlockEntity)source.blockEntities().get(class_2338.method_10064((int)x, (int)y, (int)z));
            targetRegion.addBlock(x + xo, y + yo, z + zo, state);
            if (blockEntity != null) {
                targetEntities.put(class_2338.method_10064((int)(x + xo), (int)(y + yo), (int)(z + zo)), (Object)blockEntity);
            }
        });
    }

    public void displayImguiOptions() {
        boolean blueprintListOpened;
        boolean settingsChanged = false;
        ImGuiHelper.separatorWithText((String)"DBTools: Grid Place");
        ImGuiHelper.setupBorder();
        if (ImGuiHelper.inputInt((String)"Space/Gap", (int[])this.space, (boolean)true)) {
            if (this.space[0] < 0) {
                this.space[0] = 0;
            }
            if (this.space[1] < 0) {
                this.space[1] = 0;
            }
            if (this.space[2] < 0) {
                this.space[2] = 0;
            }
            settingsChanged = true;
        }
        ImGuiHelper.tooltip((String)"Scroll on these only works when Blueprint list is collapsed");
        if (!this.overrideBlueprintSize) {
            ImGui.beginDisabled();
        }
        if (ImGuiHelper.inputInt((String)(this.overrideBlueprintSize ? "Slot Size" : "Slot Size (auto)"), (int[])this.maxBlueprintSize, (boolean)true)) {
            if (this.maxBlueprintSize[0] < this.minBlueprintSize[0]) {
                this.maxBlueprintSize[0] = this.minBlueprintSize[0];
            }
            if (this.maxBlueprintSize[1] < this.minBlueprintSize[1]) {
                this.maxBlueprintSize[1] = this.minBlueprintSize[1];
            }
            if (this.maxBlueprintSize[2] < this.minBlueprintSize[2]) {
                this.maxBlueprintSize[2] = this.minBlueprintSize[2];
            }
            settingsChanged = true;
        }
        if (!this.overrideBlueprintSize) {
            ImGui.endDisabled();
        }
        if (ImGui.sliderInt((String)"Grid X", (int[])this.gridSizeX, (int)1, (int)10)) {
            if (this.gridSizeX[0] < 1) {
                this.gridSizeX[0] = 1;
            }
            settingsChanged = true;
        }
        if (ImGui.sliderInt((String)"Grid Y", (int[])this.gridSizeY, (int)1, (int)10)) {
            if (this.gridSizeY[0] < 1) {
                this.gridSizeY[0] = 1;
            }
            settingsChanged = true;
        }
        int gridZ = this.calculateGridZ();
        ImGui.text((String)("Grid Z (auto): " + gridZ));
        ImGui.text((String)("Total slots: " + this.gridSizeX[0] * this.gridSizeY[0] * gridZ));
        ImGui.text((String)("Blueprints: " + this.blueprints.size()));
        ImGuiHelper.finishBorder();
        ImGuiHelper.setupBorder();
        ImGuiHelper.separatorWithText((String)"Options");
        if (ImGui.checkbox((String)"Live Preview", (boolean)this.livePreview)) {
            boolean bl = this.livePreview = !this.livePreview;
            if (this.livePreview) {
                this.previewDirty = true;
            }
        }
        ImGuiHelper.tooltip((String)"Shows actual blocks instead of bounding boxes");
        if (ImGui.checkbox((String)"Override Blueprint Size", (boolean)this.overrideBlueprintSize)) {
            this.overrideBlueprintSize = !this.overrideBlueprintSize;
            settingsChanged = true;
        }
        ImGuiHelper.tooltip((String)"Manually set the slot size instead of auto-calculating from blueprints");
        if (this.overrideBlueprintSize) {
            ImGui.beginDisabled();
        }
        if (ImGui.checkbox((String)"Force Single Block Center", (boolean)this.forceSingleBlockCenter)) {
            this.forceSingleBlockCenter = !this.forceSingleBlockCenter;
            settingsChanged = true;
        }
        if (this.overrideBlueprintSize) {
            ImGui.endDisabled();
            ImGuiHelper.tooltip((String)"Not available when overriding blueprint size");
        } else {
            ImGuiHelper.tooltip((String)"Ensures slot width (X) and depth (Z) are odd numbers for a single center block");
        }
        if (ImGui.checkbox((String)"Use Relative Position", (boolean)this.useRelativePosition)) {
            this.useRelativePosition = !this.useRelativePosition;
        }
        ImGuiHelper.tooltip((String)"Places grid one block away from target in raycast direction");
        if (ImGui.checkbox((String)AxiomI18n.get((String)"axiom.editorui.window.clipboard.placement_options.keep_existing"), (boolean)this.keepExisting)) {
            this.keepExisting = !this.keepExisting;
            settingsChanged = true;
        }
        if (ImGui.checkbox((String)"Create Platform", (boolean)this.createPlatform)) {
            this.createPlatform = !this.createPlatform;
            settingsChanged = true;
        }
        ImGuiHelper.tooltip((String)"Creates a platform layer beneath each blueprint");
        if (this.createPlatform && ImGui.treeNodeEx((String)"Platform Settings")) {
            settingsChanged |= this.displayBlockWidget("1", this.platformInnerBlock, "Inner Block", platformInnerBlockWidget);
            settingsChanged |= this.displayBlockWidget("2", this.platformOuterBlock, "Outer Block", platformOuterBlockWidget);
            ImGui.treePop();
        }
        ImGuiHelper.finishBorder();
        ImGuiHelper.setupBorder();
        ImGuiHelper.separatorWithText((String)"Blueprints");
        if (!AxiomClient.hasPermission((AxiomPermission)AxiomPermission.CAN_IMPORT_BLOCKS)) {
            ImGui.beginDisabled();
            ImGui.button((String)"Add Blueprint");
            ImGui.endDisabled();
            ImGuiHelper.tooltip((String)"The server has disallowed the use of blueprints", (int)512);
        } else if (ImGui.button((String)"Add Blueprint")) {
            BlueprintBrowserWindow.open(this::blueprintCallback, (boolean)true);
        }
        ImGui.sameLine();
        if (ImGui.button((String)"Clear")) {
            this.blueprints.clear();
        }
        if (blueprintListOpened = ImGui.treeNodeEx((String)"Blueprints")) {
            int removeIndex = -1;
            for (int i = 0; i < this.blueprints.size(); ++i) {
                ClipboardObject blueprint = this.blueprints.get(i);
                ImGui.imageButton((int)blueprint.thumbnailTextureId(), (float)64.0f, (float)64.0f, (float)0.0f, (float)1.0f, (float)1.0f, (float)0.0f, (int)2);
                if (ImGui.isItemClicked((int)1)) {
                    ImGui.openPopup((String)("##EditBlueprint" + i));
                }
                if (ImGuiHelper.beginPopup((String)("##EditBlueprint" + i))) {
                    if (ImGui.menuItem((String)"Remove")) {
                        removeIndex = i;
                    }
                    ImGui.endPopup();
                }
                ImGui.sameLine();
                String name = blueprint.name();
                String displayName = !name.isBlank() ? name : "Unnamed Blueprint";
                String formattedCount = NumberFormat.getNumberInstance().format(blueprint.blockRegion().count());
                ImGui.text((String)(displayName + " (" + formattedCount + " blocks)"));
            }
            if (removeIndex >= 0) {
                this.blueprints.remove(removeIndex);
                settingsChanged = true;
            }
            ImGui.treePop();
        }
        ImGuiHelper.finishBorder();
        if (settingsChanged) {
            this.updateBlueprintsPreview();
        }
    }

    private boolean blueprintCallback(Blueprint blueprint) {
        if (ToolManager.isToolActive() && ToolManager.getCurrentTool() == this) {
            this.blueprints.add((ClipboardObject)new ClipboardObject.FromBlueprint(blueprint));
            this.updateBlueprintsPreview();
            return true;
        }
        return false;
    }

    private boolean displayBlockWidget(String id, CustomBlockState block, String text, BlockStateWidget widget) {
        ImGuiHelper.separatorWithText((String)text);
        widget.setBlockState(block);
        widget.renderBlockSwitcher(EditorUI.getBlockList(), id);
        ImGui.sameLine();
        ImGui.beginGroup();
        ImGuiHelper.pushStyleVar((int)14, (float)ImGui.getStyle().getItemSpacingX(), (float)1.0f);
        ImGui.text((String)AxiomI18n.get((String)block.getCustomBlock().axiom$translationKey()));
        ImGui.text((String)block.getCustomBlock().axiom$getIdentifier().toString());
        ImGuiHelper.popStyleVar();
        ImGui.endGroup();
        CustomBlockState newBlock = widget.getBlockState();
        if (newBlock != block) {
            if (id.equals("1")) {
                this.platformInnerBlock = newBlock;
            } else {
                this.platformOuterBlock = newBlock;
            }
            return true;
        }
        return false;
    }

    public String listenForEsc() {
        return this.originPos != null ? "Cancel Grid Placement" : null;
    }

    public String listenForEnter() {
        return this.originPos != null ? "Confirm Grid Placement" : null;
    }

    public String name() {
        return "DBTools: Grid Place";
    }

    public void writeSettings(class_2487 tag) {
    }

    public void loadSettings(class_2487 tag) {
    }

    public char iconChar() {
        return this.iconChar;
    }

    public String keybindId() {
        return "";
    }

    public EnumSet<AxiomPermission> requiredPermissions() {
        return EnumSet.of(AxiomPermission.TOOL, AxiomPermission.BUILD_SECTION);
    }
}

