/*
 * Decompiled with CFR 0.152.
 */
package com.denni5x.dbtools.client.UI;

import com.denni5x.dbtools.client.UI.RemoveTagListWidget;
import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.blueprint.Blueprint;
import com.moulberry.axiom.blueprint.BlueprintHeader;
import com.moulberry.axiom.blueprint.BlueprintIo;
import com.moulberry.axiom.editor.BlueprintPreview;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.editor.widgets.TagListWidget;
import com.moulberry.axiom.editor.windows.clipboard.BlueprintBrowserWindow;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import imgui.ImGui;
import imgui.ImVec2;
import imgui.type.ImBoolean;
import imgui.type.ImString;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;

@Environment(value=EnvType.CLIENT)
public class BulkBlueprintEditWindow {
    private static final List<SelectedBlueprint> selectedBlueprints = new ArrayList<SelectedBlueprint>();
    private static final Pattern NUMBER_PATTERN = Pattern.compile("(\\d+)|(\\D+)");
    private static final ImString bulkNamePrefix = new ImString();
    private static final ImString bulkNameSuffix = new ImString();
    private static final ImString searchText = new ImString();
    private static final ImString replaceText = new ImString();
    private static final ImString bulkAuthor = new ImString();
    private static final TagListWidget addTagsWidget = new TagListWidget();
    private static final RemoveTagListWidget removeTagsWidget = new RemoveTagListWidget();
    private static final ImBoolean applyNameChanges = new ImBoolean(false);
    private static final ImBoolean applySearchReplace = new ImBoolean(false);
    private static final ImBoolean renamePhysicalFiles = new ImBoolean(true);
    private static final ImBoolean applyAuthorChanges = new ImBoolean(false);
    private static final ImBoolean applyAngleChanges = new ImBoolean(false);
    private static final float[] bulkAngle = new float[]{0.0f, 0.0f};
    private static final List<Path> blueprintDirectoryStack = new ArrayList<Path>();
    private static final List<BlueprintEntry> currentBlueprintEntries = new ArrayList<BlueprintEntry>();
    private static boolean isOpen = false;
    private static int previewIndex = 0;
    private static BlueprintPreview currentPreview = null;
    private static boolean isRotating = false;
    private static float lastMouseX = 0.0f;
    private static float lastMouseY = 0.0f;
    private static boolean bulkEditInProgress = false;
    private static int currentBlueprintIndex = 0;
    private static long bulkEditStartTime = 0L;
    private static long bulkEditFinishTime = 0L;
    private static boolean browserExpanded = true;
    private static Path rootBlueprintPath = null;
    private static Path currentBlueprintPath = null;

    private static int naturalCompare(String s1, String s2) {
        Matcher m1 = NUMBER_PATTERN.matcher(s1);
        Matcher m2 = NUMBER_PATTERN.matcher(s2);
        while (m1.find() && m2.find()) {
            int cmp;
            String part1 = m1.group();
            String part2 = m2.group();
            if (Character.isDigit(part1.charAt(0)) && Character.isDigit(part2.charAt(0))) {
                try {
                    Long num1 = Long.parseLong(part1);
                    Long num2 = Long.parseLong(part2);
                    cmp = num1.compareTo(num2);
                }
                catch (NumberFormatException e) {
                    cmp = part1.compareTo(part2);
                }
            } else {
                cmp = part1.compareToIgnoreCase(part2);
            }
            if (cmp == 0) continue;
            return cmp;
        }
        if (m1.find()) {
            return 1;
        }
        if (m2.find()) {
            return -1;
        }
        return 0;
    }

    public static void open() {
        isOpen = true;
        selectedBlueprints.clear();
        bulkNamePrefix.clear();
        bulkNameSuffix.clear();
        searchText.clear();
        replaceText.clear();
        bulkAuthor.clear();
        addTagsWidget.tags().clear();
        removeTagsWidget.clear();
        applyNameChanges.set(false);
        applySearchReplace.set(false);
        renamePhysicalFiles.set(true);
        applyAuthorChanges.set(false);
        applyAngleChanges.set(false);
        BulkBlueprintEditWindow.bulkAngle[0] = 0.0f;
        BulkBlueprintEditWindow.bulkAngle[1] = 0.0f;
        previewIndex = 0;
        bulkEditInProgress = false;
        currentBlueprintIndex = 0;
        bulkEditStartTime = 0L;
        bulkEditFinishTime = 0L;
        currentBlueprintPath = rootBlueprintPath = Axiom.getInstance().getBlueprintDirectory();
        blueprintDirectoryStack.clear();
        BulkBlueprintEditWindow.loadCurrentDirectory();
    }

    private static void addBlueprintToSelection(Path blueprintPath) {
        try (BufferedInputStream inputStream = new BufferedInputStream(Files.newInputStream(blueprintPath, new OpenOption[0]));){
            Blueprint blueprint = BlueprintIo.readBlueprint((InputStream)inputStream);
            String blueprintName = blueprint.header().name();
            for (SelectedBlueprint existing : selectedBlueprints) {
                if (existing.path == null || !existing.path.equals(blueprintPath)) continue;
                blueprint.close();
                return;
            }
            SelectedBlueprint selected = new SelectedBlueprint(blueprintPath, blueprintName, blueprint.header().author(), new ArrayList<String>(blueprint.header().tags()), blueprint.header().thumbnailYaw(), blueprint.header().thumbnailPitch());
            selectedBlueprints.add(selected);
            blueprint.close();
            BulkBlueprintEditWindow.updateAvailableTags();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void updateAvailableTags() {
        HashSet<String> allTags = new HashSet<String>();
        for (SelectedBlueprint bp : selectedBlueprints) {
            allTags.addAll(bp.tags);
        }
        ArrayList<String> sortedTags = new ArrayList<String>(allTags);
        sortedTags.sort(String.CASE_INSENSITIVE_ORDER);
        removeTagsWidget.setAvailableTags(sortedTags);
    }

    public static void render() {
        if (!isOpen) {
            return;
        }
        if (bulkEditInProgress && currentBlueprintIndex < selectedBlueprints.size()) {
            BulkBlueprintEditWindow.processSingleBlueprint(currentBlueprintIndex);
            if (++currentBlueprintIndex >= selectedBlueprints.size()) {
                bulkEditInProgress = false;
                bulkEditFinishTime = System.currentTimeMillis();
                for (SelectedBlueprint bp : selectedBlueprints) {
                    if (bp.originalPath == null || bp.originalPath.equals(bp.path)) continue;
                    try {
                        if (!Files.exists(bp.originalPath, new LinkOption[0])) continue;
                        Files.delete(bp.originalPath);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                BulkBlueprintEditWindow.loadCurrentDirectory();
                BulkBlueprintEditWindow.updateAvailableTags();
            }
        }
        ImVec2 center = ImGui.getMainViewport().getCenter();
        ImGui.setNextWindowPos((float)center.x, (float)center.y, (int)4, (float)0.5f, (float)0.5f);
        ImGui.setNextWindowSize((float)800.0f, (float)600.0f, (int)4);
        ImBoolean windowOpen = new ImBoolean(true);
        if (ImGui.begin((String)"Bulk Blueprint Editor###BulkBlueprintEditor", (ImBoolean)windowOpen)) {
            BulkBlueprintEditWindow.renderContent();
        }
        ImGui.end();
        if (!windowOpen.get()) {
            BulkBlueprintEditWindow.close();
        }
    }

    private static void loadCurrentDirectory() {
        currentBlueprintEntries.clear();
        if (currentBlueprintPath == null || !Files.exists(currentBlueprintPath, new LinkOption[0])) {
            return;
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(currentBlueprintPath);){
            ArrayList<Path> directories = new ArrayList<Path>();
            ArrayList<Path> blueprints = new ArrayList<Path>();
            for (Path entry : stream) {
                if (Files.isDirectory(entry, new LinkOption[0])) {
                    directories.add(entry);
                    continue;
                }
                if (!entry.toString().endsWith(".bp")) continue;
                blueprints.add(entry);
            }
            directories.sort((p1, p2) -> BulkBlueprintEditWindow.naturalCompare(p1.getFileName().toString(), p2.getFileName().toString()));
            blueprints.sort((p1, p2) -> BulkBlueprintEditWindow.naturalCompare(p1.getFileName().toString(), p2.getFileName().toString()));
            for (Path dir : directories) {
                currentBlueprintEntries.add(new BlueprintEntry(dir, true));
            }
            for (Path bp : blueprints) {
                currentBlueprintEntries.add(new BlueprintEntry(bp, false));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void navigateToDirectory(Path directory) {
        if (directory != null && Files.isDirectory(directory, new LinkOption[0])) {
            blueprintDirectoryStack.add(currentBlueprintPath);
            currentBlueprintPath = directory;
            BulkBlueprintEditWindow.loadCurrentDirectory();
        }
    }

    private static void navigateBack() {
        if (!blueprintDirectoryStack.isEmpty()) {
            currentBlueprintPath = blueprintDirectoryStack.remove(blueprintDirectoryStack.size() - 1);
            BulkBlueprintEditWindow.loadCurrentDirectory();
        }
    }

    private static void renderBlueprintBrowser() {
        float browserWidth;
        float f = browserWidth = browserExpanded ? 250.0f : 45.0f;
        if (ImGui.beginChild((String)"BlueprintBrowser", (float)browserWidth, (float)-38.0f, (boolean)true)) {
            if (!browserExpanded) {
                if (ImGui.button((String)"\u2192", (float)30.0f, (float)30.0f)) {
                    browserExpanded = true;
                }
                if (ImGui.isItemHovered()) {
                    ImGui.beginTooltip();
                    ImGui.text((String)"Expand Browser");
                    ImGui.endTooltip();
                }
            } else {
                boolean canGoBack;
                ImGui.text((String)"Blueprint Browser");
                ImGui.separator();
                boolean bl = canGoBack = !blueprintDirectoryStack.isEmpty();
                if (!canGoBack) {
                    ImGui.beginDisabled();
                }
                if (ImGui.button((String)"\u2190 Back", (float)-1.0f, (float)0.0f)) {
                    BulkBlueprintEditWindow.navigateBack();
                }
                if (!canGoBack) {
                    ImGui.endDisabled();
                }
                ImGui.separator();
                String relativePath = rootBlueprintPath.relativize(currentBlueprintPath).toString();
                if (relativePath.isEmpty()) {
                    relativePath = "[Root]";
                }
                ImGui.textWrapped((String)relativePath);
                ImGui.separator();
                Path navTo = null;
                for (BlueprintEntry entry : currentBlueprintEntries) {
                    ImGui.pushID((String)entry.path.toString());
                    if (entry.isDirectory) {
                        if (ImGui.selectable((String)("\u2192 " + entry.path.getFileName().toString()), (boolean)false)) {
                            navTo = entry.path;
                        }
                    } else {
                        String filename = entry.path.getFileName().toString();
                        if (filename.endsWith(".bp")) {
                            filename = filename.substring(0, filename.length() - 3);
                        }
                        if (ImGui.selectable((String)filename, (boolean)false)) {
                            BulkBlueprintEditWindow.addBlueprintToSelection(entry.path);
                        }
                    }
                    ImGui.popID();
                }
                if (navTo != null) {
                    BulkBlueprintEditWindow.navigateToDirectory(navTo);
                }
            }
        }
        ImGui.endChild();
    }

    private static void renderContent() {
        boolean canApply;
        BulkBlueprintEditWindow.renderBlueprintBrowser();
        ImGui.sameLine();
        if (ImGui.beginChild((String)"SelectedList", (float)250.0f, (float)-38.0f, (boolean)true)) {
            ImGui.text((String)("Selected Blueprints (" + selectedBlueprints.size() + ")"));
            ImGui.separator();
            float buttonWidth = 20.0f;
            float itemHeight = ImGui.getTextLineHeightWithSpacing();
            for (int i = selectedBlueprints.size() - 1; i >= 0; --i) {
                SelectedBlueprint bp = selectedBlueprints.get(i);
                ImGui.pushID((int)i);
                boolean selected = previewIndex == i;
                float selectableWidth = ImGui.getContentRegionAvail().x - buttonWidth - ImGui.getStyle().getItemSpacingX();
                if (ImGui.selectable((String)(bp.name + "##" + i), (boolean)selected, (int)0, (float)selectableWidth, (float)itemHeight)) {
                    previewIndex = i;
                    BulkBlueprintEditWindow.updatePreview(i);
                }
                ImGui.sameLine((float)(ImGui.getWindowContentRegionMax().x - buttonWidth));
                if (ImGui.button((String)("X##remove" + i), (float)buttonWidth, (float)itemHeight)) {
                    selectedBlueprints.remove(i);
                    if (previewIndex >= selectedBlueprints.size()) {
                        previewIndex = Math.max(0, selectedBlueprints.size() - 1);
                    }
                    BulkBlueprintEditWindow.updatePreview(previewIndex);
                    BulkBlueprintEditWindow.updateAvailableTags();
                }
                ImGui.popID();
            }
            ImGui.separator();
            if (ImGui.button((String)"Sort", (float)-1.0f, (float)0.0f)) {
                selectedBlueprints.sort((bp1, bp2) -> BulkBlueprintEditWindow.naturalCompare(bp1.name, bp2.name));
            }
            if (ImGui.button((String)"Clear All", (float)-1.0f, (float)0.0f)) {
                selectedBlueprints.clear();
                previewIndex = 0;
                if (currentPreview != null) {
                    currentPreview.clear();
                    currentPreview = null;
                }
                BulkBlueprintEditWindow.updateAvailableTags();
            }
        }
        ImGui.endChild();
        ImGui.sameLine();
        if (ImGui.beginChild((String)"EditPanel", (float)0.0f, (float)-38.0f, (boolean)true)) {
            if (!selectedBlueprints.isEmpty() && previewIndex < selectedBlueprints.size()) {
                SelectedBlueprint current = selectedBlueprints.get(previewIndex);
                ImGui.text((String)("Preview: " + current.name));
                if (currentPreview != null) {
                    ImGui.image((int)currentPreview.render(512, true, true), (float)200.0f, (float)200.0f, (float)0.0f, (float)1.0f, (float)1.0f, (float)0.0f);
                    if (isRotating) {
                        if (!ImGui.isMouseDown((int)0)) {
                            isRotating = false;
                            currentPreview.mouseReleased();
                        } else {
                            float mouseX = ImGui.getMousePosX();
                            float mouseY = ImGui.getMousePosY();
                            currentPreview.mouseMoved(mouseX - lastMouseX, mouseY - lastMouseY, EditorUI.isCtrlOrCmdDown());
                            lastMouseX = mouseX;
                            lastMouseY = mouseY;
                        }
                    } else if (ImGui.isItemClicked((int)0)) {
                        isRotating = true;
                        lastMouseX = ImGui.getMousePosX();
                        lastMouseY = ImGui.getMousePosY();
                    }
                }
            }
            ImGui.separator();
            ImGui.text((String)"Bulk Edit Options");
            ImGui.separator();
            ImGui.checkbox((String)"Modify Names", (ImBoolean)applyNameChanges);
            if (applyNameChanges.get()) {
                ImGui.inputTextWithHint((String)"Prefix", (String)"Add prefix", (ImString)bulkNamePrefix);
                ImGui.inputTextWithHint((String)"Suffix", (String)"Add suffix (e.g., _{i})", (ImString)bulkNameSuffix);
                ImGui.textWrapped((String)"Use {i} for numbering (e.g., blueprint_{i} -> blueprint_1, blueprint_2, ...)");
            }
            ImGui.separator();
            ImGui.checkbox((String)"Search and Replace in Names", (ImBoolean)applySearchReplace);
            if (applySearchReplace.get()) {
                ImGui.inputTextWithHint((String)"Search", (String)"Text to find", (ImString)searchText);
                ImGui.inputTextWithHint((String)"Replace", (String)"Text to replace with", (ImString)replaceText);
                ImGui.checkbox((String)"Also rename physical files", (ImBoolean)renamePhysicalFiles);
                ImGuiHelper.tooltip((String)"Renames the .bp files on disk to match the new blueprint names");
            }
            ImGui.separator();
            ImGui.checkbox((String)"Change Author", (ImBoolean)applyAuthorChanges);
            if (applyAuthorChanges.get()) {
                ImGui.inputText((String)"Author Name", (ImString)bulkAuthor);
            }
            ImGui.separator();
            ImGui.text((String)"Add Tags:");
            ImGui.pushID((String)"addTags");
            addTagsWidget.render(300);
            ImGui.popID();
            ImGui.separator();
            ImGui.text((String)"Remove Tags:");
            ImGui.pushID((String)"removeTags");
            removeTagsWidget.render(300);
            ImGui.popID();
            ImGui.separator();
            ImGui.checkbox((String)"Change Preview Angle", (ImBoolean)applyAngleChanges);
            if (applyAngleChanges.get()) {
                if (ImGui.inputFloat2((String)"Yaw/Pitch", (float[])bulkAngle, (String)"%.2f")) {
                    if (currentPreview != null) {
                        currentPreview.setYaw(bulkAngle[0], false);
                        currentPreview.setPitch(bulkAngle[1], false);
                    }
                    if (previewIndex >= 0 && previewIndex < selectedBlueprints.size()) {
                        SelectedBlueprint current = selectedBlueprints.get(previewIndex);
                        current.yaw = bulkAngle[0];
                        current.pitch = bulkAngle[1];
                    }
                }
                ImGui.unindent();
            }
        }
        ImGui.endChild();
        ImGui.separator();
        boolean bl = canApply = !bulkEditInProgress && !selectedBlueprints.isEmpty();
        if (!canApply) {
            ImGui.beginDisabled();
        }
        if (ImGui.button((String)"Apply Changes")) {
            BulkBlueprintEditWindow.startBulkEdit();
        }
        if (!canApply) {
            ImGui.endDisabled();
        }
        ImGui.sameLine();
        if (ImGui.button((String)"Cancel")) {
            BulkBlueprintEditWindow.close();
        }
        if (bulkEditInProgress || bulkEditFinishTime > 0L) {
            ImGui.sameLine();
            int percentage = selectedBlueprints.isEmpty() ? 100 : currentBlueprintIndex * 100 / selectedBlueprints.size();
            ImGui.text((String)("Progress: " + percentage + "%"));
            ImGui.sameLine();
            long currentTime = System.currentTimeMillis();
            if (currentTime < bulkEditStartTime) {
                bulkEditStartTime = 0L;
            }
            long duration = bulkEditStartTime > 0L && bulkEditFinishTime == 0L ? (currentTime - bulkEditStartTime) / 1000L : (bulkEditFinishTime > 0L ? (bulkEditFinishTime - bulkEditStartTime) / 1000L : 0L);
            String durationString = String.format("Elapsed Time: %02d:%02d", duration / 60L, duration % 60L);
            ImGui.text((String)durationString);
        }
    }

    private static void updatePreview(int index) {
        if (index < 0 || index >= selectedBlueprints.size()) {
            return;
        }
        if (currentPreview == null) {
            currentPreview = new BlueprintPreview();
        }
        SelectedBlueprint bp = selectedBlueprints.get(index);
        if (applyAngleChanges.get()) {
            BulkBlueprintEditWindow.bulkAngle[0] = bp.yaw;
            BulkBlueprintEditWindow.bulkAngle[1] = bp.pitch;
        }
        if (bp.path != null) {
            try (BufferedInputStream inputStream = new BufferedInputStream(Files.newInputStream(bp.path, new OpenOption[0]));){
                Blueprint blueprint = BlueprintIo.readBlueprint((InputStream)inputStream);
                currentPreview.setBlockRegion(blueprint.blockRegion());
                currentPreview.setYaw(bp.yaw, false);
                currentPreview.setPitch(bp.pitch, false);
                blueprint.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void startBulkEdit() {
        if (selectedBlueprints.isEmpty()) {
            return;
        }
        bulkEditInProgress = true;
        currentBlueprintIndex = 0;
        bulkEditStartTime = System.currentTimeMillis();
        bulkEditFinishTime = 0L;
    }

    private static void processSingleBlueprint(int i) {
        if (i >= selectedBlueprints.size()) {
            return;
        }
        SelectedBlueprint bp = selectedBlueprints.get(i);
        if (bp.path == null) {
            return;
        }
        try (BufferedInputStream inputStream = new BufferedInputStream(Files.newInputStream(bp.path, new OpenOption[0]));){
            Blueprint blueprint = BlueprintIo.readBlueprint((InputStream)inputStream);
            String originalName = bp.name;
            Object newName = bp.name;
            if (applyNameChanges.get()) {
                String prefix = ImGuiHelper.getString((ImString)bulkNamePrefix);
                String suffix = ImGuiHelper.getString((ImString)bulkNameSuffix);
                suffix = suffix.replace("{i}", String.valueOf(i + 1));
                newName = prefix + bp.name + suffix;
            }
            if (applySearchReplace.get()) {
                String search = ImGuiHelper.getString((ImString)searchText);
                String replace = ImGuiHelper.getString((ImString)replaceText);
                if (!search.isEmpty()) {
                    newName = ((String)newName).replace(search, replace);
                }
            }
            String newAuthor = bp.author;
            if (applyAuthorChanges.get()) {
                newAuthor = ImGuiHelper.getString((ImString)bulkAuthor);
            }
            ArrayList<String> newTags = new ArrayList<String>(bp.tags);
            newTags.addAll(addTagsWidget.tags());
            newTags.removeAll(removeTagsWidget.tagsToRemove());
            float newYaw = bp.yaw;
            float newPitch = bp.pitch;
            if (applyAngleChanges.get()) {
                newYaw = bulkAngle[0];
                newPitch = bulkAngle[1];
            }
            BlueprintHeader newHeader = new BlueprintHeader((String)newName, newAuthor, newTags, newYaw, newPitch, blueprint.header().lockedThumbnail(), blueprint.header().blockCount(), blueprint.header().containsAir());
            Path outputPath = bp.path;
            boolean shouldRenameFile = false;
            if (!((String)newName).equals(originalName) && applySearchReplace.get() && renamePhysicalFiles.get()) {
                shouldRenameFile = true;
            }
            if (shouldRenameFile) {
                String newFileName = (String)newName + ".bp";
                Path newPath = bp.path.getParent().resolve(newFileName);
                if (!newPath.equals(bp.path) && Files.exists(newPath, new LinkOption[0])) {
                    int counter = 1;
                    while (Files.exists(newPath, new LinkOption[0])) {
                        newFileName = (String)newName + "_" + counter + ".bp";
                        newPath = bp.path.getParent().resolve(newFileName);
                        ++counter;
                    }
                }
                outputPath = newPath;
            }
            try (BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(outputPath, new OpenOption[0]));){
                BlueprintIo.write((OutputStream)outputStream, (BlueprintHeader)newHeader, (class_1011)blueprint.thumbnail().get().method_4525(), (ChunkedBlockRegion)blueprint.blockRegion(), (Long2ObjectMap)blueprint.blockEntities(), (List)blueprint.entities());
            }
            if (!outputPath.equals(bp.path)) {
                bp.path = outputPath;
                BlueprintBrowserWindow.updatedBlueprintPaths.add(outputPath);
            } else {
                BlueprintBrowserWindow.updatedBlueprintPaths.add(bp.path);
            }
            bp.name = newName;
            bp.author = newAuthor;
            bp.tags = newTags;
            bp.yaw = newYaw;
            bp.pitch = newPitch;
            blueprint.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void close() {
        isOpen = false;
        selectedBlueprints.clear();
        if (currentPreview != null) {
            currentPreview.clear();
            currentPreview = null;
        }
        bulkEditInProgress = false;
        currentBlueprintIndex = 0;
        bulkEditStartTime = 0L;
        bulkEditFinishTime = 0L;
        BlueprintBrowserWindow.resetCallback();
    }

    @Environment(value=EnvType.CLIENT)
    private static class SelectedBlueprint {
        Path path;
        Path originalPath;
        String name;
        String author;
        List<String> tags;
        float yaw;
        float pitch;

        public SelectedBlueprint(Path path, String name, String author, List<String> tags, float yaw, float pitch) {
            this.path = path;
            this.originalPath = path;
            this.name = name;
            this.author = author;
            this.tags = tags;
            this.yaw = yaw;
            this.pitch = pitch;
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class BlueprintEntry {
        Path path;
        boolean isDirectory;

        public BlueprintEntry(Path path, boolean isDirectory) {
            this.path = path;
            this.isDirectory = isDirectory;
        }
    }
}

