/*
 * Decompiled with CFR 0.152.
 */
package com.denni5x.dbtools.client.UI;

import com.denni5x.dbtools.client.Utils.BlueprintUtils;
import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.blueprint.Blueprint;
import com.moulberry.axiom.blueprint.BlueprintIo;
import com.moulberry.axiom.clipboard.ClipboardObject;
import com.moulberry.axiom.downgrade.DowngradeVersion;
import com.moulberry.axiom.downgrade.DowngradeVersionList;
import com.moulberry.axiom.editor.BlueprintPreview;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.editor.schematic.SchematicLoader;
import com.moulberry.axiom.editor.windows.save_world.SaveSchematicAction;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.utils.AsyncFileDialogs;
import com.moulberry.axiom.utils.Authorization;
import com.moulberry.axiom.utils.StringUtils;
import com.moulberry.axiom.world_modification.CompressedBlockEntity;
import imgui.ImGui;
import imgui.ImVec2;
import imgui.type.ImBoolean;
import imgui.type.ImString;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_124;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2561;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class ConversionWindow {
    private static boolean isOpen = false;
    private static final int[] downgradeVersion = new int[]{0};
    private static SaveSchematicAction saveSchematicAction = null;
    private static String extension = null;
    private static DowngradeVersion version = null;
    private static final ArrayList<Blueprint> blueprintsQueue = new ArrayList();
    private static int currentBlueprint = 0;
    private static boolean bp2schemConversionOngoing = false;
    private static long bp2schemStartTime = 0L;
    private static long bp2schemFinishTime = 0L;
    private static int maxImageCounter = 0;
    private static boolean schem2bpConversionOngoing = false;
    private static int currentSchematic = 0;
    private static final ArrayList<Path> schematicPaths = new ArrayList();
    private static boolean saveAir = false;
    private static ClipboardObject currentClipboard = null;
    private static CompletableFuture<ClipboardObject> clipboardObjectFuture = null;
    private static CompletableFuture<class_1011> blueprintPreviewFuture = null;
    private static BlueprintPreview blueprintPreview = null;
    private static long schem2bpStartTime = 0L;
    private static long schem2bpFinishTime = 0L;
    private static Path blueprintPath = Path.of(Axiom.getInstance().getBlueprintDirectory().toString(), new String[0]);
    private static CompletableFuture<String> blueprintFolderFuture;
    private static Path schematicPath;
    private static CompletableFuture<String> schematicFolderFuture;

    public static void open() {
        isOpen = true;
    }

    public static void close() {
        isOpen = false;
    }

    public static void render() {
        String folderPath;
        if (!isOpen) {
            return;
        }
        if (blueprintFolderFuture != null && blueprintFolderFuture.isDone()) {
            folderPath = blueprintFolderFuture.join();
            if (folderPath != null && !folderPath.isEmpty()) {
                blueprintPath = Path.of(folderPath, new String[0]);
            }
            blueprintFolderFuture = null;
        }
        if (schematicFolderFuture != null && schematicFolderFuture.isDone()) {
            folderPath = schematicFolderFuture.join();
            if (folderPath != null && !folderPath.isEmpty()) {
                schematicPath = Path.of(folderPath, new String[0]);
            }
            schematicFolderFuture = null;
        }
        if (!blueprintsQueue.isEmpty() && !bp2schemConversionOngoing && currentBlueprint < blueprintsQueue.size()) {
            bp2schemConversionOngoing = true;
            Blueprint blueprint = blueprintsQueue.get(currentBlueprint);
            ConversionWindow.saveSchematic(version, extension, blueprint.header().author(), blueprint.header().name(), blueprint.blockRegion(), (Long2ObjectMap<CompressedBlockEntity>)blueprint.blockEntities());
            ++currentBlueprint;
            bp2schemConversionOngoing = false;
        }
        ImVec2 center = ImGui.getMainViewport().getCenter();
        ImGui.setNextWindowPos((float)center.x, (float)center.y, (int)4, (float)0.5f, (float)0.5f);
        ImGui.setNextWindowSize((float)600.0f, (float)500.0f, (int)4);
        ImBoolean windowOpen = new ImBoolean(true);
        if (ImGui.begin((String)"File Conversion###ConversionWindow", (ImBoolean)windowOpen) && ImGui.beginTabBar((String)"ConversionTabs")) {
            if (ImGui.beginTabItem((String)"Blueprint to Schematic")) {
                ConversionWindow.renderBlueprintToSchematic();
                ImGui.endTabItem();
            }
            if (ImGui.beginTabItem((String)"Schematic to Blueprint")) {
                ConversionWindow.renderSchematicToBlueprint();
                ImGui.endTabItem();
            }
            ImGui.endTabBar();
        }
        ImGui.end();
        if (!windowOpen.get()) {
            ConversionWindow.close();
        }
    }

    private static void renderBlueprintToSchematic() {
        String[] versionStrings;
        ImGuiHelper.setupBorder();
        ImGuiHelper.separatorWithText((String)"Blueprint");
        ImGui.pushID((String)"blueprint_bp2schem");
        ImGui.inputText((String)"Path", (ImString)new ImString(blueprintPath.toString()), (int)16384);
        if (ImGui.button((String)"Set Folder")) {
            try {
                blueprintFolderFuture = AsyncFileDialogs.openFolderDialog((String)blueprintPath.toString());
            }
            catch (Exception e) {
                blueprintPath = Path.of(Axiom.getInstance().getBlueprintDirectory().toString(), new String[0]);
            }
        }
        ImGui.popID();
        ImGuiHelper.finishBorder();
        ImGuiHelper.setupBorder();
        ImGuiHelper.separatorWithText((String)"Schematic");
        ImGui.pushID((String)"schematic_bp2schem");
        ImGui.inputText((String)"Path", (ImString)new ImString(schematicPath.toString()), (int)16384);
        if (ImGui.button((String)"Set Folder")) {
            try {
                schematicFolderFuture = AsyncFileDialogs.openFolderDialog((String)schematicPath.toString());
            }
            catch (Exception e) {
                schematicPath = SchematicLoader.getDefaultSchematicDir();
            }
        }
        if ((versionStrings = DowngradeVersionList.getVersionStrings()) != null && versionStrings.length > 0) {
            if (!Authorization.hasCommercialLicense()) {
                ImGui.beginDisabled();
                ImGuiHelper.combo((String)"Version", (int[])downgradeVersion, (String[])versionStrings);
                ImGui.endDisabled();
                ImGuiHelper.tooltip((String)"Exporting to old versions is a Commercial License feature", (int)512);
            } else {
                ImGuiHelper.combo((String)"Version", (int[])downgradeVersion, (String[])versionStrings);
            }
        } else if (Authorization.hasCommercialLicense()) {
            ImGui.text((String)"\u26a0 Missing data for 1.20.1. Version exporting is unavailable.");
        }
        ImGui.popID();
        ImGuiHelper.finishBorder();
        if (ImGui.button((String)"Convert Blueprints to Schematics", (float)-1.0f, (float)0.0f)) {
            ConversionWindow.convertBlueprintsToSchematics();
        }
        if (!blueprintsQueue.isEmpty()) {
            if (!ImGui.isPopupOpen((String)"Blueprint To Schematic Progress")) {
                ImGui.openPopup((String)"Blueprint To Schematic Progress");
            }
            if (ImGuiHelper.beginPopupModal((String)"Blueprint To Schematic Progress", (int)64)) {
                long currentTime;
                int maxIterations = blueprintsQueue.size();
                int percentage = currentBlueprint * 100 / maxIterations;
                ImGui.text((String)("Progress: " + percentage + "%"));
                if (currentBlueprint == maxIterations && bp2schemFinishTime == 0L) {
                    bp2schemFinishTime = System.currentTimeMillis();
                }
                if ((currentTime = System.currentTimeMillis()) < bp2schemStartTime) {
                    bp2schemStartTime = 0L;
                }
                long duration = bp2schemStartTime > 0L && bp2schemFinishTime == 0L ? (currentTime - bp2schemStartTime) / 1000L : (bp2schemFinishTime - bp2schemStartTime) / 1000L;
                String durationString = String.format("Elapsed Time: %02d:%02d", duration / 60L, duration % 60L);
                ImGui.text((String)durationString);
                if (currentBlueprint == maxIterations && saveSchematicAction == null) {
                    if (ImGui.button((String)"Close")) {
                        ConversionWindow.resetBlueprintToSchematic();
                    }
                } else if (ImGui.button((String)"Cancel")) {
                    ConversionWindow.resetBlueprintToSchematic();
                }
                ImGui.endPopup();
            }
        }
    }

    private static void renderSchematicToBlueprint() {
        ImGuiHelper.setupBorder();
        ImGuiHelper.separatorWithText((String)"Schematic");
        ImGui.pushID((String)"schematic_schem2bp");
        ImGui.inputText((String)"Path", (ImString)new ImString(schematicPath.toString()), (int)16384);
        if (ImGui.button((String)"Set Folder")) {
            try {
                schematicFolderFuture = AsyncFileDialogs.openFolderDialog((String)schematicPath.toString());
            }
            catch (Exception e) {
                schematicPath = SchematicLoader.getDefaultSchematicDir();
            }
        }
        ImGui.popID();
        ImGuiHelper.finishBorder();
        ImGuiHelper.setupBorder();
        ImGuiHelper.separatorWithText((String)"Blueprint");
        ImGui.pushID((String)"blueprint_schem2bp");
        ImGui.inputText((String)"Path", (ImString)new ImString(blueprintPath.toString()), (int)16384);
        if (ImGui.button((String)"Set Folder")) {
            try {
                blueprintFolderFuture = AsyncFileDialogs.openFolderDialog((String)blueprintPath.toString());
            }
            catch (Exception e) {
                blueprintPath = Path.of(Axiom.getInstance().getBlueprintDirectory().toString(), new String[0]);
            }
        }
        if (ImGui.checkbox((String)"Save Air", (boolean)saveAir)) {
            saveAir = !saveAir;
        }
        ImGui.popID();
        ImGuiHelper.finishBorder();
        if (ImGui.button((String)"Convert Schematics to Blueprints", (float)-1.0f, (float)0.0f)) {
            ConversionWindow.convertSchematicsToBlueprints();
        }
        if (!schematicPaths.isEmpty()) {
            if (!ImGui.isPopupOpen((String)"Schematic To Blueprint Progress")) {
                ImGui.openPopup((String)"Schematic To Blueprint Progress");
            }
            if (ImGuiHelper.beginPopupModal((String)"Schematic To Blueprint Progress", (int)64)) {
                long currentTime;
                int maxIterations = schematicPaths.size();
                int percentage = currentSchematic * 100 / maxIterations;
                ImGui.text((String)("Progress: " + percentage + "%"));
                if (currentSchematic == maxIterations && schem2bpFinishTime == 0L) {
                    schem2bpFinishTime = System.currentTimeMillis();
                }
                if ((currentTime = System.currentTimeMillis()) < schem2bpStartTime) {
                    schem2bpStartTime = 0L;
                }
                long duration = schem2bpStartTime > 0L && schem2bpFinishTime == 0L ? (currentTime - schem2bpStartTime) / 1000L : (schem2bpFinishTime - schem2bpStartTime) / 1000L;
                String durationString = String.format("Elapsed Time: %02d:%02d", duration / 60L, duration % 60L);
                ImGui.text((String)durationString);
                if (currentSchematic == maxIterations && blueprintPreview == null) {
                    if (ImGui.button((String)"Close")) {
                        ConversionWindow.resetSchematicToBlueprint();
                    }
                } else {
                    if (schem2bpConversionOngoing && (currentClipboard = ConversionWindow.tryGetNextSchematic()) != null) {
                        String name;
                        if (blueprintPreview == null) {
                            blueprintPreview = new BlueprintPreview();
                            blueprintPreview.setBlockRegion(currentClipboard.blockRegion());
                        }
                        class_1011 nativeImage = ConversionWindow.tryGetImage();
                        String string = name = currentClipboard.name().isEmpty() ? schematicPaths.get(currentSchematic).getFileName().toString() : currentClipboard.name();
                        if (nativeImage != null) {
                            BlueprintUtils.saveBlueprint(name, class_310.method_1551().field_1724.method_5820(), currentClipboard, nativeImage, blueprintPath, blueprintPreview, currentSchematic, saveAir);
                            ++currentSchematic;
                            blueprintPreview = null;
                            currentClipboard = null;
                        }
                    }
                    if (ImGui.button((String)"Cancel")) {
                        ConversionWindow.resetSchematicToBlueprint();
                    }
                }
                ImGui.endPopup();
            }
        }
    }

    private static void convertBlueprintsToSchematics() {
        if (Authorization.hasCommercialLicense()) {
            version = (DowngradeVersion)DowngradeVersionList.getVersions().get(downgradeVersion[0]);
        }
        extension = version != null && version.getMaxDataVersion() < 1631 ? "schematic" : "schem";
        ConversionWindow.resetBlueprintToSchematic();
        bp2schemStartTime = System.currentTimeMillis();
        blueprintsQueue.addAll(ConversionWindow.getBlueprints());
    }

    private static void convertSchematicsToBlueprints() {
        ConversionWindow.resetSchematicToBlueprint();
        schem2bpConversionOngoing = true;
        schem2bpStartTime = System.currentTimeMillis();
        ConversionWindow.getSchematics();
    }

    private static void resetBlueprintToSchematic() {
        bp2schemStartTime = 0L;
        bp2schemFinishTime = 0L;
        currentBlueprint = 0;
        blueprintsQueue.clear();
        bp2schemConversionOngoing = false;
    }

    private static void resetSchematicToBlueprint() {
        schem2bpStartTime = 0L;
        schem2bpFinishTime = 0L;
        currentSchematic = 0;
        schem2bpConversionOngoing = false;
        blueprintPreview = null;
        currentClipboard = null;
        clipboardObjectFuture = null;
        schematicPaths.clear();
    }

    private static ArrayList<Blueprint> getBlueprints() {
        ArrayList<Blueprint> blueprints = new ArrayList<Blueprint>();
        try (Stream<Path> files = Files.list(blueprintPath);){
            files.filter(path -> path.toString().endsWith(".bp")).forEach(path -> {
                try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
                    Blueprint fullBlueprint = BlueprintIo.readBlueprint((InputStream)is);
                    blueprints.add(fullBlueprint);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return blueprints;
    }

    private static void saveSchematic(DowngradeVersion version, String extension, String author, String name, ChunkedBlockRegion blockRegion, Long2ObjectMap<CompressedBlockEntity> blockEntities) {
        String schematicNameString = name.trim();
        Object snakeName = schematicNameString.isEmpty() ? "unnamed." + extension : schematicNameString.toLowerCase(Locale.ROOT).replace(' ', '_') + "." + extension;
        snakeName = StringUtils.sanitizePath((String)snakeName);
        Object filePathName = schematicPath.toString() + "/" + (String)snakeName;
        filePathName = ((String)filePathName).replace(".schem.schem", ".schem");
        filePathName = ((String)filePathName).replace(".schematic.schematic", ".schematic");
        Path path = Path.of((String)filePathName, new String[0]);
        String authorNameStr = author.trim();
        if (authorNameStr.isEmpty()) {
            String string = authorNameStr = class_310.method_1551().field_1724 == null ? "Unknown" : class_310.method_1551().field_1724.method_5820();
        }
        if ((saveSchematicAction = new SaveSchematicAction(path, blockRegion, blockEntities, version, name, authorNameStr, null)).run()) {
            saveSchematicAction = null;
        }
    }

    private static void getSchematics() {
        try (Stream<Path> files = Files.list(schematicPath);){
            files.filter(path -> path.toString().endsWith(".schem") || path.toString().endsWith(".schematic") || path.toString().endsWith(".litematic")).forEach(schematicPaths::add);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static ClipboardObject tryGetNextSchematic() {
        if (clipboardObjectFuture != null) {
            if (clipboardObjectFuture.isDone()) {
                ClipboardObject clipboardObject2 = clipboardObjectFuture.join();
                clipboardObjectFuture = null;
                if (clipboardObject2 == null) {
                    class_310.method_1551().field_1705.method_1743().method_1812((class_2561)class_2561.method_43470((String)"Error while reading schematic").method_27692(class_124.field_1061));
                    ++currentSchematic;
                    return null;
                }
                return clipboardObject2;
            }
        } else {
            Path path = schematicPaths.get(currentSchematic);
            try {
                InputStream is = Files.newInputStream(path, new OpenOption[0]);
                class_2487 tag = class_2507.method_10629((InputStream)is, (class_2505)class_2505.method_53898());
                if (!tag.method_33133()) {
                    while (tag.method_10541().size() == 1) {
                        String key = (String)tag.method_10541().iterator().next();
                        class_2487 inner = tag.method_10562(key);
                        if (inner.method_33133()) continue;
                        tag = inner;
                    }
                    clipboardObjectFuture = ConversionWindow.loadSchematicAsync(tag).thenApply(clipboardObject -> {
                        ChunkedBlockRegion chunkedBlockRegion = new ChunkedBlockRegion();
                        if (!saveAir && clipboardObject.containsAir()) {
                            clipboardObject.blockRegion().forEachEntry((x, y, z, state) -> {
                                if (!state.method_26215()) {
                                    chunkedBlockRegion.addBlockWithoutDirty(x, y, z, state);
                                }
                            });
                        }
                        if (chunkedBlockRegion.isEmpty()) {
                            clipboardObject.blockRegion().forEachEntry((arg_0, arg_1, arg_2, arg_3) -> ((ChunkedBlockRegion)chunkedBlockRegion).addBlockWithoutDirty(arg_0, arg_1, arg_2, arg_3));
                        }
                        chunkedBlockRegion.dirtyAll();
                        return new ClipboardObject.Anonymous(chunkedBlockRegion, clipboardObject.blockEntities(), clipboardObject.entities(), clipboardObject.name(), clipboardObject.preferredYaw(), saveAir);
                    });
                    return null;
                }
            }
            catch (Throwable e) {
                class_310.method_1551().field_1705.method_1743().method_1812((class_2561)class_2561.method_43470((String)"Error at: ").method_27693(e.getMessage()).method_27693(" with file ").method_27693(path.toString()).method_27692(class_124.field_1061));
                ++currentSchematic;
                clipboardObjectFuture = null;
            }
        }
        return null;
    }

    private static CompletableFuture<ClipboardObject> loadSchematicAsync(class_2487 tag) {
        if (tag.method_10545("Regions")) {
            return CompletableFuture.supplyAsync(() -> SchematicLoader.loadLitematic((class_2487)tag));
        }
        if (tag.method_10545("Version")) {
            return CompletableFuture.supplyAsync(() -> SchematicLoader.loadSponge((class_2487)tag));
        }
        if (!tag.method_10545("Materials")) {
            throw new SchematicLoader.SchematicLoadException("Unknown format");
        }
        return CompletableFuture.supplyAsync(() -> SchematicLoader.loadLegacy((class_2487)tag));
    }

    private static class_1011 tryGetImage() {
        if (maxImageCounter > 10) {
            maxImageCounter = 0;
            blueprintPreviewFuture = null;
            return new class_1011(96, 96, true);
        }
        if (blueprintPreviewFuture != null) {
            if (blueprintPreviewFuture.isDone()) {
                class_1011 nativeImage = blueprintPreviewFuture.join();
                blueprintPreviewFuture = null;
                return nativeImage;
            }
            ++maxImageCounter;
            return null;
        }
        if (currentClipboard.blockRegion().count() < 0x1000000 && !currentClipboard.blockRegion().isEmpty()) {
            blueprintPreview.render(960, false, false);
            blueprintPreviewFuture = blueprintPreview.toNativeImage(96, true);
            return null;
        }
        return new class_1011(96, 96, true);
    }

    static {
        schematicPath = SchematicLoader.getDefaultSchematicDir();
    }
}

