/*
 * Decompiled with CFR 0.152.
 */
package com.knightgost.politechat;

import com.knightgost.politechat.PoliteChat;
import java.util.Arrays;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class PoliteChatCommand
implements CommandExecutor {
    private final PoliteChat plugin;

    public PoliteChatCommand(PoliteChat plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            sender.sendMessage("PoliteChat Plugin Commands:");
            sender.sendMessage("\u00a7e/politechat reload \u00a77- Reload config");
            sender.sendMessage("\u00a7e/politechat add <badword> <niceword> \u00a77- Add new replacement");
            sender.sendMessage("\u00a7e/politechat remove <badword> \u00a77- Remove replacement");
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "reload": {
                this.plugin.reloadPluginConfig();
                sender.sendMessage("\u00a7a\u2705 PoliteChat config.yml reloaded successfully!");
                this.plugin.getLogger().info("Config reloaded by " + sender.getName());
                break;
            }
            case "add": {
                if (args.length < 3) {
                    sender.sendMessage("\u00a7cUsage: /politechat add <badword> <niceword>");
                    return true;
                }
                String removeWord = args[1].toLowerCase();
                String niceWord = String.join((CharSequence)" ", Arrays.copyOfRange(args, 2, args.length));
                this.plugin.getConfig().set("words." + removeWord, (Object)niceWord);
                this.plugin.saveConfig();
                this.plugin.loadWordReplacer();
                sender.sendMessage("\u00a7aAdded replacement: \u00a7e" + removeWord + " \u00a7f\u2192 \u00a7b" + niceWord);
                break;
            }
            case "remove": {
                if (args.length != 2) {
                    sender.sendMessage("\u00a7cUsage: /politechat remove <badword>");
                    return true;
                }
                String removeWord = args[1].toLowerCase();
                if (this.plugin.getConfig().contains("words." + removeWord)) {
                    this.plugin.getConfig().set("words." + removeWord, null);
                    this.plugin.saveConfig();
                    this.plugin.loadWordReplacer();
                    sender.sendMessage("\u00a7aRemoved replacement for: \u00a7e" + removeWord);
                    break;
                }
                sender.sendMessage("\u00a7cWord not found in replacements: \u00a7e" + removeWord);
                break;
            }
            default: {
                sender.sendMessage("\u00a7cUnknown subcommand. Use /politechat reload | add | remove");
            }
        }
        return true;
    }
}

