/*
 * Decompiled with CFR 0.152.
 */
package com.knightgost.politechat;

import com.knightgost.politechat.PoliteChat;
import java.util.HashMap;
import java.util.Map;

public class WordReplacer {
    private final Map<String, String> replacements = new HashMap<String, String>();

    public WordReplacer(PoliteChat plugin) {
        this.loadConfig(plugin);
    }

    private void loadConfig(PoliteChat plugin) {
        if (plugin.getConfig().getBoolean("enabled", true) && plugin.getConfig().contains("words")) {
            for (String badWord : plugin.getConfig().getConfigurationSection("words").getKeys(false)) {
                String goodWord = plugin.getConfig().getString("words." + badWord, badWord);
                this.replacements.put(badWord.toLowerCase(), goodWord);
            }
        }
    }

    public String replaceBadWords(String message) {
        String result = message;
        for (Map.Entry<String, String> entry : this.replacements.entrySet()) {
            String bad = entry.getKey();
            String good = entry.getValue();
            result = result.replaceAll("(?i)\\b" + bad + "\\b", good);
        }
        return result;
    }
}

