/*
 * Decompiled with CFR 0.152.
 */
package de.arvitus.dragonegggame;

import com.flowpowered.math.vector.Vector3d;
import com.technicjelle.BMUtils.BMCopy;
import de.arvitus.dragonegggame.DragonEggGame;
import de.arvitus.dragonegggame.api.DragonEggAPI;
import de.arvitus.dragonegggame.config.Config;
import de.arvitus.dragonegggame.config.Data;
import de.bluecolored.bluemap.api.BlueMapAPI;
import de.bluecolored.bluemap.api.markers.ExtrudeMarker;
import de.bluecolored.bluemap.api.markers.Marker;
import de.bluecolored.bluemap.api.markers.MarkerSet;
import de.bluecolored.bluemap.api.markers.POIMarker;
import de.bluecolored.bluemap.api.math.Color;
import de.bluecolored.bluemap.api.math.Shape;
import java.io.IOException;
import java.util.Map;
import net.minecraft.class_2338;

class BlueMapIntegration {
    private static final MarkerSet MARKER_SET = new MarkerSet("dragonegggame", true, false);
    private static final ExtrudeMarker AREA_MARKER = ((ExtrudeMarker.Builder)ExtrudeMarker.builder().label("dragonegggame")).shape(Shape.createCircle((double)0.0, (double)0.0, (double)0.0, (int)3), 0.0f, 0.0f).lineWidth(0).build();
    private static final POIMarker POINT_MARKER = ((POIMarker.Builder)((POIMarker.Builder)POIMarker.builder().label("dragonegggame")).position(new Vector3d())).styleClasses(new String[]{"dragonegggame-poi-marker"}).build();
    private static Config config;
    private static Data data;

    BlueMapIntegration() {
    }

    public static void init() {
        DragonEggAPI.onUpdate(BlueMapIntegration::onUpdate);
        BlueMapAPI.onEnable(api -> {
            try {
                BMCopy.jarResourceToWebApp(api, BlueMapIntegration.class.getClassLoader(), "assets/style.css", "dragonegggame.css", true);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private static void onUpdate(Data data) {
        if (DragonEggGame.CONFIG != config) {
            MARKER_SET.setLabel(DragonEggGame.CONFIG.markerName);
            AREA_MARKER.setLabel(DragonEggGame.CONFIG.markerName);
            AREA_MARKER.setDetail(DragonEggGame.CONFIG.areaMarkerDescription);
            AREA_MARKER.setFillColor(new Color(0x5F000000 | DragonEggGame.CONFIG.markerColor));
            POINT_MARKER.setLabel(DragonEggGame.CONFIG.markerName);
            POINT_MARKER.setDetail(DragonEggGame.CONFIG.pointMarkerDescription);
            POINT_MARKER.setIcon(DragonEggGame.CONFIG.pointMarkerIcon, 24, 24);
            config = DragonEggGame.CONFIG;
        }
        BlueMapIntegration.data = data;
        BlueMapAPI.onEnable(BlueMapIntegration::updateBluemap);
    }

    private static void updateBluemap(BlueMapAPI api) {
        try {
            BlueMapAPI.unregisterListener(BlueMapIntegration::updateBluemap);
            Config.VisibilityType visibility = DragonEggGame.CONFIG.getVisibility(BlueMapIntegration.data.type);
            switch (visibility) {
                case HIDDEN: {
                    api.getMaps().forEach(map -> map.getMarkerSets().remove("dragon_egg"));
                    return;
                }
                case EXACT: {
                    POINT_MARKER.setPosition(data.getPosition().method_10216(), data.getPosition().method_10214(), data.getPosition().method_10215());
                    MARKER_SET.put("dragon_egg", (Marker)POINT_MARKER);
                    break;
                }
                case RANDOMIZED: {
                    class_2338 rPos = data.getRandomizedPosition();
                    AREA_MARKER.setShape(Shape.createCircle((double)rPos.method_10263(), (double)rPos.method_10260(), (double)DragonEggGame.CONFIG.searchRadius, (int)36), (float)rPos.method_10264() - DragonEggGame.CONFIG.searchRadius, (float)rPos.method_10264() + DragonEggGame.CONFIG.searchRadius);
                    AREA_MARKER.setPosition(new Vector3d((float)rPos.method_10263(), (float)rPos.method_10264(), (float)rPos.method_10260()));
                    MARKER_SET.put("dragon_egg", (Marker)AREA_MARKER);
                }
            }
            api.getWorld((Object)BlueMapIntegration.data.world).ifPresent(world -> api.getMaps().forEach(map -> {
                Map markerSets = map.getMarkerSets();
                if (map.getWorld().equals(world)) {
                    markerSets.put("dragon_egg", MARKER_SET);
                } else {
                    markerSets.remove("dragon_egg");
                }
            }));
        }
        catch (Exception e) {
            DragonEggGame.LOGGER.error("Error during bluemap update", (Throwable)e);
        }
    }
}

