/*
 * Decompiled with CFR 0.152.
 */
package de.arvitus.dragonegggame.api;

import de.arvitus.dragonegggame.DragonEggGame;
import de.arvitus.dragonegggame.Events;
import de.arvitus.dragonegggame.config.Config;
import de.arvitus.dragonegggame.config.Data;
import de.arvitus.dragonegggame.utils.ScheduledEvent;
import de.arvitus.dragonegggame.utils.Utils;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1540;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DragonEggAPI {
    private static final LinkedHashSet<Consumer<@NotNull Data>> onUpdateConsumers = new LinkedHashSet();
    private static final List<DeferredUpdate> deferredUpdates = new ArrayList<DeferredUpdate>();
    @Nullable
    private static Data data;

    public static void init() {
        Data oldData = data;
        DragonEggAPI.load_data();
        if (Objects.equals(oldData, data)) {
            return;
        }
        DragonEggAPI.dispatchUpdate();
    }

    private static void load_data() {
        data = Data.load();
        if (DragonEggGame.server != null) {
            DragonEggAPI.data.world = DragonEggGame.server.method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_60654((String)DragonEggAPI.data.worldId)));
            if (DragonEggAPI.data.world == null) {
                DragonEggGame.LOGGER.warn("Could not find world with id '{}'", (Object)DragonEggAPI.data.worldId);
            }
        }
    }

    public static synchronized void onUpdate(Consumer<@NotNull Data> consumer) {
        onUpdateConsumers.add(consumer);
        if (data != null) {
            consumer.accept(data);
        }
    }

    public static synchronized boolean unregisterListener(Consumer<@NotNull Data> consumer) {
        return onUpdateConsumers.remove(consumer);
    }

    private static void dispatchUpdate() {
        if (data != null) {
            ArrayList<DeferredUpdate> updatesToProcess = new ArrayList<DeferredUpdate>(deferredUpdates);
            deferredUpdates.clear();
            for (DeferredUpdate deferredUpdate : updatesToProcess) {
                DragonEggAPI.updatePosition(deferredUpdate.type, deferredUpdate.pos, deferredUpdate.world, deferredUpdate.entity);
            }
            for (Consumer consumer : new ArrayList<Consumer<Data>>(onUpdateConsumers)) {
                try {
                    consumer.accept(data);
                }
                catch (Exception e) {
                    DragonEggGame.LOGGER.warn("Error while dispatching update to listener {}: {}", (Object)consumer, (Object)e.getStackTrace());
                }
            }
        } else {
            DragonEggGame.LOGGER.warn("API is not ready, data is missing");
        }
    }

    public static void clearPosition() {
        data = new Data();
        data.save();
        DragonEggAPI.dispatchUpdate();
    }

    public static void updatePosition(@NotNull class_1297 entity) {
        DragonEggAPI.updatePosition(DragonEggAPI.getPositionType(entity), entity.method_73189(), entity.method_73183(), entity);
    }

    public static void updatePosition(@NotNull class_2586 blockEntity) {
        DragonEggAPI.updatePosition(PositionType.INVENTORY, blockEntity.method_11016(), Objects.requireNonNull(blockEntity.method_10997()));
    }

    public static void updatePosition(@NotNull class_2338 pos, @NotNull class_1937 world) {
        DragonEggAPI.updatePosition(PositionType.BLOCK, pos, world);
    }

    public static void updatePosition(@NotNull PositionType type, @NotNull class_2338 pos, @NotNull class_1937 world) {
        DragonEggAPI.updatePosition(type, pos.method_46558(), world, null);
    }

    private static synchronized void updatePosition(@NotNull PositionType type, @NotNull class_243 pos, @NotNull class_1937 world, @Nullable class_1297 entity) {
        class_1937 oldWorld;
        class_3222 player;
        if (data == null) {
            DragonEggGame.LOGGER.warn("API not ready, deferring position update");
            deferredUpdates.add(new DeferredUpdate(type, pos, world, entity));
            return;
        }
        if (entity != null) {
            DragonEggAPI.trackEntity(entity);
        }
        if (type == DragonEggAPI.data.type && pos.method_1022(data.getPosition()) < 1.0E-5) {
            return;
        }
        DragonEggGame.devLogger("Updating Dragon Egg position to type: {}, pos: {}, world: {}, entity: {}", new Object[]{type, class_2338.method_49638((class_2374)pos).method_23854(), world.method_27983().method_29177(), entity});
        if (type != DragonEggAPI.data.type || entity != null && !Objects.equals(DragonEggAPI.data.entityUUID, entity.method_5667())) {
            long currentTime = Objects.requireNonNull(world.method_8503()).method_30002().method_8510();
            long deltaTime = currentTime - DragonEggAPI.data.lastChange;
            PositionType positionType = DragonEggAPI.data.type;
            int n = 0;
            switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"BLOCK", "PLAYER", "ITEM", "ENTITY", "INVENTORY", "FALLING_BLOCK"}, (PositionType)positionType, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    DragonEggAPI.data.durations.block += deltaTime;
                    break;
                }
                case 1: {
                    DragonEggAPI.data.durations.player += deltaTime;
                    break;
                }
                case 2: {
                    DragonEggAPI.data.durations.item += deltaTime;
                    break;
                }
                case 3: {
                    DragonEggAPI.data.durations.entity += deltaTime;
                    break;
                }
                case 4: {
                    DragonEggAPI.data.durations.inventory += deltaTime;
                    break;
                }
                case 5: {
                    DragonEggAPI.data.durations.fallingBlock += deltaTime;
                }
                case -1: 
            }
            DragonEggAPI.data.lastChange = currentTime;
        }
        UUID uUID = DragonEggAPI.data.entityUUID = entity != null ? entity.method_5667() : null;
        if (entity instanceof class_3222 && !Objects.equals(DragonEggAPI.data.playerUUID, (player = (class_3222)entity).method_5667())) {
            DragonEggAPI.data.durations = new Data.Durations();
            DragonEggAPI.data.playerUUID = player.method_5667();
        }
        class_1937 class_19372 = oldWorld = DragonEggAPI.data.world != null ? DragonEggAPI.data.world : world;
        if (!oldWorld.equals(world) || !pos.method_24802((class_2374)data.getRandomizedPosition().method_46558(), (double)DragonEggGame.CONFIG.searchRadius)) {
            data.clearRandomizedPosition();
        }
        DragonEggAPI.data.type = type;
        DragonEggAPI.data.world = world;
        DragonEggAPI.data.worldId = world.method_27983().method_29177().toString();
        data.setPosition(pos);
        data.save();
        DragonEggAPI.dispatchUpdate();
    }

    private static synchronized void trackEntity(class_1297 entity) {
        if (DragonEggGame.CONFIG.getVisibility(DragonEggAPI.getPositionType(entity)) == Config.VisibilityType.EXACT) {
            entity.method_5834(true);
        }
        Events.SCHEDULED_ACTIONS.put(entity.method_5667(), new ScheduledEvent(100L, server -> Optional.ofNullable(DragonEggAPI.getData()).ifPresent(data -> {
            if (entity.method_31481()) {
                return;
            }
            entity.method_5834(false);
            if (!Utils.hasDragonEgg(entity)) {
                return;
            }
            DragonEggAPI.updatePosition(entity);
        })));
    }

    @Nullable
    public static Data getData() {
        return data;
    }

    public static PositionType getPositionType(@NotNull class_1297 entity) {
        class_1297 class_12972 = entity;
        Objects.requireNonNull(class_12972);
        class_1297 class_12973 = class_12972;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_1542.class, class_1540.class, class_1657.class}, (Object)class_12973, n)) {
            case 0 -> {
                class_1542 ignored = (class_1542)class_12973;
                yield PositionType.ITEM;
            }
            case 1 -> {
                class_1540 ignored = (class_1540)class_12973;
                yield PositionType.FALLING_BLOCK;
            }
            case 2 -> {
                class_1657 ignored = (class_1657)class_12973;
                yield PositionType.PLAYER;
            }
            default -> PositionType.ENTITY;
        };
    }

    private record DeferredUpdate(PositionType type, class_243 pos, class_1937 world, class_1297 entity) {
    }

    public static enum PositionType {
        BLOCK,
        ITEM,
        FALLING_BLOCK,
        INVENTORY,
        ENTITY,
        PLAYER;

    }
}

