/*
 * Decompiled with CFR 0.152.
 */
package de.arvitus.dragonegggame.api;

import de.arvitus.dragonegggame.api.Event;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_2960;

public abstract class EventsApi {
    private static final Map<class_2960, LinkedHashSet<Consumer<Event<?>>>> eventListeners = new HashMap();
    private static final class_2960 ANY = class_2960.method_60655((String)"events", (String)"any");

    public static void listen(Consumer<Event<?>> listener) {
        EventsApi.listen(ANY, listener);
    }

    public static synchronized void listen(class_2960 eventId, Consumer<Event<?>> listener) {
        eventListeners.computeIfAbsent(eventId, k -> new LinkedHashSet()).add(listener);
    }

    public static void removeListener(Consumer<Event<?>> listener) {
        EventsApi.removeListener(ANY, listener);
    }

    public static synchronized void removeListener(class_2960 eventId, Consumer<Event<?>> listener) {
        if (eventListeners.containsKey(eventId)) {
            eventListeners.get(eventId).remove(listener);
        }
    }

    public static boolean hasListeners(class_2960 eventId) {
        return eventListeners.containsKey(eventId) && !eventListeners.get(eventId).isEmpty();
    }

    public static synchronized boolean emit(class_2960 eventId, Event<?> event) throws Exception {
        ArrayList<Exception> thrownExceptions = new ArrayList<Exception>(0);
        for (Consumer listener : eventListeners.getOrDefault(eventId, new LinkedHashSet())) {
            try {
                listener.accept(event);
            }
            catch (Exception e) {
                thrownExceptions.add(e);
            }
        }
        if (eventId != ANY) {
            try {
                EventsApi.emit(ANY, event);
            }
            catch (Exception e) {
                thrownExceptions.add(e);
            }
        }
        return EventsApi.throwAsOne(thrownExceptions);
    }

    private static boolean throwAsOne(List<Exception> exceptions) throws Exception {
        if (exceptions.isEmpty()) {
            return true;
        }
        Exception e = exceptions.getFirst();
        for (int i = 1; i < exceptions.size(); ++i) {
            e.addSuppressed(exceptions.get(i));
        }
        throw e;
    }
}

