/*
 * Decompiled with CFR 0.152.
 */
package de.arvitus.dragonegggame.config;

import de.arvitus.dragonegggame.DragonEggGame;
import de.arvitus.dragonegggame.config.CommandTemplate;
import de.arvitus.dragonegggame.config.Condition;
import de.arvitus.dragonegggame.shadow.org.spongepowered.configurate.ConfigurationNode;
import de.arvitus.dragonegggame.shadow.org.spongepowered.configurate.objectmapping.ConfigSerializable;
import de.arvitus.dragonegggame.shadow.org.spongepowered.configurate.serialize.SerializationException;
import de.arvitus.dragonegggame.shadow.org.spongepowered.configurate.serialize.TypeSerializer;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_2168;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.NotNull;

@ConfigSerializable
public record Action(@Nullable String trigger, @Nullable Condition condition, @Nullable List<Action> actions, @Nullable CommandTemplate command) {
    public Action(@NotNull String commandTemplate) {
        this(null, null, null, new CommandTemplate(commandTemplate));
    }

    public Action(@NotNull String commandTemplate, @Nullable String condition) {
        this(null, condition != null ? new Condition(condition) : null, null, new CommandTemplate(commandTemplate));
    }

    public boolean checkCondition(@NotNull Map<String, Double> expressionVariables) {
        return this.condition == null || this.condition.evaluate(expressionVariables) != 0.0;
    }

    public void executeSafe(@NotNull class_2168 commandSource, @NotNull Map<String, Double> expressionVariables, @NotNull Map<String, Supplier<String>> localPlaceholders) {
        if (!this.checkCondition(expressionVariables)) {
            return;
        }
        try {
            this.execute(commandSource, expressionVariables, localPlaceholders);
        }
        catch (Exception e) {
            DragonEggGame.LOGGER.info("Error invoking action: {}", (Object)e.getMessage());
        }
    }

    public void execute(@NotNull class_2168 commandSource, @NotNull Map<String, Double> expressionVariables, @NotNull Map<String, Supplier<String>> localPlaceholders) {
        if (this.command != null) {
            String c = this.command.getCommand(expressionVariables, localPlaceholders);
            DragonEggGame.devLogger("Executing command: {}", c);
            commandSource.method_9211().method_3734().method_44252(commandSource, c);
        }
        if (this.actions != null) {
            for (Action action : this.actions) {
                action.executeSafe(commandSource, expressionVariables, localPlaceholders);
            }
        }
    }

    public static class Serializer
    implements TypeSerializer<Action> {
        public static final Serializer INSTANCE = new Serializer();

        private Serializer() {
        }

        @Override
        public Action deserialize(@NotNull Type type, ConfigurationNode node) throws SerializationException {
            String command = node.getString();
            if (command != null) {
                return new Action(command);
            }
            String trigger = node.node("trigger").getString();
            Condition condition = node.node("condition").get(Condition.class);
            List<Action> actions = node.node("actions").getList(Action.class);
            CommandTemplate commandTemplate = node.node("command").get(CommandTemplate.class);
            return new Action(trigger, condition, actions, commandTemplate);
        }

        @Override
        public void serialize(@NotNull Type type, @Nullable Action obj, @NotNull ConfigurationNode node) throws SerializationException {
            if (obj == null) {
                node.raw(null);
                return;
            }
            if (obj.trigger == null && obj.condition == null && obj.actions == null && obj.command != null) {
                node.set(obj.command.value);
                return;
            }
            if (obj.trigger != null) {
                node.node("trigger").set(obj.trigger);
            }
            if (obj.condition != null && !obj.condition.isEmpty()) {
                node.node("condition").set(obj.condition);
            }
            if (obj.actions != null) {
                node.node("actions").setList(Action.class, obj.actions);
            }
            if (obj.command != null) {
                node.node("command").set(obj.command.value);
            }
        }
    }
}

