/*
 * Decompiled with CFR 0.152.
 */
package de.arvitus.dragonegggame.config;

import de.arvitus.dragonegggame.DragonEggGame;
import de.arvitus.dragonegggame.api.DragonEggAPI;
import de.arvitus.dragonegggame.config.Action;
import de.arvitus.dragonegggame.config.CommandTemplate;
import de.arvitus.dragonegggame.config.Condition;
import de.arvitus.dragonegggame.config.MessageString;
import de.arvitus.dragonegggame.shadow.org.spongepowered.configurate.CommentedConfigurationNode;
import de.arvitus.dragonegggame.shadow.org.spongepowered.configurate.hocon.HoconConfigurationLoader;
import de.arvitus.dragonegggame.shadow.org.spongepowered.configurate.objectmapping.ConfigSerializable;
import de.arvitus.dragonegggame.shadow.org.spongepowered.configurate.objectmapping.meta.Comment;
import eu.pb4.placeholders.api.parsers.NodeParser;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@ConfigSerializable
public class Config {
    public static final Map<DragonEggAPI.PositionType, VisibilityType> defaultVisibility = Map.of(DragonEggAPI.PositionType.BLOCK, VisibilityType.RANDOMIZED, DragonEggAPI.PositionType.ITEM, VisibilityType.EXACT, DragonEggAPI.PositionType.FALLING_BLOCK, VisibilityType.EXACT, DragonEggAPI.PositionType.INVENTORY, VisibilityType.EXACT, DragonEggAPI.PositionType.ENTITY, VisibilityType.EXACT, DragonEggAPI.PositionType.PLAYER, VisibilityType.HIDDEN);
    private static final Path PATH = DragonEggGame.CONFIG_DIR.resolve("config.conf");
    private static final HoconConfigurationLoader LOADER = ((HoconConfigurationLoader.Builder)((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().path(PATH)).prettyPrinting(true).defaultOptions(opts -> opts.serializers(build -> build.register(MessageString.class, new MessageString.Serializer(Messages.PARSER)).register(Action.class, Action.Serializer.INSTANCE).register(CommandTemplate.class, CommandTemplate.Serializer.INSTANCE).register(Condition.class, Condition.Serializer.INSTANCE)))).build();
    @Comment(value="The radius that is used to randomize the dragon egg position.\nDefault: 25")
    public float searchRadius = 25.0f;
    @Comment(value="The name of the BlueMap marker")
    public String markerName = "Dragon Egg";
    @Comment(value="The description of the BlueMap area marker")
    public String areaMarkerDescription = "The dragon egg is somewhere in this area.";
    @Comment(value="The description of the BlueMap point marker")
    public String pointMarkerDescription = "Come and get it!";
    @Comment(value="The URL of the BlueMap point marker icon")
    public String pointMarkerIcon = "https://minecraft.wiki/images/thumb/Dragon_Egg_JE4.png/150px-Dragon_Egg_JE4.png";
    @Comment(value="The color of the BlueMap marker as a decimal value.\nDefault: 2818132 (Purple)")
    public int markerColor = 2818132;
    @Comment(value="Messages used throughout the mod")
    public Messages messages = new Messages();
    @Comment(value="The distance in blocks around the Dragon Egg where players count as 'nearby'")
    public int nearbyRange = 64;
    @Comment(value="Actions that are executed on certain triggers.\nYou can specify different actions and also specify a condition that must be met for the action to run.\n\nAvailable triggers:\n    - 'deg:block' - When the egg is placed as a block.\n    - 'deg:item' - When the egg becomes an item (e.g. is dropped).\n    - 'deg:inventory' - When the egg is placed in a block inventory (e.g. chest).\n    - 'deg:entity' - When the egg is placed in an entity inventory (e.g. item frame, chest boat)\n    - 'deg:player' - When the egg enters a players inventory.\n    - 'deg:falling_block' - When the egg becomes a falling block entity.\n    - 'deg:second' - Every second.\nNOTE: All entities (items, falling blocks, players, etc.) will trigger multiple times if they move while holding the egg.\n\nThe following placeholders are available in commands and use the format {{<placeholder>}}:\n    - 'bearer' - The name of the bearer.\n    - 'bearer_id' - The uuid of the bearer.\n    - 'nearby' - Shortcut for '@a[predicate=deg:is_nearby]' (see below).\n\nThe Mod also provides two predicates that can be used in commands (also in-game):\n    - 'deg:is_bearer' - Matches the current bearer of the egg.\n    - 'deg:is_nearby' - Matches players within the reward range of the egg.\n\nAdditionally, you can use ${<expression>} to calculate a mathematical expression.\nFor information on available functions and operators, see: https://www.objecthunter.net/exp4j/\nIMPORTANT: Make sure the result is a format that is compatible with the format expected by the command.\n           Most commands expect integer values, so make sure the calculation results in an integer.\n           The functions 'round(a, b)', 'floor(a)', and 'ceil(a)' can help with that.\nAvailable variables:\n    - (int) 'bearerTime' - The time in seconds since the last bearer change.\n    - (int) 'blockTime' - The time in seconds since the egg was last placed.\n    - (int) 'totalBlockTime' - The total time in seconds the egg has been placed, since the last bearer change.\n    - (int) 'playerTime' - The time in seconds since the egg has last entered the bearers inventory.\n    - (int) 'totalPlayerTime' - The total time in seconds the egg has been in the bearers inventory, since the last bearer change.\n    - (int) 'itemTime' - The time in seconds since the egg became an item entity.\n    - (int) 'totalItemTime' - The total time in seconds the egg has been an item entity, since the last bearer change.\n    - (int) 'entityTime' - The time in seconds since the egg was last placed in an entity inventory (not player).\n    - (int) 'totalEntityTime' - The total time in seconds the egg has been in an entity inventory (not player), since the last bearer change.\n    - (int) 'invTime' - The time in seconds since the egg was last placed in a block inventory.\n    - (int) 'totalInvTime' - The total time in seconds the egg has been in a block inventory, since the last bearer change.\n    - (int) 'fallingTime' - The time in seconds since the egg became a falling block entity.\n    - (int) 'totalFallingTime' - The total time in seconds the egg has been a falling block entity, since the last bearer change.\n    - (double) 'x' - The X coordinate of the egg, at the center of the block.\n    - (double) 'y' - The Y coordinate of the egg, at the center of the block.\n    - (double) 'z' - The Z coordinate of the egg, at the center of the block.\n    - (int) 'randX' - The randomized X block coordinate of the egg.\n    - (int) 'randY' - The randomized Y block coordinate of the egg.\n    - (int) 'randZ' - The randomized Z block coordinate of the egg.\nAdditional functions:\n    - rnd(a) - returns a pseudo random number between 0 and a (0 <= rnd(a) < a)\n    - min(a, b) - returns the smaller of a and b\n    - max(a, b) - returns the larger of a and b\n    - round(a, b) - rounds a to b decimal places\nAdditional operators:\n    - '==' - equals (returns 1 if true and 0 otherwise)\n    - '!=' - not equals (returns 1 if true and 0 otherwise)\n    - '<' - less than (returns 1 if true and 0 otherwise)\n    - '>' - greater than (returns 1 if true and 0 otherwise)\n    - '<=' - less than or equal (returns 1 if true and 0 otherwise)\n    - '>=' - greater than or equal (returns 1 if true and 0 otherwise)\n    - '&&' - logical and (returns 0 if at least one value is 0 and 1 otherwise)\n    - '||' - logical or (returns 0 if both values are 0 and 1 otherwise)\n\nFormat:\n[ // a list of Actions\n  <Action1>, // see below for Action object format\n  <Action2>,\n  ...\n]\n\nAction Object:\n{\n  \"trigger\": \"<trigger>\", // the trigger that activates this Action (required at top level, otherwise ignored)\n  \"condition\": \"<expression>\", // the condition that must be met (<expression> != 0) for the Action to run (optional)\n  \"actions\": [ // a list of Actions to execute (optional)\n    \"<command>\", // shorthand for an Action with only a command,\n    <Action2>, // an Action object\n    ...\n  ],\n  \"command\": \"<command>\" // a minecraft command to execute (optional)\n  // you can use any valid Minecraft command here, including commands added by other mods\n}\n\nExample:\n[\n  {\n    \"trigger\": \"deg:block\",\n    \"condition\": \"blockTime == 0\", // <-- only run if it was not already a block\n    \"actions\": [\n      \"tellraw @a {\"text\":\"The Dragon Egg has been deployed. Go find it!\", \"color\":\"yellow\"}\",\n      {\n        \"condition\": \"totalBlockTime == 0\", // <-- only run once when the egg is placed the first time\n        \"command\": \"effect give {{bearer_id}} minecraft:strength 300 1\"\n      } //                            ^-- will insert the uuid of the bearer\n    ]\n  },\n  {\n    \"trigger\": \"deg:second\",\n    \"condition\": \"blockTime == 0 && bearerTime % 30 == 0\", // <-- runs every 30 seconds if the egg is not placed\n    \"actions\": [\n      {\n        \"condition\": \"bearerTime == 0\", // <-- When the bearer changed (someone stole the egg)\n        \"command\": \"tellraw {{bearer}} {\"text\":\"The Dragon Egg needs to be placed down in the next 10 Minutes!\", \"color\":\"red\"}\"\n      }, //                     ^-- will insert the name of the bearer\n      {\n        \"condition\": \"bearerTime == 300\", // <-- 5 minutes after the bearer changed\n        \"command\": \"tellraw {{bearer}} {\"text\":\"The Dragon Egg needs to be placed down in the next 5 Minutes!\", \"color\":\"red\"}\"\n      }, //                     ^-- will insert the name of the bearer\n      {\n        \"condition\": \"bearerTime >= 600\", // <-- after 10 minutes and every 30 seconds thereafter\n        \"actions\": [\n          \"tellraw {{bearer}} {\"text\":\"The Dragon Egg needs to be placed down!\", \"color\":\"red\"}\",\n          //           ^-- will insert the name of the bearer\n          \"effect give {{bearer_id}} minecraft:poison 5 ${floor(bearerTime / 400)}\",\n          //                 ^-- will insert the uuid of the bearer\n        ]\n      }\n    ]\n  }\n]")
    public List<Action> actions = List.of();
    @Comment(value="The visibility of the dragon egg for each position type.\nDefault: {\n   BLOCK=RANDOMIZED, // placed as Block\n   ITEM=EXACT, // item entity\n   FALLING_BLOCK=EXACT, // falling block entity\n   INVENTORY=EXACT, // block inventory\n   ENTITY=EXACT, // entity inventory\n   PLAYER=HIDDEN, // player inventory\n}")
    private Map<DragonEggAPI.PositionType, VisibilityType> visibility = defaultVisibility;

    public static Config loadAndUpdateOrCreate() {
        Config config = new Config();
        if (!PATH.toFile().isFile()) {
            config.save();
            return config;
        }
        try {
            CommentedConfigurationNode node = (CommentedConfigurationNode)LOADER.load();
            boolean update = false;
            if (!node.hasChild("actions")) {
                ((CommentedConfigurationNode)node.node(new Object[]{"visibility"})).removeChild("NONE");
                update = true;
            }
            config = node.get(Config.class);
            if (update) {
                DragonEggGame.LOGGER.info("Detected old config file format, updating...");
                try {
                    Objects.requireNonNull(config).save();
                    DragonEggGame.LOGGER.info("Config file was updated to current format");
                }
                catch (Exception e) {
                    DragonEggGame.LOGGER.warn("Failed to update config file to new format", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            if (DragonEggGame.CONFIG != null) {
                DragonEggGame.LOGGER.warn("Failed to load config, using previous value instead", (Throwable)e);
                config = DragonEggGame.CONFIG;
            }
            DragonEggGame.LOGGER.warn("Failed to load config, using default config instead", (Throwable)e);
        }
        return config;
    }

    public boolean save() {
        CommentedConfigurationNode node = (CommentedConfigurationNode)LOADER.createNode();
        try {
            node.set(this);
            LOADER.save(node);
        }
        catch (Exception e) {
            DragonEggGame.LOGGER.warn("Failed to save config to disk", (Throwable)e);
            return false;
        }
        return true;
    }

    public VisibilityType getVisibility(@Nullable DragonEggAPI.PositionType type) {
        return this.visibility.getOrDefault((Object)type, defaultVisibility.getOrDefault((Object)type, VisibilityType.HIDDEN));
    }

    @ConfigSerializable
    public static class Messages {
        private static final NodeParser PARSER = NodeParser.builder().globalPlaceholders().quickText().staticPreParsing().build();
        @Comment(value="The message that is displayed when using '/dragon_egg bearer' and the visibility of the current position type is 'EXACT' (see visibility)")
        public MessageString bearerExact = new MessageString(PARSER, "<yellow>The %deg:item% is currently held by <gold>%deg:bearer%</> and was last seen at <gold>%deg:pos%</>.");
        @Comment(value="The message that is displayed when using '/dragon_egg bearer' and the visibility of the current position type is 'RANDOMIZED' (see visibility)")
        public MessageString bearerRandomized = new MessageString(PARSER, "<yellow>The %deg:item% is currently held by <gold>%deg:bearer%</> and was last seen around <gold>%deg:pos%</>.");
        @Comment(value="The message that is displayed when using '/dragon_egg bearer' and the visibility of the current position type is 'HIDDEN' (see visibility)")
        public MessageString bearerHidden = new MessageString(PARSER, "<yellow>The %deg:item% is currently held by <gold>%deg:bearer%</>.");
        @Comment(value="The message that is displayed when using '/dragon_egg bearer' but there is no bearer")
        public MessageString noBearer = new MessageString(PARSER, "<yellow>No one has snatched the %deg:item% yet.");
        @Comment(value="The message that is displayed when using '/dragon_egg bearer' but there is an error")
        public MessageString bearerError = new MessageString(PARSER, "<red>Currently not available.");
        @Comment(value="The dragon egg bearer has changed")
        public MessageString bearerChanged = new MessageString(PARSER, "<yellow><gold>%deg:bearer%</> now has the %deg:item%!");
        @Comment(value="The message that is displayed when using '/dragon_egg info'")
        public MessageString info = new MessageString(PARSER, "\n\n\n<aqua><bold>The Dragon Egg Server Game</*>\n<gray>----------------------------</*>\n<yellow>Whoever has the %deg:item%, must place the %deg:item% <gold><hover show_text \"    When arriving at the base, you should quickly know where to look     and the time needed for the search should be appropriate.\">obvious</></> and <gold><hover show_text \"    You shouldn't have to destroy anything to get to the %deg:item%.\">accessible for everyone</></> in the own base. You can <gold><hover show_text \"    It's supposed to be fun for everybody, so please look out for another and fight fair.     (It's best if you don't fight at all!)\n    The defense should not go beyond your own base and lost items (e.g. because of death) must be returned.\">protect</></> it with traps and your own life, or put it in a huge vault, but it has to be <gold><hover show_text \"    When arriving at the base, you should quickly know where to look     and the time needed for the search should be appropriate.\">obvious</></> where the %deg:item% is. Everyone else now can steal the %deg:item% and has to place it in their base respectively.</*>\n<red><italic>You may only steal the egg, if the current egg bearer is online or if they have been offline for at least 3 days!".replace("  ", ""));
    }

    public static enum VisibilityType {
        RANDOMIZED,
        EXACT,
        HIDDEN;

    }
}

