/*
 * Decompiled with CFR 0.152.
 */
package de.arvitus.dragonegggame.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.SerializedName;
import de.arvitus.dragonegggame.DragonEggGame;
import de.arvitus.dragonegggame.api.DragonEggAPI;
import de.arvitus.dragonegggame.utils.Utils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3i;

public class Data {
    @Nullable
    public transient class_1937 world;
    @SerializedName(value="world")
    @NotNull
    public String worldId = "minecraft:overworld";
    @SerializedName(value="entity_uuid")
    @Nullable
    public UUID entityUUID;
    @SerializedName(value="player_uuid")
    @Nullable
    public UUID playerUUID;
    @SerializedName(value="last_change")
    public long lastChange = 0L;
    public Durations durations = new Durations();
    @Nullable
    public DragonEggAPI.PositionType type;
    @SerializedName(value="position")
    @Nullable
    private Vector3f _position;
    @SerializedName(value="randomized_position")
    @Nullable
    private Vector3i _randomizedPosition;

    public static Data load() {
        Data data = new Data();
        File dataFile = DragonEggGame.CONFIG_DIR.resolve("data.json").toFile();
        try (FileReader reader = new FileReader(dataFile);){
            data = (Data)new Gson().fromJson((Reader)reader, Data.class);
        }
        catch (FileNotFoundException ignored) {
            DragonEggGame.LOGGER.debug("data.json not found, using default values");
        }
        catch (JsonIOException | IOException e) {
            DragonEggGame.LOGGER.warn("could not load saved data, using default values");
        }
        catch (JsonSyntaxException e) {
            DragonEggGame.LOGGER.warn("saved data is invalid: {}, using default values", (Object)e.getMessage());
        }
        return data;
    }

    @NotNull
    public class_2338 getRandomizedPosition() {
        if (this._randomizedPosition == null) {
            class_2338 randPos = Utils.randomizePosition(this.getBlockPos(), DragonEggGame.CONFIG.searchRadius);
            this._randomizedPosition = new Vector3i(randPos.method_10263(), randPos.method_10264(), randPos.method_10260());
        }
        return new class_2338(this._randomizedPosition.x, this._randomizedPosition.y, this._randomizedPosition.z);
    }

    @NotNull
    public class_2338 getBlockPos() {
        return class_2338.method_49638((class_2374)this.getPosition());
    }

    @NotNull
    public class_243 getPosition() {
        return this._position == null ? class_243.field_1353 : new class_243(this._position);
    }

    public void setPosition(@NotNull class_243 position) {
        this._position = position.method_46409();
    }

    public void clearRandomizedPosition() {
        this._randomizedPosition = null;
    }

    public long getBearerTime(long currentTime) {
        return this.durations.block + this.durations.player + this.durations.item + this.durations.entity + this.durations.inventory + this.durations.fallingBlock + this.getContinuousTime(currentTime);
    }

    public long getContinuousTime(long currentTime) {
        return currentTime - this.lastChange;
    }

    public long getDuration(DragonEggAPI.PositionType type) {
        DragonEggAPI.PositionType positionType = type;
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"BLOCK", "PLAYER", "ITEM", "ENTITY", "INVENTORY", "FALLING_BLOCK"}, (DragonEggAPI.PositionType)positionType, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> this.durations.block;
            case 1 -> this.durations.player;
            case 2 -> this.durations.item;
            case 3 -> this.durations.entity;
            case 4 -> this.durations.inventory;
            case 5 -> this.durations.fallingBlock;
            case -1 -> 0L;
        };
    }

    public void save() {
        File dataFile = DragonEggGame.CONFIG_DIR.resolve("data.json").toFile();
        try (FileWriter writer = new FileWriter(dataFile);){
            new GsonBuilder().setPrettyPrinting().create().toJson((Object)this, (Appendable)writer);
        }
        catch (JsonIOException | IOException e) {
            DragonEggGame.LOGGER.warn("could not save data: {}", (Object)e.getMessage());
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof Data)) {
            return false;
        }
        Data data = (Data)o;
        return Objects.equals(this.worldId, data.worldId) && Objects.equals(this.entityUUID, data.entityUUID) && Objects.equals(this.playerUUID, data.playerUUID) && Objects.equals(this.durations, data.durations) && this.lastChange == data.lastChange && this.type == data.type && Objects.equals(this._position, data._position) && Objects.equals(this._randomizedPosition, data._randomizedPosition);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.worldId, this.entityUUID, this.playerUUID, this.durations, this.lastChange, this.type, this._position, this._randomizedPosition});
    }

    public static class Durations {
        public long block = 0L;
        public long player = 0L;
        public long item = 0L;
        public long entity = 0L;
        public long inventory = 0L;
        @SerializedName(value="falling_block")
        public long fallingBlock = 0L;

        public boolean equals(Object o) {
            if (!(o instanceof Durations)) {
                return false;
            }
            Durations that = (Durations)o;
            return this.block == that.block && this.player == that.player && this.item == that.item && this.entity == that.entity && this.inventory == that.inventory && this.fallingBlock == that.fallingBlock;
        }

        public int hashCode() {
            return Objects.hash(this.block, this.player, this.item, this.entity, this.inventory, this.fallingBlock);
        }
    }
}

