/*
 * Decompiled with CFR 0.152.
 */
package de.arvitus.dragonegggame.features;

import de.arvitus.dragonegggame.DragonEggGame;
import de.arvitus.dragonegggame.Events;
import de.arvitus.dragonegggame.api.APIUtils;
import de.arvitus.dragonegggame.api.DragonEggAPI;
import de.arvitus.dragonegggame.api.Event;
import de.arvitus.dragonegggame.api.EventsApi;
import de.arvitus.dragonegggame.config.Action;
import de.arvitus.dragonegggame.config.Data;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_2960;
import net.minecraft.server.MinecraftServer;

public class Actions {
    private static final Map<class_2960, HashSet<Consumer<Event<?>>>> registeredEventListeners = new HashMap();
    private static final Map<DragonEggAPI.PositionType, List<String>> positionTypeToTimeVariables = Map.of(DragonEggAPI.PositionType.BLOCK, List.of("blockTime", "totalBlockTime"), DragonEggAPI.PositionType.PLAYER, List.of("playerTime", "totalPlayerTime"), DragonEggAPI.PositionType.ITEM, List.of("itemTime", "totalItemTime"), DragonEggAPI.PositionType.ENTITY, List.of("entityTime", "totalEntityTime"), DragonEggAPI.PositionType.INVENTORY, List.of("invTime", "totalInvTime"), DragonEggAPI.PositionType.FALLING_BLOCK, List.of("fallingTime", "totalFallingTime"));
    private static final Map<String, Supplier<String>> placeholders = Map.of("bearer_id", () -> {
        Data data = DragonEggAPI.getData();
        return data != null && data.playerUUID != null ? data.playerUUID.toString() : "@a[predicate=deg:is_bearer]";
    }, "bearer", () -> APIUtils.getBearer().getString(), "nearby", () -> "@a[predicate=deg:is_nearby]");

    public static void register() {
        DragonEggGame.LOGGER.info("Registering event listeners for {}", (Object)"dragonegggame");
        for (Map.Entry<class_2960, HashSet<Consumer<Event<?>>>> entry : registeredEventListeners.entrySet()) {
            for (Consumer<Event<Object>> listener : entry.getValue()) {
                EventsApi.removeListener(entry.getKey(), listener);
            }
        }
        registeredEventListeners.clear();
        for (Action action : DragonEggGame.CONFIG.actions) {
            if (action.trigger() == null) {
                DragonEggGame.LOGGER.warn("Skipping event listener without trigger: {}", (Object)action);
                continue;
            }
            registeredEventListeners.computeIfAbsent(class_2960.method_60654((String)action.trigger()), k -> new HashSet()).add(event -> {
                if (DragonEggGame.server == null) {
                    return;
                }
                action.executeSafe(DragonEggGame.server.method_3739().method_9217(), event.expressionVariables, event.localPlaceholders);
            });
        }
        for (Map.Entry entry : registeredEventListeners.entrySet()) {
            for (Consumer<Event<Object>> listener : (HashSet)entry.getValue()) {
                EventsApi.listen((class_2960)entry.getKey(), listener);
            }
        }
    }

    public static void init() {
        Actions.register();
        DragonEggAPI.onUpdate(Actions::onUpdate);
    }

    private static void onUpdate(Data data) {
        if (data.type == null) {
            Events.TICK_ACTIONS.remove("actions_tick");
            return;
        }
        HashMap<String, Double> variables = new HashMap<String, Double>(Map.of("x", data.getPosition().field_1352, "y", data.getPosition().field_1351, "z", data.getPosition().field_1350, "randX", Double.valueOf(data.getRandomizedPosition().method_10263()), "randY", Double.valueOf(data.getRandomizedPosition().method_10264()), "randZ", Double.valueOf(data.getRandomizedPosition().method_10260())));
        Event<Object> event = new Event<Object>(variables, placeholders, null);
        Consumer<MinecraftServer> calculateVariables = server -> {
            long currentTime = server.method_30002().method_8510();
            variables.put("bearerTime", Math.floor((double)data.getBearerTime(currentTime) / 20.0));
            for (DragonEggAPI.PositionType type : DragonEggAPI.PositionType.values()) {
                List<String> value = positionTypeToTimeVariables.get((Object)type);
                if (type == data.type) {
                    long continuousTime = data.getContinuousTime(currentTime);
                    variables.put(value.getFirst(), Math.floor((double)continuousTime / 20.0));
                    variables.put(value.get(1), Math.floor((double)(data.getDuration(type) + continuousTime) / 20.0));
                    continue;
                }
                variables.put(value.getFirst(), 0.0);
                variables.put(value.get(1), Math.floor((double)data.getDuration(type) / 20.0));
            }
        };
        if (data.world != null) {
            calculateVariables.accept(data.world.method_8503());
        }
        Actions.emitEvent(data.type.name().toLowerCase(), event);
        Events.TICK_ACTIONS.put("actions_tick", (ticks, server) -> {
            if (ticks % 20 != 0) {
                return;
            }
            calculateVariables.accept((MinecraftServer)server);
            Actions.emitEvent("second", event);
        });
    }

    private static void emitEvent(String eventName, Event<?> event) {
        try {
            EventsApi.emit(class_2960.method_60655((String)"deg", (String)eventName), event);
        }
        catch (Exception e) {
            DragonEggGame.LOGGER.warn("Error during event handling: {}", (Object)e.getMessage());
        }
    }
}

