/*
 * Decompiled with CFR 0.152.
 */
package de.arvitus.dragonegggame.shadow.org.spongepowered.configurate.reference;

import de.arvitus.dragonegggame.shadow.org.spongepowered.configurate.reactive.Disposable;
import de.arvitus.dragonegggame.shadow.org.spongepowered.configurate.reactive.Processor;
import de.arvitus.dragonegggame.shadow.org.spongepowered.configurate.reactive.Subscriber;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.checkerframework.checker.nullness.qual.Nullable;

class DirectoryListenerRegistration
implements Subscriber<WatchEvent<?>> {
    private final Lock lock = new ReentrantLock();
    private final AtomicBoolean acceptingRegistrations = new AtomicBoolean(true);
    private final WatchKey key;
    private final ConcurrentMap<Path, Processor<WatchEvent<?>, WatchEvent<?>>> fileListeners = new ConcurrentHashMap();
    private final Executor executor;
    private final Processor<WatchEvent<?>, WatchEvent<?>> dirListeners;

    DirectoryListenerRegistration(WatchKey key, Executor executor) {
        this.key = Objects.requireNonNull(key, "key");
        this.executor = Objects.requireNonNull(executor, "executor");
        this.dirListeners = Processor.create(executor);
    }

    public WatchKey key() {
        return this.key;
    }

    @Override
    public void submit(WatchEvent<?> item) {
        if (!this.acceptingRegistrations.get()) {
            return;
        }
        Path file = (Path)item.context();
        @Nullable Processor fileListeners = this.fileListeners.computeIfPresent(file, (key, old) -> old.closeIfUnsubscribed() ? null : old);
        this.dirListeners.submit(item);
        if (fileListeners != null) {
            fileListeners.submit(item);
        }
    }

    @Override
    public void onClose() {
        this.lock.lock();
        try {
            try {
                this.dirListeners.onClose();
            }
            catch (Exception t) {
                this.dirListeners.onError(t);
            }
            this.fileListeners.forEach((k, v) -> {
                try {
                    v.onClose();
                }
                catch (Exception t) {
                    v.onError(t);
                }
            });
            this.fileListeners.clear();
            this.key.cancel();
        }
        finally {
            this.lock.unlock();
        }
    }

    public Disposable subscribe(Subscriber<WatchEvent<?>> subscriber) {
        if (!this.acceptingRegistrations.get()) {
            return () -> {};
        }
        this.lock.lock();
        try {
            Disposable disposable = this.dirListeners.subscribe(subscriber);
            return disposable;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Disposable subscribe(Path file, Subscriber<WatchEvent<?>> subscriber) {
        if (!this.acceptingRegistrations.get()) {
            return () -> {};
        }
        this.lock.lock();
        try {
            Disposable disposable = this.fileListeners.computeIfAbsent(file, f -> Processor.create(this.executor)).subscribe(subscriber);
            return disposable;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean hasSubscribers() {
        this.lock.lock();
        try {
            boolean bl = this.dirListeners.hasSubscribers() || !this.fileListeners.isEmpty();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DirectoryListenerRegistration)) {
            return false;
        }
        DirectoryListenerRegistration that = (DirectoryListenerRegistration)o;
        return this.key().equals(that.key()) && this.fileListeners.equals(that.fileListeners) && this.dirListeners.equals(that.dirListeners);
    }

    public int hashCode() {
        return Objects.hash(this.key(), this.fileListeners, this.dirListeners);
    }

    public boolean closeIfEmpty() {
        this.lock.lock();
        try {
            if (!this.hasSubscribers()) {
                this.onClose();
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.lock.unlock();
        }
        return false;
    }
}

