/*
 * Decompiled with CFR 0.152.
 */
package de.arvitus.dragonegggame;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.arvitus.dragonegggame.DragonEggGame;
import de.arvitus.dragonegggame.Perms;
import de.arvitus.dragonegggame.api.DragonEggAPI;
import de.arvitus.dragonegggame.config.Config;
import de.arvitus.dragonegggame.config.MessageString;
import de.arvitus.dragonegggame.files.Data;
import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.node.TextNode;
import java.net.URI;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.fabricmc.loader.api.metadata.Person;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;

public class Commands {
    public static void register() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"deg").requires(Permissions.require((String)Perms.ADMIN, (int)4))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(Permissions.require((String)Perms.RELOAD, (int)4))).executes(Commands::reload))).executes(context -> {
                FabricLoader.getInstance().getModContainer("dragonegggame").ifPresent(modContainer -> {
                    ModMetadata meta = modContainer.getMetadata();
                    ((class_2168)context.getSource()).method_9226(() -> class_2561.method_30163((String)String.format("%s v%s by %s", meta.getName(), meta.getVersion(), meta.getAuthors().stream().findFirst().isEmpty() ? "Unknown" : ((Person)meta.getAuthors().stream().findFirst().get()).getName())).method_27661().method_10862(class_2583.field_24360.method_10958((class_2558)new class_2558.class_10608(URI.create(meta.getContact().get("source").orElse("https://github.com/arvitus")))).method_10949((class_2568)new class_2568.class_10613(class_2561.method_30163((String)"Click to view source")))), false);
                });
                return 0;
            }));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"dragon_egg").requires(Permissions.require((String)"deg", (boolean)true))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"bearer").requires(Permissions.require((String)Perms.BEARER, (boolean)true))).executes(Commands::dragon_egg$bearer))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"info").requires(Permissions.require((String)Perms.INFO, (boolean)true))).executes(Commands::dragon_egg$info)));
        });
    }

    private static int reload(CommandContext<class_2168> context) {
        Config oldConfig = DragonEggGame.CONFIG;
        DragonEggGame.CONFIG = Config.loadOrCreate();
        if (DragonEggGame.CONFIG == oldConfig) {
            ((class_2168)context.getSource()).method_9213(class_2561.method_30163((String)"Failed to load config, using previous value instead. See console for more information."));
            return -1;
        }
        DragonEggAPI.init();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_30163((String)"Reloaded DragonEggGame config and data"), false);
        return 1;
    }

    private static int dragon_egg$bearer(CommandContext<class_2168> context) {
        MessageString message;
        class_2168 source = (class_2168)context.getSource();
        Data data = DragonEggAPI.getData();
        if (data == null) {
            source.method_9213(DragonEggGame.CONFIG.messages.bearerError.node.toText(PlaceholderContext.of((class_2168)source.method_9206(4))));
            return -1;
        }
        if (data.playerUUID == null) {
            message = DragonEggGame.CONFIG.messages.noBearer;
        } else {
            message = switch (DragonEggGame.CONFIG.getVisibility(data.type)) {
                default -> throw new MatchException(null, null);
                case Config.VisibilityType.EXACT -> DragonEggGame.CONFIG.messages.bearerExact;
                case Config.VisibilityType.RANDOMIZED -> DragonEggGame.CONFIG.messages.bearerRandomized;
                case Config.VisibilityType.HIDDEN -> DragonEggGame.CONFIG.messages.bearerHidden;
            };
        }
        TextNode node = message.node;
        source.method_9226(() -> node.toText(PlaceholderContext.of((class_2168)source.method_9206(4))), false);
        return 0;
    }

    private static int dragon_egg$info(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9226(() -> DragonEggGame.CONFIG.messages.info.node.toText(PlaceholderContext.of((class_2168)((class_2168)context.getSource()).method_9206(4))), false);
        return 0;
    }
}

