/*
 * Decompiled with CFR 0.152.
 */
package de.arvitus.dragonegggame;

import de.arvitus.dragonegggame.DragonEggGame;
import de.arvitus.dragonegggame.api.DragonEggAPI;
import de.arvitus.dragonegggame.files.Data;
import de.arvitus.dragonegggame.utils.ScheduledEvent;
import de.arvitus.dragonegggame.utils.Utils;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerBlockEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1540;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2621;
import net.minecraft.class_2624;
import net.minecraft.class_3738;
import net.minecraft.server.MinecraftServer;

public class Events {
    public static final LinkedHashMap<UUID, ScheduledEvent> SCHEDULED_ACTIONS = new LinkedHashMap();

    public static void register() {
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            DragonEggGame.server = server;
            DragonEggAPI.init();
        });
        ServerLifecycleEvents.SERVER_STOPPED.register(server -> Optional.ofNullable(DragonEggAPI.getData()).ifPresent(Data::save));
        ServerTickEvents.END_SERVER_TICK.register(server -> new LinkedHashMap<UUID, ScheduledEvent>(SCHEDULED_ACTIONS).forEach((key, value) -> {
            try {
                if (value.tryRun(server)) {
                    SCHEDULED_ACTIONS.remove(key, value);
                }
            }
            catch (Exception e) {
                DragonEggGame.LOGGER.error("Error in scheduled callback", (Throwable)e);
                SCHEDULED_ACTIONS.remove(key);
            }
        }));
        PlayerBlockBreakEvents.AFTER.register((world, player, pos, state, entity) -> {
            if (player.method_68878() && state.method_27852(class_2246.field_10081)) {
                DragonEggAPI.clearPosition();
            }
        });
        ServerEntityEvents.EQUIPMENT_CHANGE.register((livingEntity, equipmentSlot, previousStack, currentStack) -> {
            if (Utils.isOrHasDragonEgg(currentStack)) {
                DragonEggAPI.updatePosition((class_1297)livingEntity);
            }
        });
        ServerEntityEvents.ENTITY_LOAD.register((entity, world) -> {
            if (!(entity instanceof class_1542) && Utils.hasDragonEgg(entity)) {
                DragonEggAPI.updatePosition(entity);
            }
        });
        ServerEntityEvents.ENTITY_UNLOAD.register((entity, world) -> {
            class_1542 item;
            if (entity instanceof class_1540) {
                class_1540 fallingBlock = (class_1540)entity;
                if (entity.method_35049() == class_1297.class_5529.field_26998 && fallingBlock.method_6962().method_27852(class_2246.field_10081)) {
                    fallingBlock.method_5706(world, (class_1935)fallingBlock.method_6962().method_26204());
                }
            }
            if (entity instanceof class_1542 && Utils.isOrHasDragonEgg((item = (class_1542)entity).method_6983())) {
                class_1799 stack = item.method_6983();
                int count = stack.method_7947();
                if (!item.method_31481()) {
                    if (Utils.isNearServerSpawn((class_1297)item)) {
                        return;
                    }
                    if (stack.method_31574(class_1802.field_8840)) {
                        item.method_6987();
                        item.method_6979(class_1802.field_20391.method_7854());
                    }
                    item.method_5834(false);
                } else if (!item.method_5851()) {
                    return;
                }
                if (!stack.method_31574(class_1802.field_8840)) {
                    count = Utils.countDragonEgg(stack);
                }
                Utils.spawnDragonEggAtSpawn(world.method_8503(), count);
            }
        });
        ServerBlockEntityEvents.BLOCK_ENTITY_LOAD.register((blockEntity, world) -> {
            class_2621 lootableContainerBlockEntity;
            if (blockEntity instanceof class_2621 && (lootableContainerBlockEntity = (class_2621)blockEntity).method_54869() != null) {
                return;
            }
            if (blockEntity instanceof class_2624) {
                class_2624 containerBlockEntity = (class_2624)blockEntity;
                MinecraftServer server = world.method_8503();
                server.method_63588((Runnable)new class_3738(server.method_3780(), () -> {
                    if (containerBlockEntity.method_11015() || containerBlockEntity.method_5442()) {
                        return;
                    }
                    for (int i = 0; i < containerBlockEntity.method_5439(); ++i) {
                        class_1799 stack = containerBlockEntity.method_5438(i);
                        if (stack.method_7960() || !Utils.isOrHasDragonEgg(stack)) continue;
                        DragonEggAPI.updatePosition(DragonEggAPI.PositionType.INVENTORY, containerBlockEntity.method_11016(), containerBlockEntity.method_10997());
                        break;
                    }
                }));
            }
        });
    }
}

