/*
 * Decompiled with CFR 0.152.
 */
package de.arvitus.dragonegggame.api;

import de.arvitus.dragonegggame.DragonEggGame;
import de.arvitus.dragonegggame.Events;
import de.arvitus.dragonegggame.config.Config;
import de.arvitus.dragonegggame.files.Data;
import de.arvitus.dragonegggame.utils.ScheduledEvent;
import de.arvitus.dragonegggame.utils.Utils;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1540;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DragonEggAPI {
    private static final LinkedHashSet<Consumer<@NotNull Data>> onUpdateConsumers = new LinkedHashSet();
    private static final List<DeferredUpdate> deferredUpdates = new ArrayList<DeferredUpdate>();
    @Nullable
    private static Data data;

    public static void init() {
        DragonEggAPI.load_data();
        DragonEggAPI.dispatchUpdate();
    }

    private static void load_data() {
        data = Data.load();
        if (DragonEggGame.server != null) {
            DragonEggAPI.data.world = DragonEggGame.server.method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_60654((String)DragonEggAPI.data.worldId)));
            if (DragonEggAPI.data.world == null) {
                DragonEggGame.LOGGER.warn("Could not find world with id '{}'", (Object)DragonEggAPI.data.worldId);
            }
        }
    }

    public static synchronized void onUpdate(Consumer<@NotNull Data> consumer) {
        onUpdateConsumers.add(consumer);
        if (data != null) {
            consumer.accept(data);
        }
    }

    public static synchronized boolean unregisterListener(Consumer<@NotNull Data> consumer) {
        return onUpdateConsumers.remove(consumer);
    }

    private static void dispatchUpdate() {
        if (data != null) {
            ArrayList<DeferredUpdate> updatesToProcess = new ArrayList<DeferredUpdate>(deferredUpdates);
            deferredUpdates.clear();
            for (DeferredUpdate deferredUpdate : updatesToProcess) {
                DragonEggAPI.updatePosition(deferredUpdate.type, deferredUpdate.pos, deferredUpdate.world, deferredUpdate.entity);
            }
            for (Consumer consumer : new ArrayList<Consumer<Data>>(onUpdateConsumers)) {
                try {
                    consumer.accept(data);
                }
                catch (Exception e) {
                    DragonEggGame.LOGGER.warn("Error while dispatching update to listener {}: {}", (Object)consumer, (Object)e.getStackTrace());
                }
            }
        } else {
            DragonEggGame.LOGGER.warn("API is not ready, data is missing");
        }
    }

    public static void clearPosition() {
        DragonEggAPI.updatePosition(PositionType.NONE, null, null);
    }

    public static void updatePosition(@NotNull PositionType type, @Nullable class_2338 pos, class_1937 world) {
        class_243 position = pos == null ? null : pos.method_46558();
        DragonEggAPI.updatePosition(type, position, world, null);
    }

    public static void updatePosition(class_1297 entity) {
        DragonEggAPI.updatePosition(DragonEggAPI.getPositionType(entity), entity.method_19538(), entity.method_37908(), entity);
    }

    private static synchronized void updatePosition(@NotNull PositionType type, class_243 pos, class_1937 world, @Nullable class_1297 entity) {
        class_1937 oldWorld;
        if (data == null) {
            DragonEggGame.LOGGER.warn("API not ready, deferring position update");
            deferredUpdates.add(new DeferredUpdate(type, pos, world, entity));
            return;
        }
        DragonEggGame.LOGGER.debug("Updating Dragon Egg position to type: {}, pos: {}, world: {}, entity: {}", new Object[]{type, pos != null ? class_2338.method_49638((class_2374)pos).method_23854() : null, world != null ? world.method_27983().method_29177() : null, entity});
        if (type == PositionType.NONE || pos == null || world == null) {
            DragonEggAPI.data.type = PositionType.NONE;
            data.save();
            DragonEggAPI.dispatchUpdate();
            return;
        }
        if (entity != null) {
            DragonEggAPI.data.entityUUID = entity.method_5667();
            if (type == PositionType.PLAYER) {
                DragonEggAPI.data.playerUUID = entity.method_5667();
            }
            DragonEggAPI.trackEntity(entity);
        } else {
            DragonEggAPI.data.entityUUID = null;
        }
        class_1937 class_19372 = oldWorld = DragonEggAPI.data.world != null ? DragonEggAPI.data.world : world;
        if (!oldWorld.equals(world) || !pos.method_24802((class_2374)data.getRandomizedPosition().method_46558(), (double)DragonEggGame.CONFIG.searchRadius)) {
            data.clearRandomizedPosition();
        }
        DragonEggAPI.data.type = type;
        DragonEggAPI.data.world = world;
        DragonEggAPI.data.worldId = world.method_27983().method_29177().toString();
        DragonEggAPI.data.position = pos;
        data.save();
        DragonEggAPI.dispatchUpdate();
    }

    private static synchronized void trackEntity(class_1297 entity) {
        if (DragonEggGame.CONFIG.getVisibility(DragonEggAPI.getPositionType(entity)) == Config.VisibilityType.EXACT) {
            entity.method_5834(true);
        }
        Events.SCHEDULED_ACTIONS.put(entity.method_5667(), new ScheduledEvent(100L, server -> Optional.ofNullable(DragonEggAPI.getData()).ifPresent(data -> {
            if (entity.method_31481()) {
                return;
            }
            entity.method_5834(false);
            if (!Utils.hasDragonEgg(entity)) {
                return;
            }
            if (entity.method_19538() != data.position) {
                DragonEggAPI.updatePosition(entity);
            } else {
                DragonEggAPI.trackEntity(entity);
            }
        })));
    }

    @Nullable
    public static Data getData() {
        return data;
    }

    public static PositionType getPositionType(class_1297 entity) {
        class_1297 class_12972 = entity;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_1542.class, class_1540.class, class_1657.class}, (Object)class_12972, n)) {
            case 0 -> {
                class_1542 ignored = (class_1542)class_12972;
                yield PositionType.ITEM;
            }
            case 1 -> {
                class_1540 ignored = (class_1540)class_12972;
                yield PositionType.FALLING_BLOCK;
            }
            case 2 -> {
                class_1657 ignored = (class_1657)class_12972;
                yield PositionType.PLAYER;
            }
            case -1 -> PositionType.NONE;
            default -> PositionType.ENTITY;
        };
    }

    private record DeferredUpdate(PositionType type, class_243 pos, class_1937 world, class_1297 entity) {
    }

    public static enum PositionType {
        BLOCK,
        ITEM,
        FALLING_BLOCK,
        INVENTORY,
        ENTITY,
        PLAYER,
        NONE;

    }
}

