/*
 * Decompiled with CFR 0.152.
 */
package de.arvitus.dragonegggame.config;

import de.arvitus.dragonegggame.DragonEggGame;
import de.arvitus.dragonegggame.api.DragonEggAPI;
import de.arvitus.dragonegggame.config.MessageString;
import eu.pb4.placeholders.api.parsers.NodeParser;
import java.nio.file.Path;
import java.util.Map;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.hocon.HoconConfigurationLoader;
import org.spongepowered.configurate.objectmapping.ConfigSerializable;
import org.spongepowered.configurate.objectmapping.meta.Comment;
import org.spongepowered.configurate.serialize.TypeSerializer;

@ConfigSerializable
public class Config {
    public static final Map<DragonEggAPI.PositionType, VisibilityType> defaultVisibility = Map.of(DragonEggAPI.PositionType.BLOCK, VisibilityType.RANDOMIZED, DragonEggAPI.PositionType.ITEM, VisibilityType.EXACT, DragonEggAPI.PositionType.FALLING_BLOCK, VisibilityType.EXACT, DragonEggAPI.PositionType.INVENTORY, VisibilityType.EXACT, DragonEggAPI.PositionType.ENTITY, VisibilityType.EXACT, DragonEggAPI.PositionType.PLAYER, VisibilityType.HIDDEN, DragonEggAPI.PositionType.NONE, VisibilityType.HIDDEN);
    private static final Path PATH = DragonEggGame.CONFIG_DIR.resolve("config.conf");
    private static final HoconConfigurationLoader LOADER = ((HoconConfigurationLoader.Builder)((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().path(PATH)).prettyPrinting(true).defaultOptions(opts -> opts.serializers(build -> build.register(MessageString.class, (TypeSerializer)new MessageString.Serializer(Messages.PARSER))))).build();
    @Comment(value="The radius that is used to randomize the dragon egg position.\nDefault: 25")
    public float searchRadius = 25.0f;
    @Comment(value="The name of the BlueMap marker")
    public String markerName = "Dragon Egg";
    @Comment(value="The description of the BlueMap area marker")
    public String areaMarkerDescription = "The dragon egg is somewhere in this area.";
    @Comment(value="The description of the BlueMap point marker")
    public String pointMarkerDescription = "Come and get it!";
    @Comment(value="The URL of the BlueMap point marker icon")
    public String pointMarkerIcon = "https://minecraft.wiki/images/thumb/Dragon_Egg_JE4.png/150px-Dragon_Egg_JE4.png";
    @Comment(value="The color of the BlueMap marker as a decimal value.\nDefault: 2818132 (Purple)")
    public int markerColor = 2818132;
    @Comment(value="Messages used throughout the mod")
    public Messages messages = new Messages();
    @Comment(value="The visibility of the dragon egg for each position type.\nDefault: {\n   BLOCK=RANDOMIZED, // placed as Block\n   ITEM=EXACT, // item entity\n   FALLING_BLOCK=EXACT, // falling block entity\n   INVENTORY=EXACT, // block inventory\n   ENTITY=EXACT, // entity inventory\n   PLAYER=HIDDEN, // player inventory\n}")
    private Map<DragonEggAPI.PositionType, VisibilityType> visibility = defaultVisibility;

    public static Config loadOrCreate() {
        if (!PATH.toFile().isFile()) {
            CommentedConfigurationNode node = (CommentedConfigurationNode)LOADER.createNode();
            try {
                node.set((Object)new Config());
                LOADER.save((ConfigurationNode)node);
            }
            catch (Exception e) {
                DragonEggGame.LOGGER.warn("Failed to save default config to disk", (Throwable)e);
            }
        } else {
            try {
                return (Config)((CommentedConfigurationNode)LOADER.load()).get(Config.class);
            }
            catch (Exception e) {
                if (DragonEggGame.CONFIG != null) {
                    DragonEggGame.LOGGER.warn("Failed to load config, using previous value instead", (Throwable)e);
                    return DragonEggGame.CONFIG;
                }
                DragonEggGame.LOGGER.warn("Failed to load config, using default config instead", (Throwable)e);
            }
        }
        return new Config();
    }

    public VisibilityType getVisibility(DragonEggAPI.PositionType type) {
        return this.visibility.getOrDefault((Object)type, defaultVisibility.get((Object)type));
    }

    @ConfigSerializable
    public static class Messages {
        private static final NodeParser PARSER = NodeParser.builder().globalPlaceholders().quickText().staticPreParsing().build();
        @Comment(value="The message that is displayed when using '/dragon_egg bearer' and the visibility of the current position type is 'EXACT' (see visibility)")
        public MessageString bearerExact = new MessageString(PARSER, "<yellow>The %deg:item% is currently held by <gold>%deg:bearer%</> and was last seen at <gold>%deg:pos%</>.");
        @Comment(value="The message that is displayed when using '/dragon_egg bearer' and the visibility of the current position type is 'RANDOMIZED' (see visibility)")
        public MessageString bearerRandomized = new MessageString(PARSER, "<yellow>The %deg:item% is currently held by <gold>%deg:bearer%</> and was last seen around <gold>%deg:pos%</>.");
        @Comment(value="The message that is displayed when using '/dragon_egg bearer' and the visibility of the current position type is 'HIDDEN' (see visibility)")
        public MessageString bearerHidden = new MessageString(PARSER, "<yellow>The %deg:item% is currently held by <gold>%deg:bearer%</>.");
        @Comment(value="The message that is displayed when using '/dragon_egg bearer' but there is no bearer")
        public MessageString noBearer = new MessageString(PARSER, "<yellow>No one has snatched the %deg:item% yet.");
        @Comment(value="The message that is displayed when using '/dragon_egg bearer' but there is an error")
        public MessageString bearerError = new MessageString(PARSER, "<red>Currently not available.");
        @Comment(value="The dragon egg bearer has changed")
        public MessageString bearerChanged = new MessageString(PARSER, "<yellow><gold>%deg:bearer%</> now has the %deg:item%!");
        @Comment(value="The message that is displayed when using '/dragon_egg info'")
        public MessageString info = new MessageString(PARSER, "\n\n\n<aqua><bold>The Dragon Egg Server Game</*>\n<gray>----------------------------</*>\n<yellow>Whoever has the %deg:item%, must place the %deg:item% <gold><hover show_text \"    When arriving at the base, you should quickly know where to look     and the time needed for the search should be appropriate.\">obvious</></> and <gold><hover show_text \"    You shouldn't have to destroy anything to get to the %deg:item%.\">accessible for everyone</></> in the own base. You can <gold><hover show_text \"    It's supposed to be fun for everybody, so please look out for another and fight fair.     (It's best if you don't fight at all!)\n    The defense should not go beyond your own base and lost items (e.g. because of death) must be returned.\">protect</></> it with traps and your own life, or put it in a huge vault, but it has to be <gold><hover show_text \"    When arriving at the base, you should quickly know where to look     and the time needed for the search should be appropriate.\">obvious</></> where the %deg:item% is. Everyone else now can steal the %deg:item% and has to place it in their base respectively.</*>\n<red><italic>You may only steal the egg, if the current egg bearer is online or if they have been offline for at least 3 days!".replace("  ", ""));
    }

    public static enum VisibilityType {
        RANDOMIZED,
        EXACT,
        HIDDEN;

    }
}

