/*
 * Decompiled with CFR 0.152.
 */
package de.arvitus.dragonegggame.files;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.SerializedName;
import de.arvitus.dragonegggame.DragonEggGame;
import de.arvitus.dragonegggame.api.DragonEggAPI;
import de.arvitus.dragonegggame.utils.Utils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.UUID;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3i;

public class Data {
    @Nullable
    public transient class_1937 world;
    @NotNull
    public transient class_243 position = class_243.field_1353;
    @SerializedName(value="world")
    @NotNull
    public String worldId = "minecraft:overworld";
    @SerializedName(value="entity_uuid")
    @Nullable
    public UUID entityUUID;
    @SerializedName(value="player_uuid")
    @Nullable
    public UUID playerUUID;
    @NotNull
    public DragonEggAPI.PositionType type = DragonEggAPI.PositionType.NONE;
    @SerializedName(value="type")
    @Nullable
    private transient class_2338 randomizedPosition;
    @SerializedName(value="position")
    @Nullable
    private Vector3f _position;
    @SerializedName(value="randomized_position")
    @Nullable
    private Vector3i _randomizedPosition;

    public static Data load() {
        Data data = new Data();
        File dataFile = DragonEggGame.CONFIG_DIR.resolve("data.json").toFile();
        try (FileReader reader = new FileReader(dataFile);){
            data = (Data)new Gson().fromJson((Reader)reader, Data.class);
        }
        catch (FileNotFoundException ignored) {
            DragonEggGame.LOGGER.debug("data.json not found, using default values");
        }
        catch (JsonIOException | IOException e) {
            DragonEggGame.LOGGER.warn("could not load saved data, using default values");
        }
        catch (JsonSyntaxException e) {
            DragonEggGame.LOGGER.warn("saved data is invalid: {}, using default values", (Object)e.getMessage());
        }
        if (data._randomizedPosition != null) {
            data.randomizedPosition = new class_2338(data._randomizedPosition.x, data._randomizedPosition.y, data._randomizedPosition.z);
        }
        if (data._position != null) {
            data.position = new class_243(data._position);
        }
        return data;
    }

    public class_2338 getRandomizedPosition() {
        if (this.randomizedPosition == null) {
            this.randomizedPosition = Utils.randomizePosition(this.getBlockPos(), DragonEggGame.CONFIG.searchRadius);
        }
        return this.randomizedPosition;
    }

    public class_2338 getBlockPos() {
        return class_2338.method_49638((class_2374)this.position);
    }

    public void clearRandomizedPosition() {
        this.randomizedPosition = null;
    }

    public void save() {
        class_2338 randPos = this.getRandomizedPosition();
        this._randomizedPosition = new Vector3i(randPos.method_10263(), randPos.method_10264(), randPos.method_10260());
        this._position = this.position.method_46409();
        File dataFile = DragonEggGame.CONFIG_DIR.resolve("data.json").toFile();
        try (FileWriter writer = new FileWriter(dataFile);){
            new GsonBuilder().setPrettyPrinting().create().toJson((Object)this, (Appendable)writer);
        }
        catch (JsonIOException | IOException e) {
            DragonEggGame.LOGGER.warn("could not save data: {}", (Object)e.getMessage());
        }
    }
}

