/*
 * Decompiled with CFR 0.152.
 */
package de.arvitus.dragonegggame.utils;

import de.arvitus.dragonegggame.interfaces.BlockInventory;
import de.arvitus.dragonegggame.interfaces.EntityInventory;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1540;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_6067;
import net.minecraft.class_7225;
import net.minecraft.class_9276;
import net.minecraft.class_9288;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Utils {
    public static class_2338 randomizePosition(class_2338 pos, float radius) {
        return pos.method_10081((class_2382)Utils.randomSpherePoint(radius));
    }

    private static class_2338 randomSpherePoint(float radius) {
        double u = Math.random();
        double v = Math.random();
        double theta = Math.PI * 2 * u;
        double phi = Math.acos(2.0 * v - 1.0);
        double r = Math.cbrt(Math.random()) * (double)radius;
        double x = r * Math.sin(phi) * Math.cos(theta);
        double y = r * Math.sin(phi) * Math.sin(theta);
        double z = r * Math.cos(phi);
        return class_2338.method_49637((double)x, (double)y, (double)z);
    }

    public static boolean isOrHasDragonEgg(class_1799 stack) {
        return Utils.countDragonEgg(stack) > 0;
    }

    public static int countDragonEgg(class_1799 stack) {
        return Utils.countDragonEgg(stack, 0);
    }

    private static int countDragonEgg(class_1799 stack, int currentDepth) {
        if (stack.method_7960() || currentDepth >= 10) {
            return 0;
        }
        if (stack.method_31574(class_1802.field_8840)) {
            return stack.method_7947();
        }
        class_9323 components = stack.method_57353();
        if (components == class_9323.field_49584) {
            return 0;
        }
        AtomicInteger count = new AtomicInteger();
        Optional.ofNullable((class_9288)components.method_58694(class_9334.field_49622)).ifPresent(containerComponent -> containerComponent.method_59714().forEach(itemStack -> count.addAndGet(Utils.countDragonEgg(itemStack, currentDepth + 1))));
        Optional.ofNullable((class_9276)components.method_58694(class_9334.field_49650)).ifPresent(bundleComponent -> bundleComponent.method_57421().forEach(itemStack -> count.addAndGet(Utils.countDragonEgg(itemStack, currentDepth + 1))));
        return count.get();
    }

    public static class_1799 removeDragonEgg(class_1799 containerStack) {
        int count = 0;
        if (!containerStack.method_31574(class_1802.field_8840)) {
            count = Utils.countDragonEgg(containerStack, 0);
            Utils.removeDragonEgg(containerStack, 0);
        }
        return class_1802.field_8840.method_7854().method_46651(count);
    }

    private static void removeDragonEgg(class_1799 containerStack, int currentDepth) {
        if (containerStack.method_7960() || currentDepth >= 10) {
            return;
        }
        Optional.ofNullable((class_9288)containerStack.method_58694(class_9334.field_49622)).ifPresent(containerComponent -> containerComponent.method_59714().forEach(itemStack -> {
            if (itemStack.method_31574(class_1802.field_8840)) {
                itemStack.method_7939(0);
            } else {
                Utils.removeDragonEgg(itemStack, currentDepth + 1);
            }
        }));
        Optional.ofNullable((class_9276)containerStack.method_58694(class_9334.field_49650)).ifPresent(bundleComponent -> {
            class_9276.class_9277 builder = new class_9276.class_9277(class_9276.field_49289);
            bundleComponent.method_57421().forEach(itemStack -> {
                if (!itemStack.method_7960() && !itemStack.method_31574(class_1802.field_8840)) {
                    Utils.removeDragonEgg(itemStack, currentDepth + 1);
                    builder.method_57432(itemStack);
                }
            });
            containerStack.method_57379(class_9334.field_49650, (Object)builder.method_57435());
        });
    }

    @Nullable
    public static class_1542 spawnDragonEggAtSpawn(@NotNull MinecraftServer server, int count) {
        class_3218 overworld = server.method_30002();
        class_243 spawnPos = overworld.method_43126().method_46558();
        class_1542 itemCopy = new class_1542((class_1937)overworld, spawnPos.field_1352, spawnPos.field_1351, spawnPos.field_1350, class_1802.field_8840.method_7854().method_46651(count));
        if (overworld.method_8649((class_1297)itemCopy)) {
            return itemCopy;
        }
        return null;
    }

    public static boolean isNearServerSpawn(class_1297 entity) {
        class_3218 overworld = Objects.requireNonNull(entity.method_5682()).method_30002();
        return entity.method_37908() == overworld && entity.method_19538().method_24802((class_2374)overworld.method_43126().method_46558(), 3.0);
    }

    public static boolean hasDragonEgg(class_1297 entity) {
        class_1309 livingEntity;
        if (entity instanceof class_1309 && (livingEntity = (class_1309)entity).method_24520(Utils::isOrHasDragonEgg)) {
            return true;
        }
        class_1297 class_12972 = entity;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_1542.class, class_1540.class, class_1263.class, class_1657.class, class_6067.class, EntityInventory.class}, (Object)class_12972, n)) {
            case 0 -> {
                class_1542 item = (class_1542)class_12972;
                yield Utils.isOrHasDragonEgg(item.method_6983());
            }
            case 1 -> {
                class_1540 fallingBlock = (class_1540)class_12972;
                if (fallingBlock.method_6962().method_27852(class_2246.field_10081) || fallingBlock.field_7194 != null && Utils.hasDragonEgg(class_2586.method_11005((class_2338)fallingBlock.method_24515(), (class_2680)fallingBlock.method_6962(), (class_2487)fallingBlock.field_7194, (class_7225.class_7874)fallingBlock.method_37908().method_30349()))) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                class_1263 inventory = (class_1263)class_12972;
                yield inventory.method_43256(Utils::isOrHasDragonEgg);
            }
            case 3 -> {
                class_1657 player = (class_1657)class_12972;
                yield player.method_31548().method_55753(Utils::isOrHasDragonEgg);
            }
            case 4 -> {
                class_6067 owner = (class_6067)class_12972;
                yield owner.method_35199().method_43256(Utils::isOrHasDragonEgg);
            }
            case 5 -> {
                EntityInventory inv = (EntityInventory)class_12972;
                yield inv.dragonEggGame$getInventory().method_43256(Utils::isOrHasDragonEgg);
            }
            default -> false;
        };
    }

    public static boolean hasDragonEgg(class_2586 blockEntity) {
        class_2586 class_25862 = blockEntity;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BlockInventory.class}, (Object)class_25862, n)) {
            case 0 -> {
                BlockInventory inventory = (BlockInventory)class_25862;
                yield inventory.dragonEggGame$getInventory().stream().anyMatch(Utils::isOrHasDragonEgg);
            }
            default -> false;
        };
    }
}

