/*
 * Decompiled with CFR 0.152.
 */
package de.arvitus.dragonegggame.test;

import de.arvitus.dragonegggame.DragonEggGame;
import de.arvitus.dragonegggame.config.MessageString;
import eu.pb4.placeholders.api.parsers.NodeParser;
import java.nio.file.Path;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.hocon.HoconConfigurationLoader;
import org.spongepowered.configurate.objectmapping.ConfigSerializable;
import org.spongepowered.configurate.objectmapping.ObjectMapper;
import org.spongepowered.configurate.objectmapping.meta.Comment;
import org.spongepowered.configurate.serialize.TypeSerializer;
import org.spongepowered.configurate.util.NamingScheme;
import org.spongepowered.configurate.util.NamingSchemes;

@ConfigSerializable
public class Messages {
    private static final Path PATH = DragonEggGame.CONFIG_DIR.resolve("messages.conf");
    private static final NodeParser PARSER = NodeParser.builder().globalPlaceholders().quickText().staticPreParsing().build();
    private static final ObjectMapper.Factory customFactory = ObjectMapper.factoryBuilder().defaultNamingScheme((NamingScheme)NamingSchemes.SNAKE_CASE).build();
    private static final HoconConfigurationLoader LOADER = ((HoconConfigurationLoader.Builder)((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().path(PATH)).prettyPrinting(true).defaultOptions(opts -> opts.serializers(build -> {
        build.registerAnnotatedObjects(customFactory);
        build.register(MessageString.class, (TypeSerializer)new MessageString.Serializer(PARSER));
    }))).build();
    @Comment(value="The message that is displayed when using /dragon_egg bearer")
    public MessageString bearer = new MessageString(PARSER, "<blue>Hello</blue>");

    public static Messages loadOrCreate() {
        if (!PATH.toFile().isFile()) {
            CommentedConfigurationNode node = (CommentedConfigurationNode)LOADER.createNode();
            try {
                node.set((Object)new Messages());
                LOADER.save((ConfigurationNode)node);
            }
            catch (Exception e) {
                DragonEggGame.LOGGER.warn("Failed to save default messages to disk", (Throwable)e);
            }
        } else {
            try {
                return (Messages)((CommentedConfigurationNode)LOADER.load()).get(Messages.class);
            }
            catch (Exception e) {
                DragonEggGame.LOGGER.warn("Failed to load messages, using default messages instead", (Throwable)e);
            }
        }
        return new Messages();
    }
}

