/*
 * Decompiled with CFR 0.152.
 */
package me.avacuoss;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.JDABuilder;
import net.dv8tion.jda.api.entities.Activity;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.events.interaction.ModalInteractionEvent;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.dv8tion.jda.api.events.interaction.component.ButtonInteractionEvent;
import net.dv8tion.jda.api.events.session.ReadyEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import net.dv8tion.jda.api.interactions.commands.OptionType;
import net.dv8tion.jda.api.interactions.commands.build.CommandData;
import net.dv8tion.jda.api.interactions.commands.build.Commands;
import net.dv8tion.jda.api.interactions.commands.build.SlashCommandData;
import net.dv8tion.jda.api.interactions.commands.build.SubcommandData;
import net.dv8tion.jda.api.interactions.components.ItemComponent;
import net.dv8tion.jda.api.interactions.components.buttons.Button;
import net.dv8tion.jda.api.interactions.components.text.TextInput;
import net.dv8tion.jda.api.interactions.components.text.TextInputStyle;
import net.dv8tion.jda.api.interactions.modals.Modal;
import net.dv8tion.jda.api.requests.GatewayIntent;
import net.dv8tion.jda.api.requests.restaction.MessageCreateAction;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod(value="dswhitelist")
public class DSwhitelist {
    private static MinecraftServer server;
    private JDA jda;
    private Properties config = new Properties();
    private ExecutorService worker;
    private String token;
    private String guildId;
    private boolean useGlobal;
    private boolean autoSave;

    public DSwhitelist() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.loadConfig();
        this.worker = Executors.newFixedThreadPool(Math.max(2, Runtime.getRuntime().availableProcessors() - 1));
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        server = event.getServer();
        this.startBot();
    }

    @SubscribeEvent
    public void onServerStopping(ServerStoppingEvent event) {
        this.shutdown();
    }

    private void loadConfig() {
        File file = new File("dswhitelist.properties");
        try {
            if (!file.exists()) {
                try (FileWriter fw = new FileWriter(file);){
                    fw.write("discord-token=\ndiscord-guild-id=\nuse-global-commands=true\nauto-save-whitelist=true\n");
                }
            }
            try (FileInputStream in = new FileInputStream(file);){
                this.config.load(in);
            }
            this.token = this.config.getProperty("discord-token", "").trim();
            this.guildId = this.config.getProperty("discord-guild-id", "").trim();
            this.useGlobal = Boolean.parseBoolean(this.config.getProperty("use-global-commands", "true"));
            this.autoSave = Boolean.parseBoolean(this.config.getProperty("auto-save-whitelist", "true"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void startBot() {
        if (this.token.isEmpty()) {
            System.err.println("[DSwhitelist] No Discord token!");
            return;
        }
        try {
            JDABuilder builder = JDABuilder.createDefault((String)this.token).enableIntents(GatewayIntent.GUILD_MESSAGES, new GatewayIntent[0]).setActivity(Activity.playing((String)"Whitelist Manager")).addEventListeners(new Object[]{new BotListener()});
            this.jda = builder.build();
            this.jda.addEventListener(new Object[]{new ListenerAdapter(){

                public void onReady(@NotNull ReadyEvent event) {
                    DSwhitelist.this.registerCommands(DSwhitelist.this.jda);
                    System.out.println("[DSwhitelist] Discord bot ready");
                }
            }});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void shutdown() {
        if (this.jda != null) {
            try {
                this.jda.shutdown();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.worker != null) {
            this.worker.shutdownNow();
        }
    }

    private void registerCommands(JDA jda) {
        SlashCommandData wl = Commands.slash((String)"wl", (String)"Whitelist manager").addSubcommands(new SubcommandData[]{new SubcommandData("add", "Add player").addOption(OptionType.STRING, "player", "Minecraft username", true)});
        SlashCommandData panel = Commands.slash((String)"panel", (String)"Send whitelist panel");
        if (this.useGlobal) {
            jda.updateCommands().addCommands(new CommandData[]{wl, panel}).queue();
        } else if (!this.guildId.isEmpty() && jda.getGuildById(this.guildId) != null) {
            jda.getGuildById(this.guildId).updateCommands().addCommands(new CommandData[]{wl, panel}).queue();
        } else {
            jda.updateCommands().addCommands(new CommandData[]{wl, panel}).queue();
        }
    }

    public class BotListener
    extends ListenerAdapter {
        private final HttpClient http = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).build();
        private final MojangRateLimiter limiter = new MojangRateLimiter(20, 8.0);
        private final Map<String, CachedUUID> cache = new ConcurrentHashMap<String, CachedUUID>();

        public void onSlashCommandInteraction(@NotNull SlashCommandInteractionEvent e) {
            if (e.getName().equals("panel")) {
                this.sendPanel(e);
                return;
            }
            if (!e.getName().equals("wl")) {
                return;
            }
            if (!"add".equals(e.getSubcommandName())) {
                return;
            }
            String player = e.getOption("player").getAsString();
            e.deferReply(true).queue(hook -> DSwhitelist.this.worker.submit(() -> {
                try {
                    UUID uuid = this.resolve(player);
                    if (uuid == null) {
                        hook.sendMessage("Player `" + player + "` not found.").queue();
                        return;
                    }
                    server.execute(() -> {
                        server.m_129892_().m_230957_(server.m_129893_(), "whitelist add " + player);
                        if (DSwhitelist.this.autoSave) {
                            server.m_129892_().m_230957_(server.m_129893_(), "whitelist reload");
                        }
                        hook.sendMessage("Player **" + player + "** added.").queue();
                    });
                }
                catch (Exception ex) {
                    hook.sendMessage("Error: " + ex.getMessage()).queue();
                }
            }));
        }

        public void onButtonInteraction(@NotNull ButtonInteractionEvent event) {
            if (!event.getComponentId().equals("wl_add")) {
                return;
            }
            TextInput input = TextInput.create((String)"player_name", (String)"Minecraft Username", (TextInputStyle)TextInputStyle.SHORT).setRequired(true).build();
            Modal modal = Modal.create((String)"wl_add_modal", (String)"Add to Whitelist").addActionRow(new ItemComponent[]{input}).build();
            event.replyModal(modal).queue();
        }

        public void onModalInteraction(@NotNull ModalInteractionEvent event) {
            if (!event.getModalId().equals("wl_add_modal")) {
                return;
            }
            String player = event.getValue("player_name").getAsString();
            event.deferReply(true).queue(hook -> DSwhitelist.this.worker.submit(() -> {
                try {
                    UUID uuid = this.resolve(player);
                    if (uuid == null) {
                        hook.sendMessage("Player `" + player + "` not found.").queue();
                        return;
                    }
                    server.execute(() -> {
                        server.m_129892_().m_230957_(server.m_129893_(), "whitelist add " + player);
                        if (DSwhitelist.this.autoSave) {
                            server.m_129892_().m_230957_(server.m_129893_(), "whitelist reload");
                        }
                        hook.sendMessage("Player **" + player + "** added via modal.").queue();
                    });
                }
                catch (Exception ex) {
                    hook.sendMessage("Error: " + ex.getMessage()).queue();
                }
            }));
        }

        private UUID resolve(String username) throws Exception {
            String key = username.toLowerCase();
            CachedUUID c = this.cache.get(key);
            if (c != null && Instant.now().isBefore(c.expiresAt)) {
                return c.uuid;
            }
            if (!this.limiter.tryConsume(1500L)) {
                return null;
            }
            HttpRequest req = HttpRequest.newBuilder(URI.create("https://api.mojang.com/users/profiles/minecraft/" + username)).timeout(Duration.ofSeconds(10L)).GET().build();
            HttpResponse<String> res = this.http.send(req, HttpResponse.BodyHandlers.ofString());
            if (res.statusCode() != 200) {
                return null;
            }
            JsonObject json = JsonParser.parseString((String)res.body()).getAsJsonObject();
            String id = json.get("id").getAsString();
            String uuidStr = id.replaceFirst("(\\p{XDigit}{8})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}+)", "$1-$2-$3-$4-$5");
            UUID uuid = UUID.fromString(uuidStr);
            this.cache.put(key, new CachedUUID(uuid, Instant.now().plus(Duration.ofMinutes(30L))));
            return uuid;
        }

        private void sendPanel(SlashCommandInteractionEvent event) {
            EmbedBuilder embed = new EmbedBuilder().setTitle("Minecraft Whitelist Panel").setDescription((CharSequence)"Press **Add Account** to add a player.").setColor(43263);
            ((MessageCreateAction)event.getChannel().sendMessageEmbeds(embed.build(), new MessageEmbed[0]).setActionRow(new ItemComponent[]{Button.success((String)"wl_add", (String)"Add Account")})).queue();
            event.reply("Panel sent.").setEphemeral(true).queue();
        }
    }

    private static class CachedUUID {
        final UUID uuid;
        final Instant expiresAt;

        CachedUUID(UUID uuid, Instant expiresAt) {
            this.uuid = uuid;
            this.expiresAt = expiresAt;
        }
    }

    public static class MojangRateLimiter {
        private final int capacity;
        private final double refillPerSec;
        private double tokens;
        private long lastRefillMs;

        public MojangRateLimiter(int capacity, double refillPerSec) {
            this.capacity = capacity;
            this.refillPerSec = refillPerSec;
            this.tokens = capacity;
            this.lastRefillMs = System.currentTimeMillis();
        }

        public synchronized boolean tryConsume(long timeoutMs) {
            long deadline = System.currentTimeMillis() + timeoutMs;
            while (System.currentTimeMillis() <= deadline) {
                this.refill();
                if (this.tokens >= 1.0) {
                    this.tokens -= 1.0;
                    return true;
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException ignored) {
                    return false;
                }
            }
            return false;
        }

        private void refill() {
            long now = System.currentTimeMillis();
            double delta = (double)(now - this.lastRefillMs) / 1000.0;
            if (delta <= 0.0) {
                return;
            }
            this.tokens = Math.min((double)this.capacity, this.tokens + delta * this.refillPerSec);
            this.lastRefillMs = now;
        }
    }
}

