/*
 * Decompiled with CFR 0.152.
 */
package dev.gxlg.librgetter;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.gxlg.librgetter.utils.types.Enchantment;
import dev.gxlg.librgetter.utils.types.config.Compatibility;
import dev.gxlg.librgetter.utils.types.config.IntRange;
import dev.gxlg.librgetter.utils.types.config.OnlyEffective;
import dev.gxlg.librgetter.utils.types.config.OptionsConfig;
import dev.gxlg.librgetter.utils.types.config.enums.LogMode;
import dev.gxlg.librgetter.utils.types.config.enums.MatchMode;
import dev.gxlg.librgetter.utils.types.config.enums.RotationMode;
import dev.gxlg.librgetter.utils.types.config.helpers.Configurable;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.NotNull;

public class Config {
    public boolean notify = false;
    @OnlyEffective(when="manual", equals={"false"})
    public boolean autoTool = true;
    public LogMode logMode = LogMode.CHAT;
    @OnlyEffective(when="manual", equals={"false"})
    public boolean lock = false;
    public boolean removeGoal = false;
    public boolean checkUpdate = true;
    public boolean warning = true;
    @OnlyEffective(when="manual", equals={"false"})
    public boolean offhand = false;
    public boolean manual = false;
    public boolean waitLose = false;
    public boolean safeChecker = true;
    public boolean fallback = false;
    @OnlyEffective(when="manual", equals={"false"})
    public RotationMode rotationMode = RotationMode.INSTANT;
    @IntRange(min=0, max=20)
    public int timeout = 0;
    @NotNull
    public MatchMode matchMode = MatchMode.VANILLA;
    @OnlyEffective(when="matchMode", equals={"ATLEAST"})
    @IntRange(min=1)
    public int matchAtLeast = 1;
    @Compatibility(value="trade_cycling")
    public boolean tradeCycling = false;
    public List<Enchantment> goals = new ArrayList<Enchantment>();
    private final transient List<Configurable<?>> configurable = new ArrayList();
    private final transient Map<String, Configurable<?>> configurableMap = new HashMap();
    private final transient Map<String, List<Configurable<?>>> categoryMap = new HashMap();
    private static final Map<String, List<String>> categories = Map.of("process", List.of("autoTool", "offhand", "rotationMode", "manual", "waitLose", "safeChecker", "timeout"), "success", List.of("notify", "removeGoal", "lock"), "messages", List.of("logMode", "warning", "checkUpdate"), "matching", List.of("fallback", "matchMode", "matchAtLeast"), "compatibility", Arrays.stream(Config.class.getFields()).filter(f -> f.getAnnotation(Compatibility.class) != null).map(Field::getName).sorted().toList());
    public static final List<String> CATEGORIES = List.of("process", "success", "messages", "matching", "compatibility");
    private static final Path configPath = FabricLoader.getInstance().getConfigDir().resolve("librgetter.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final Config DEFAULT = new Config();

    public Config() {
        for (Field f : Config.class.getFields()) {
            Configurable<Object> conf;
            if (f.getType() == Boolean.TYPE) {
                conf = new Configurable<Boolean>(f.getName(), Boolean.class, this);
            } else if (f.getType() == Integer.TYPE) {
                conf = new Configurable<Integer>(f.getName(), Integer.class, this);
            } else {
                if (!OptionsConfig.class.isAssignableFrom(f.getType())) continue;
                conf = new Configurable<OptionsConfig>(f.getName(), OptionsConfig.class, this);
            }
            this.configurable.add(conf);
            this.configurableMap.put(f.getName(), conf);
            String key2 = categories.entrySet().stream().filter(e -> ((List)e.getValue()).contains(f.getName())).findFirst().map(Map.Entry::getKey).orElseThrow(() -> new RuntimeException("Uncategorized config '" + f.getName() + "'"));
            this.categoryMap.computeIfAbsent(key2, k -> new ArrayList()).add(conf);
        }
        this.configurable.sort(Comparator.comparing(Configurable::name));
        this.categoryMap.forEach((key, value) -> value.sort(Comparator.comparing(c -> categories.get(key).indexOf(c.name()))));
    }

    public static Config init() {
        Config config;
        if (Files.notExists(configPath, new LinkOption[0])) {
            try {
                Files.createFile(configPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not initialize config", e);
            }
            config = new Config();
        } else {
            try (FileReader reader = new FileReader(configPath.toFile());){
                config = (Config)GSON.fromJson((Reader)reader, Config.class);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not parse config", e);
            }
        }
        config.save();
        return config;
    }

    public void save() {
        Path dir = configPath.getParent();
        try {
            if (Files.notExists(dir, new LinkOption[0])) {
                Files.createDirectory(dir, new FileAttribute[0]);
            } else if (!Files.isDirectory(dir, new LinkOption[0])) {
                throw new IOException("Not a directory: " + String.valueOf(dir));
            }
            Path tempPath = configPath.resolveSibling(String.valueOf(configPath.getFileName()) + ".tmp");
            if (!Files.exists(tempPath, new LinkOption[0])) {
                Files.createFile(tempPath, new FileAttribute[0]);
            }
            Files.write(tempPath, GSON.toJson((Object)this).getBytes(), StandardOpenOption.WRITE);
            Files.move(tempPath, configPath, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not save config", e);
        }
    }

    public List<Configurable<?>> getConfigurables() {
        return this.configurable;
    }

    public List<Configurable<?>> getConfigurablesForCategory(String category) {
        return this.categoryMap.getOrDefault(category, List.of());
    }

    public Configurable<?> getConfigurableForName(String field) {
        return this.configurableMap.getOrDefault(field, null);
    }
}

