/*
 * Decompiled with CFR 0.152.
 */
package dev.gxlg.librgetter;

import com.mojang.datafixers.util.Either;
import dev.gxlg.librgetter.LibrGetter;
import dev.gxlg.librgetter.utils.PathFinding;
import dev.gxlg.librgetter.utils.reflection.Minecraft;
import dev.gxlg.librgetter.utils.reflection.Support;
import dev.gxlg.librgetter.utils.reflection.Texts;
import dev.gxlg.librgetter.utils.types.Enchantment;
import dev.gxlg.librgetter.utils.types.config.enums.MatchMode;
import dev.gxlg.librgetter.utils.types.config.enums.RotationMode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1713;
import net.minecraft.class_1743;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1914;
import net.minecraft.class_1916;
import net.minecraft.class_2183;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2868;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_634;
import net.minecraft.class_636;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public class Worker {
    @Nullable
    private static class_2338 block;
    @Nullable
    private static class_1799 defaultAxe;
    @Nullable
    private static class_1916 trades;
    @Nullable
    private static class_1646 villager;
    private static State state;
    private static Object source;
    private static int counter;
    private static final List<Enchantment> offeredEnchantments;
    private static int otherTrade;
    private static LockType lockType;
    private static int timeout;
    private static class_243 goalPos;
    private static State nextState;
    private static final Random rng;

    public static State getState() {
        return state;
    }

    private static void error(String msg, String ... args) {
        Texts.sendError(source, msg, args);
        state = State.STANDBY;
    }

    /*
     * WARNING - void declaration
     */
    public static void tick() {
        if (state == State.STANDBY) {
            return;
        }
        if (block == null || villager == null) {
            Worker.error("librgetter.specify", new String[0]);
            return;
        }
        class_310 client = class_310.method_1551();
        class_746 player = client.field_1724;
        if (player == null) {
            Worker.error("librgetter.internal", "player");
            return;
        }
        if (!block.method_19771((class_2382)player.method_24515(), (double)3.4f) || villager.method_5739((class_1297)player) > 3.4f) {
            Worker.error("librgetter.far", new String[0]);
            return;
        }
        if (state == State.MANUAL_WAIT_FINISH) {
            return;
        }
        if (state == State.ROTATION) {
            double d = goalPos.method_10216();
            double e = goalPos.method_10214();
            double f2 = goalPos.method_10215();
            double g = Math.sqrt(d * d + f2 * f2);
            float goalPitch = class_3532.method_15393((float)((float)(-(class_3532.method_15349((double)e, (double)g) * 180.0 / Math.PI))));
            float goalYaw = class_3532.method_15393((float)((float)(class_3532.method_15349((double)f2, (double)d) * 180.0 / Math.PI) - 90.0f));
            float currentYaw = player.method_36454();
            float currentPitch = player.method_36455();
            float yawDelta = (goalYaw - currentYaw) % 360.0f;
            if (yawDelta < -180.0f) {
                yawDelta += 360.0f;
            }
            if (yawDelta >= 180.0f) {
                yawDelta -= 360.0f;
            }
            float pitchDelta = goalPitch - currentPitch;
            float newPitch = currentPitch + 0.35f * pitchDelta + (rng.nextFloat() - 0.5f) * 0.2f;
            float newYaw = currentYaw + 0.35f * yawDelta + (rng.nextFloat() - 0.5f) * 0.2f;
            player.method_36457(newPitch);
            player.method_36456(newYaw);
            player.method_5847(player.method_36454());
            if (Math.abs(pitchDelta) < 0.8f && Math.abs(yawDelta) < 0.8f) {
                state = nextState;
            } else {
                return;
            }
        }
        if (state == State.SELECT_AXE) {
            class_636 manager;
            ++counter;
            class_1661 inventory = player.method_31548();
            if (inventory == null) {
                Worker.error("librgetter.internal", "inventory");
                return;
            }
            int slot = -1;
            if (LibrGetter.config.autoTool) {
                void var5_52;
                float max = -1.0f;
                boolean bl = false;
                while (var5_52 < 36) {
                    class_1799 stack = inventory.method_5438((int)var5_52);
                    if (!stack.method_7963() || stack.method_7936() - stack.method_7919() >= 10) {
                        float f3 = stack.method_7924(class_2246.field_16330.method_9564());
                        int ef = Minecraft.getEfficiencyLevel(stack);
                        if (stack.method_7909() instanceof class_1743) {
                            f3 += (float)(ef * ef + 1);
                        }
                        if (f3 > max) {
                            max = f3;
                            slot = var5_52;
                        }
                    }
                    ++var5_52;
                }
            } else {
                if (defaultAxe == null || !defaultAxe.method_7963()) {
                    state = State.BREAK_LECTERN;
                    return;
                }
                for (int i = 0; i < 36; ++i) {
                    class_1799 class_17992 = inventory.method_5438(i);
                    if (!class_1799.method_7973((class_1799)class_17992, (class_1799)defaultAxe)) continue;
                    slot = i;
                    break;
                }
            }
            if ((manager = client.field_1761) == null) {
                Worker.error("librgetter.internal", "manager0");
                return;
            }
            class_634 class_6342 = client.method_1562();
            if (class_6342 == null) {
                Worker.error("librgetter.internal", "handler0");
                return;
            }
            if (slot != -1) {
                if (!class_1661.method_7380((int)slot)) {
                    int syncId = player.field_7498.field_7763;
                    int swap = inventory.method_7386();
                    manager.method_2906(syncId, slot, swap, class_1713.field_7791, (class_1657)player);
                    slot = swap;
                }
                Minecraft.setSelectedSlot(inventory, slot);
                class_2868 packetSelect = new class_2868(slot);
                Minecraft.getConnection(class_6342).method_10743((class_2596)packetSelect);
            }
            Worker.prepareRotation(player, new class_243((double)block.method_10263() + 0.5, (double)block.method_10264(), (double)block.method_10260() + 0.5), State.BREAK_LECTERN);
        }
        if (state == State.BREAK_LECTERN) {
            class_638 world = client.field_1687;
            if (world == null) {
                Worker.error("librgetter.internal", "world");
                return;
            }
            class_2680 targetBlock = world.method_8320(block);
            if (!targetBlock.method_26215()) {
                if (LibrGetter.config.manual) {
                    return;
                }
                class_636 manager = client.field_1761;
                if (manager == null) {
                    Worker.error("librgetter.internal", "manager1");
                    return;
                }
                manager.method_2902(block, class_2350.field_11036);
                return;
            }
            State state = Worker.state = LibrGetter.config.waitLose ? State.WAIT_VILLAGER_LOSE_PROFESSION : State.SELECT_LECTERN_AND_PLACE;
        }
        if (state == State.WAIT_VILLAGER_LOSE_PROFESSION) {
            if (!Minecraft.isVillagerUnemployed(villager)) {
                return;
            }
            state = State.SELECT_LECTERN_AND_PLACE;
        }
        if (state == State.SELECT_LECTERN_AND_PLACE) {
            class_638 world = Minecraft.getWorld(player);
            if (!world.method_8320(block).method_27852(class_2246.field_16330)) {
                void var5_58;
                if (LibrGetter.config.manual) {
                    return;
                }
                class_1661 inventory = player.method_31548();
                if (inventory == null) {
                    Worker.error("librgetter.internal", "inventory");
                    return;
                }
                boolean bl = true;
                int slot = class_1799.method_7984((class_1799)inventory.method_5438(40), (class_1799)class_1802.field_16312.method_7854()) ? 40 : inventory.method_7395(class_1802.field_16312.method_7854());
                if (slot == -1) {
                    return;
                }
                class_636 manager = client.field_1761;
                if (manager == null) {
                    Worker.error("librgetter.internal", "manager2");
                    return;
                }
                class_634 handler = client.method_1562();
                if (handler == null) {
                    Worker.error("librgetter.internal", "handler1");
                    return;
                }
                if (slot != 40) {
                    if (LibrGetter.config.offhand) {
                        if (class_1661.method_7380((int)slot)) {
                            slot += 36;
                        }
                        manager.method_2906(player.field_7512.field_7763, slot, 40, class_1713.field_7791, (class_1657)player);
                        boolean bl2 = false;
                    } else {
                        if (!class_1661.method_7380((int)slot)) {
                            int syncId = player.field_7498.field_7763;
                            int swap = inventory.method_7386();
                            manager.method_2906(syncId, slot, swap, class_1713.field_7791, (class_1657)player);
                            slot = swap;
                        }
                        Minecraft.setSelectedSlot(inventory, slot);
                        class_2868 packetSelect = new class_2868(slot);
                        Minecraft.getConnection(handler).method_10743((class_2596)packetSelect);
                    }
                } else {
                    boolean bl3 = false;
                }
                class_243 lowBlockPos = new class_243((double)block.method_10263(), (double)(block.method_10264() - 1), (double)block.method_10260());
                class_3965 lowBlock = new class_3965(lowBlockPos, class_2350.field_11036, block.method_10074(), false);
                Minecraft.interactBlock(manager, player, lowBlock, (boolean)var5_58);
                return;
            }
            Worker.prepareRotation(player, class_2183.class_2184.field_9851.method_9302((class_1297)villager), State.WAIT_VILLAGER_ACCEPT_PROFESSION);
        }
        if (state == State.WAIT_VILLAGER_ACCEPT_PROFESSION) {
            if (Minecraft.isVillagerUnemployed(villager)) {
                if (LibrGetter.config.timeout != 0 && ++timeout >= LibrGetter.config.timeout * 20) {
                    timeout = 0;
                    state = LibrGetter.config.manual ? State.BREAK_LECTERN : State.SELECT_AXE;
                }
                return;
            }
            if (!Minecraft.isVillagerLibrarian(villager)) {
                Worker.error("librgetter.pick", new String[0]);
                return;
            }
            timeout = 0;
            trades = null;
            state = State.GET_TRADES;
        }
        if (state == State.GET_TRADES) {
            if (trades == null) {
                if (LibrGetter.config.manual) {
                    return;
                }
                class_634 handler = client.method_1562();
                if (handler == null) {
                    Worker.error("librgetter.internal", "handler2");
                    return;
                }
                class_636 manager = client.field_1761;
                if (manager == null) {
                    Worker.error("librgetter.internal", "manager3");
                    return;
                }
                manager.method_2905((class_1657)player, (class_1297)villager, class_1268.field_5808);
                return;
            }
            state = State.PARSE_TRADES;
        }
        if (state == State.PARSE_TRADES) {
            Worker.getEnchant();
            Texts.sendMessage(player, "librgetter.offer", offeredEnchantments);
            if (!offeredEnchantments.isEmpty()) {
                boolean match = false;
                ArrayList<Enchantment> success = new ArrayList<Enchantment>();
                if (LibrGetter.config.matchMode == MatchMode.VANILLA) {
                    for (Enchantment enchantment : LibrGetter.config.goals) {
                        if (!enchantment.meets(offeredEnchantments.get(0))) continue;
                        match = true;
                        success.add(offeredEnchantments.get(0));
                        break;
                    }
                } else if (LibrGetter.config.matchMode == MatchMode.PERFECT) {
                    match = true;
                    for (Enchantment enchantment : offeredEnchantments) {
                        boolean thisMatch = false;
                        for (Enchantment l : LibrGetter.config.goals) {
                            if (!l.meets(enchantment)) continue;
                            thisMatch = true;
                            success.add(enchantment);
                            break;
                        }
                        if (thisMatch) continue;
                        match = false;
                        break;
                    }
                } else if (LibrGetter.config.matchMode == MatchMode.ATLEAST) {
                    HashSet<Enchantment> found = new HashSet<Enchantment>();
                    for (Enchantment offer : offeredEnchantments) {
                        for (Enchantment l : LibrGetter.config.goals) {
                            if (!l.meets(offer)) continue;
                            found.add(l);
                            success.add(offer);
                        }
                    }
                    if (found.size() >= Math.min(LibrGetter.config.matchAtLeast, LibrGetter.config.goals.size())) {
                        match = true;
                    }
                }
                if (match) {
                    success.forEach(f -> Texts.sendFound(source, f, counter));
                    if (LibrGetter.config.notify) {
                        if (client.field_1687 == null) {
                            Texts.sendError(source, "librgetter.internal", "world");
                        } else {
                            Minecraft.playSound(client.field_1687, player);
                        }
                    }
                    if (LibrGetter.config.manual) {
                        state = State.MANUAL_WAIT_FINISH;
                        return;
                    }
                    if (LibrGetter.config.lock) {
                        class_634 handler = client.method_1562();
                        if (handler == null) {
                            Worker.error("librgetter.internal", "handler3");
                            return;
                        }
                        lockType = Worker.getLockType(player);
                        state = State.LOCK_TRADES;
                        trades = null;
                        if (!Support.useTradeCycling()) {
                            class_636 class_6362 = client.field_1761;
                            if (class_6362 == null) {
                                Worker.error("librgetter.internal", "manager4");
                                return;
                            }
                            class_6362.method_2905((class_1657)player, (class_1297)villager, class_1268.field_5808);
                        }
                    } else {
                        state = State.STANDBY;
                    }
                    if (LibrGetter.config.removeGoal) {
                        success.forEach(f -> Worker.remove(f.id(), f.lvl()));
                    }
                }
            }
            if (state == State.PARSE_TRADES) {
                state = !Support.useTradeCycling() ? (LibrGetter.config.manual ? State.BREAK_LECTERN : State.SELECT_AXE) : State.TRADECYCLING_CLICK;
            }
        }
        if (state == State.LOCK_TRADES) {
            if (trades == null) {
                return;
            }
            if (offeredEnchantments.isEmpty()) {
                return;
            }
            if (lockType == LockType.CANNOT) {
                Worker.error("librgetter.lock", new String[0]);
                return;
            }
            class_636 manager = client.field_1761;
            if (manager == null) {
                Worker.error("librgetter.internal", "manager5");
                return;
            }
            if (lockType == LockType.BOOK) {
                if (player.field_7512.method_7611((int)0).field_7871.method_5438(0).method_7947() < 1) {
                    int slot = player.method_31548().method_7395(class_1802.field_8529.method_7854());
                    slot = slot < 9 ? (slot += 27) : (slot -= 9);
                    manager.method_2906(player.field_7512.field_7763, slot + 3, 0, class_1713.field_7790, (class_1657)player);
                    manager.method_2906(player.field_7512.field_7763, 0, 0, class_1713.field_7790, (class_1657)player);
                    return;
                }
                if (player.field_7512.method_7611((int)0).field_7871.method_5438(1).method_7947() < offeredEnchantments.get(0).price()) {
                    int slot = player.method_31548().method_7395(class_1802.field_8687.method_7854());
                    slot = slot < 9 ? (slot += 27) : (slot -= 9);
                    manager.method_2906(player.field_7512.field_7763, slot + 3, 0, class_1713.field_7790, (class_1657)player);
                    manager.method_2906(player.field_7512.field_7763, 1, 0, class_1713.field_7790, (class_1657)player);
                    return;
                }
            } else if (lockType == LockType.TRADE) {
                class_1799 item = Minecraft.getFirstBuyItem((class_1914)trades.get(otherTrade));
                if (player.field_7512.method_7611((int)0).field_7871.method_5438(0).method_7947() < item.method_7947()) {
                    int slot = player.method_31548().method_7395(item.method_7909().method_7854());
                    slot = slot < 9 ? (slot += 27) : (slot -= 9);
                    manager.method_2906(player.field_7512.field_7763, slot + 3, 0, class_1713.field_7790, (class_1657)player);
                    manager.method_2906(player.field_7512.field_7763, 0, 0, class_1713.field_7790, (class_1657)player);
                    return;
                }
            }
            manager.method_2906(player.field_7512.field_7763, 2, 0, class_1713.field_7790, (class_1657)player);
            state = State.STANDBY;
            return;
        }
        if (state == State.TRADECYCLING_CLICK) {
            trades = null;
            class_437 s = client.field_1755;
            if (s == null) {
                Worker.stop();
                return;
            }
            Support.sendCycleTradesPacket();
            ++counter;
            state = State.GET_TRADES;
        }
    }

    private static LockType getLockType(class_746 player) {
        int max;
        int emerald = 0;
        int book = 0;
        int paper = 0;
        for (int i = 0; i < 36; ++i) {
            class_1799 stack = player.method_31548().method_5438(i);
            if (stack.method_7909() == class_1802.field_8687) {
                emerald += stack.method_7947();
            }
            if (stack.method_7909() == class_1802.field_8529) {
                book += stack.method_7947();
            }
            if (stack.method_7909() != class_1802.field_8407) continue;
            paper += stack.method_7947();
        }
        if (offeredEnchantments.isEmpty()) {
            max = 0;
            for (Enchantment enchantment : LibrGetter.config.goals) {
                if (enchantment.price() <= max) continue;
                max = enchantment.price();
            }
        } else {
            max = offeredEnchantments.get(0).price();
        }
        if (book == 0 || emerald < max) {
            if (emerald < 9 || paper < 24) {
                return LockType.CANNOT;
            }
            return LockType.TRADE;
        }
        return LockType.BOOK;
    }

    private static void getEnchant() {
        int trade;
        if (trades == null) {
            return;
        }
        offeredEnchantments.clear();
        if (Worker.isEnchant((class_1914)trades.get(0))) {
            trade = 0;
            otherTrade = 1;
        } else if (Worker.isEnchant((class_1914)trades.get(1))) {
            trade = 1;
            otherTrade = 0;
        } else {
            trade = -1;
        }
        if (trade != -1 && !Worker.addEnchant(trades, trade)) {
            return;
        }
        if (LibrGetter.config.matchMode != MatchMode.VANILLA) {
            for (int i = 2; i < trades.size(); ++i) {
                if (!Worker.isEnchant((class_1914)trades.get(i))) continue;
                Worker.addEnchant(trades, i);
            }
        }
    }

    private static boolean isEnchant(class_1914 offer) {
        return offer.method_8250().method_31574(class_1802.field_8598) || offer.method_8250().method_31574(class_1802.field_8529);
    }

    private static boolean addEnchant(class_1916 trades, int trade) {
        Enchantment e;
        Either<Enchantment, String[]> either = Minecraft.parseTrade(trades, trade);
        Optional en = either.left();
        Optional err = either.right();
        if (err.isPresent()) {
            String[] ret = (String[])err.get();
            Object[] args = new String[ret.length - 1];
            System.arraycopy(ret, 1, args, 0, ret.length - 1);
            Texts.sendError(source, ret[0], args);
            state = State.STANDBY;
            return false;
        }
        if (en.isPresent() && !(e = (Enchantment)en.get()).same(Enchantment.EMPTY)) {
            offeredEnchantments.add(e);
        }
        return true;
    }

    private static void prepareRotation(class_746 player, class_243 target, State skip) {
        if (LibrGetter.config.manual || LibrGetter.config.rotationMode == RotationMode.NONE) {
            state = skip;
        } else if (LibrGetter.config.rotationMode == RotationMode.INSTANT) {
            player.method_5702(class_2183.class_2184.field_9851, target);
            state = skip;
        } else if (LibrGetter.config.rotationMode == RotationMode.SMOOTH) {
            class_243 vec3d = class_2183.class_2184.field_9851.method_9302((class_1297)player);
            double d = target.method_10216() + (double)((rng.nextFloat() - 0.5f) * 0.4f) - vec3d.field_1352;
            double e = target.method_10214() + (double)((rng.nextFloat() - 0.5f) * 0.4f) - vec3d.field_1351;
            double f = target.method_10215() + (double)((rng.nextFloat() - 0.5f) * 0.4f) - vec3d.field_1350;
            goalPos = new class_243(d, e, f);
            state = State.ROTATION;
            nextState = skip;
        }
    }

    public static void start(boolean resetCounter) {
        if (state != State.STANDBY) {
            Texts.sendError(source, "librgetter.running", new Object[0]);
            return;
        }
        if (block == null) {
            Texts.sendError(source, "librgetter.no_lectern", new Object[0]);
            return;
        }
        if (villager == null) {
            Texts.sendError(source, "librgetter.no_librarian", new Object[0]);
            return;
        }
        if (LibrGetter.config.goals.isEmpty()) {
            Texts.sendError(source, "librgetter.goals", new Object[0]);
            return;
        }
        class_310 client = class_310.method_1551();
        class_746 player = client.field_1724;
        if (player == null) {
            Texts.sendError(source, "librgetter.internal", "player");
            return;
        }
        if (LibrGetter.config.safeChecker) {
            List<class_2338> path;
            class_638 world = client.field_1687;
            if (world == null) {
                Texts.sendError(source, "librgetter.internal", "world");
                return;
            }
            if (!villager.method_5765() && (path = PathFinding.findPath(villager.method_24515(), block, world, 2)) != null) {
                Texts.sendError(source, "librgetter.unsafe", new Object[0]);
                return;
            }
        }
        if (!LibrGetter.config.autoTool) {
            defaultAxe = player.method_6047();
        }
        if (LibrGetter.config.lock && Worker.getLockType(player) == LockType.CANNOT) {
            Texts.sendError(source, "librgetter.lock", new Object[0]);
            return;
        }
        Texts.sendFeedback(source, "librgetter.start", class_124.field_1060, new Object[0]);
        if (resetCounter) {
            counter = 0;
        }
        state = State.WAIT_VILLAGER_ACCEPT_PROFESSION;
    }

    public static void add(String name, int level, int price, boolean custom) {
        Enchantment newLooking = new Enchantment(name, level, price);
        Enchantment already = null;
        for (Enchantment l : LibrGetter.config.goals) {
            if (!l.same(newLooking)) continue;
            already = l;
            break;
        }
        if (already != null) {
            Texts.sendFeedback(source, "librgetter.price", class_124.field_1060, already, price);
            LibrGetter.config.goals.remove(already);
        } else {
            Texts.sendFeedback(source, custom ? "libgetter.add_custom" : "libgetter.add", class_124.field_1060, newLooking, newLooking.price());
        }
        LibrGetter.config.goals.add(newLooking);
        LibrGetter.config.save();
    }

    public static void remove(String name, int level) {
        Enchantment newLooking = new Enchantment(name, level, 64);
        Enchantment already = null;
        for (Enchantment l : LibrGetter.config.goals) {
            if (!l.same(newLooking)) continue;
            already = l;
            break;
        }
        if (already == null) {
            Texts.sendError(source, "librgetter.not", newLooking);
            return;
        }
        LibrGetter.config.goals.remove(already);
        LibrGetter.config.save();
        Texts.sendFeedback(source, "librgetter.removed", class_124.field_1054, newLooking);
    }

    public static void clear() {
        LibrGetter.config.goals.clear();
        LibrGetter.config.save();
        Texts.sendFeedback(source, "librgetter.cleared", class_124.field_1054, new Object[0]);
    }

    public static void stop() {
        if (state == State.STANDBY) {
            Texts.sendError(source, "librgetter.not_running", new Object[0]);
            return;
        }
        Texts.sendFeedback(source, "librgetter.stop", class_124.field_1054, new Object[0]);
        state = State.STANDBY;
    }

    public static void setBlock(@Nullable class_2338 newBlock) {
        block = newBlock;
    }

    @Nullable
    public static class_2338 getBlock() {
        return block;
    }

    public static void setTrades(@Nullable class_1916 newTrades) {
        trades = newTrades;
    }

    public static void setVillager(@Nullable class_1646 newVillager) {
        villager = newVillager;
    }

    public static void setSource(Object newSource) {
        source = newSource;
    }

    public static Object getSource() {
        return source;
    }

    public static void noRefresh() {
        Texts.sendError(source, "librgetter.update", new Object[0]);
        state = State.STANDBY;
    }

    static {
        state = State.STANDBY;
        offeredEnchantments = new ArrayList<Enchantment>();
        otherTrade = 0;
        timeout = 0;
        goalPos = null;
        nextState = null;
        rng = new Random();
        ClientPlayConnectionEvents.JOIN.register((h, s, c) -> {
            state = State.STANDBY;
            block = null;
            villager = null;
        });
        ClientPlayConnectionEvents.DISCONNECT.register((h, c) -> {
            state = State.STANDBY;
            block = null;
            villager = null;
        });
    }

    public static enum State {
        STANDBY,
        SELECT_AXE,
        BREAK_LECTERN,
        WAIT_VILLAGER_LOSE_PROFESSION,
        SELECT_LECTERN_AND_PLACE,
        WAIT_VILLAGER_ACCEPT_PROFESSION,
        GET_TRADES,
        PARSE_TRADES,
        LOCK_TRADES,
        MANUAL_WAIT_FINISH,
        ROTATION,
        TRADECYCLING_CLICK;

    }

    private static enum LockType {
        CANNOT,
        BOOK,
        TRADE;

    }
}

