/*
 * Decompiled with CFR 0.152.
 */
package dev.gxlg.librgetter.utils.reflection;

import dev.gxlg.librgetter.Config;
import dev.gxlg.librgetter.LibrGetter;
import dev.gxlg.librgetter.Reflection;
import dev.gxlg.librgetter.utils.reflection.Texts;
import dev.gxlg.librgetter.utils.types.config.helpers.Configurable;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_3872;
import net.minecraft.class_5348;

public class ConfigMenu {
    public static final int CONFIGS_PER_PAGE = 4;
    public static final int pageCount;
    private static final List<Object> list;
    private static final Map<String, Integer> categories;

    public static class_3872.class_3931 getContent() {
        if (list.isEmpty()) {
            for (int i = 0; i < pageCount; ++i) {
                list.add(null);
                ConfigMenu.updatePage(i);
            }
        }
        if (Reflection.getVersion().higher("1.20.5") || Reflection.getVersion().equals("1.20.5")) {
            return (class_3872.class_3931)Reflection.constructTyped(class_3872.class_3931.class, new Object[]{list}, List.class);
        }
        return (class_3872.class_3931)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{class_3872.class_3931.class}, (proxy, method, args) -> {
            String name = method.getName();
            if (name.equals("method_17560") || name.equals("getPageCount")) {
                return pageCount;
            }
            if (name.equals("method_17563") || name.equals("getPage")) {
                Integer index = (Integer)args[0];
                if (index < 0 || index >= pageCount) {
                    return class_5348.field_25310;
                }
                return list.get(index);
            }
            return method.invoke(proxy, args);
        });
    }

    public static void updatePage(int index) {
        Object text;
        if (index == 0) {
            text = Texts.bookMainPage(categories);
        } else {
            ArrayList<String> reversed = new ArrayList<String>(Config.CATEGORIES);
            Collections.reverse(reversed);
            String category = reversed.stream().filter(c -> categories.get(c) <= index).findFirst().orElseThrow(() -> new RuntimeException("Invalid index " + index));
            text = Texts.bookTitle(category);
            int j = index - categories.get(category);
            int finish = Math.min(j * 4 + 4, LibrGetter.config.getConfigurablesForCategory(category).size());
            for (int i = j * 4; i < finish; ++i) {
                Configurable<?> config = LibrGetter.config.getConfigurablesForCategory(category).get(i);
                text = Texts.bookEntry(text, config);
            }
        }
        list.set(index, text);
    }

    static {
        list = new ArrayList<Object>();
        categories = new HashMap<String, Integer>();
        int pages = 1;
        for (String cat : Config.CATEGORIES) {
            categories.put(cat, pages);
            pages = (int)((double)pages + Math.ceil((float)LibrGetter.config.getConfigurablesForCategory(cat).size() / 4.0f));
        }
        pageCount = pages;
    }
}

