/*
 * Decompiled with CFR 0.152.
 */
package dev.gxlg.librgetter.utils.types.config.helpers;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import dev.gxlg.librgetter.Config;
import dev.gxlg.librgetter.utils.reflection.Support;
import dev.gxlg.librgetter.utils.types.config.Compatibility;
import dev.gxlg.librgetter.utils.types.config.IntRange;
import dev.gxlg.librgetter.utils.types.config.OnlyEffective;
import dev.gxlg.librgetter.utils.types.config.OptionsConfig;
import java.lang.reflect.Field;
import java.util.Arrays;

public record Configurable<T>(String name, Class<T> type, Config instance) {
    public T get() {
        try {
            Field f = Config.class.getField(this.name);
            T t = this.type.cast(f.get(this.instance));
            if (t != null) {
                return t;
            }
            return this.getDefault();
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public void set(T value) {
        try {
            Field f = Config.class.getField(this.name);
            f.set(this.instance, value);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public T getDefault() {
        return this.type.cast(Config.DEFAULT.getConfigurableForName(this.name).get());
    }

    public ArgumentType<?> argument() {
        Field f;
        try {
            f = Config.class.getField(this.name);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        if (this.type == Boolean.class) {
            return BoolArgumentType.bool();
        }
        if (this.type == Integer.class) {
            IntRange a = f.getDeclaredAnnotation(IntRange.class);
            if (a == null) {
                return IntegerArgumentType.integer();
            }
            return IntegerArgumentType.integer((int)a.min(), (int)a.max());
        }
        if (this.type == OptionsConfig.class) {
            return ((OptionsConfig)this.get()).argumentType();
        }
        throw new RuntimeException("This field does not support ArgumentTypes");
    }

    public boolean inRange(int i) {
        Field f;
        if (this.type != Integer.class) {
            throw new RuntimeException("The field of type '" + this.type.getName() + "' does not support the inRange(int) method");
        }
        try {
            f = Config.class.getField(this.name);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        IntRange a = f.getDeclaredAnnotation(IntRange.class);
        if (a == null) {
            return true;
        }
        return a.min() <= i && i <= a.max();
    }

    public boolean hasEffect() {
        Field f;
        try {
            f = Config.class.getField(this.name);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        for (OnlyEffective oe : (OnlyEffective[])f.getAnnotationsByType(OnlyEffective.class)) {
            Configurable<?> conf = this.instance.getConfigurableForName(oe.when());
            String current = conf.type() == OptionsConfig.class ? ((OptionsConfig)conf.get()).method_15434() : conf.get().toString();
            if (Arrays.asList(oe.equals()).contains(current)) continue;
            return false;
        }
        Compatibility c = f.getDeclaredAnnotation(Compatibility.class);
        return c == null || Support.isEffective(c.value());
    }

    public boolean isDefault() {
        return this.get().equals(this.getDefault());
    }
}

