/*
 * Decompiled with CFR 0.152.
 */
package dev.gxlg.librgetter.utils.types.config.helpers;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_3542;

public class EnumArgumentType<T extends Enum<T>>
implements ArgumentType<T> {
    private static final DynamicCommandExceptionType INVALID_ENUM_EXCEPTION = new DynamicCommandExceptionType(value -> class_2561.method_30163((String)"Invalid enum value"));
    private final Supplier<T[]> valuesSupplier;

    protected EnumArgumentType(Supplier<T[]> valuesSupplier) {
        this.valuesSupplier = valuesSupplier;
    }

    public static <S extends Enum<S>> EnumArgumentType<S> of(Supplier<S[]> valuesSupplier) {
        return new EnumArgumentType(valuesSupplier);
    }

    public T parse(StringReader stringReader) throws CommandSyntaxException {
        String string = stringReader.readUnquotedString();
        return (T)Arrays.stream((Enum[])this.valuesSupplier.get()).filter(t -> t.name().equals(string)).findFirst().orElseThrow(() -> INVALID_ENUM_EXCEPTION.createWithContext((ImmutableStringReader)stringReader, (Object)string));
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return class_2172.method_9265((Iterable)Arrays.stream((Enum[])this.valuesSupplier.get()).map(rec$ -> ((class_3542)rec$).method_15434()).collect(Collectors.toList()), (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return Arrays.stream((Enum[])this.valuesSupplier.get()).map(rec$ -> ((class_3542)rec$).method_15434()).limit(2L).collect(Collectors.toList());
    }
}

