/*
 * Decompiled with CFR 0.152.
 */
package dev.gxlg.librgetter;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import dev.gxlg.librgetter.LibrGetter;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;

public class Config {
    public boolean notify = false;
    public boolean autoTool = true;
    public boolean actionBar = false;
    public boolean lock = false;
    public boolean removeGoal = false;
    public boolean checkUpdate = true;
    public boolean warning = true;
    public boolean offhand = false;
    public boolean manual = false;
    public boolean waitLose = false;
    public boolean safeChecker = true;
    public boolean fallback = false;
    public boolean look = true;
    public boolean rotation = false;
    public boolean _tradeCycling = false;
    @IntRange(min=0, max=20)
    public int timeout = 0;
    public List<Enchantment> goals = new ArrayList<Enchantment>();
    private static final Path configPath = FabricLoader.getInstance().getConfigDir().resolve("librgetter.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final List<Configurable<?>> configurable = new ArrayList();

    public static Config init() {
        Config config;
        if (Files.notExists(configPath, new LinkOption[0])) {
            try {
                Files.createFile(configPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not initialize config", e);
            }
            config = new Config();
        } else {
            try (FileReader reader = new FileReader(configPath.toFile());){
                config = (Config)GSON.fromJson((Reader)reader, Config.class);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not parse config", e);
            }
        }
        config.save();
        return config;
    }

    public void save() {
        Path dir = configPath.getParent();
        try {
            if (Files.notExists(dir, new LinkOption[0])) {
                Files.createDirectory(dir, new FileAttribute[0]);
            } else if (!Files.isDirectory(dir, new LinkOption[0])) {
                throw new IOException("Not a directory: " + String.valueOf(dir));
            }
            Path tempPath = configPath.resolveSibling(String.valueOf(configPath.getFileName()) + ".tmp");
            Files.createFile(tempPath, new FileAttribute[0]);
            Files.write(tempPath, GSON.toJson((Object)this).getBytes(), StandardOpenOption.WRITE);
            Files.move(tempPath, configPath, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not save config", e);
        }
    }

    public static List<Configurable<?>> getConfigurables() {
        return configurable;
    }

    static {
        ArrayList<Configurable> normal = new ArrayList<Configurable>();
        ArrayList<Configurable> compat = new ArrayList<Configurable>();
        for (Field f : Config.class.getFields()) {
            ArrayList<Configurable> candidate;
            ArrayList<Configurable> arrayList = candidate = f.getName().startsWith("_") ? compat : normal;
            if (f.getType() == Boolean.TYPE) {
                candidate.add(new Configurable<Boolean>(f.getName(), Boolean.class));
            }
            if (f.getType() != Integer.TYPE) continue;
            candidate.add(new Configurable<Integer>(f.getName(), Integer.class));
        }
        normal.sort(Comparator.comparing(Configurable::name));
        compat.sort(Comparator.comparing(Configurable::name));
        configurable.addAll(normal);
        configurable.addAll(compat);
    }

    public record Configurable<T>(String name, Class<T> type) {
        public T get() {
            try {
                Field f = Config.class.getField(this.name);
                return this.type.cast(f.get(LibrGetter.config));
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }

        public void set(T value) {
            try {
                Field f = Config.class.getField(this.name);
                f.set(LibrGetter.config, value);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }

        public ArgumentType<?> argument() {
            Field f;
            try {
                f = Config.class.getField(this.name);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
            if (this.type == Boolean.class) {
                return BoolArgumentType.bool();
            }
            if (this.type == Integer.class) {
                IntRange a = f.getDeclaredAnnotation(IntRange.class);
                if (a == null) {
                    return IntegerArgumentType.integer();
                }
                return IntegerArgumentType.integer((int)a.min(), (int)a.max());
            }
            throw new RuntimeException("This field does not support ArgumentTypes");
        }

        public boolean inRange(int i) {
            Field f;
            if (this.type != Integer.class) {
                throw new RuntimeException("The field of type '" + this.type.getName() + "' does not support the inRange(int) method");
            }
            try {
                f = Config.class.getField(this.name);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
            IntRange a = f.getDeclaredAnnotation(IntRange.class);
            if (a == null) {
                return true;
            }
            return a.min() <= i && i <= a.max();
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface IntRange {
        public int min() default -2147483648;

        public int max() default 0x7FFFFFFF;
    }

    public static class Enchantment {
        public static final Enchantment EMPTY = new Enchantment("", -1, 0);
        public final String id;
        public final int lvl;
        public int price;

        public Enchantment(String id, int lvl, int price) {
            this.id = id;
            this.lvl = lvl;
            this.price = price;
        }

        public boolean meets(Enchantment e) {
            return e.id.equals(this.id) && e.lvl == this.lvl && e.price <= this.price;
        }

        public boolean same(Enchantment e) {
            return e.id.equals(this.id) && e.lvl == this.lvl;
        }

        public String toString() {
            return this.id + " " + this.lvl;
        }
    }
}

