/*
 * Decompiled with CFR 0.152.
 */
package dev.gxlg.librgetter.command;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.datafixers.util.Either;
import dev.gxlg.librgetter.Config;
import dev.gxlg.librgetter.LibrGetter;
import dev.gxlg.librgetter.Worker;
import dev.gxlg.librgetter.utils.reflection.Commands;
import dev.gxlg.librgetter.utils.reflection.Minecraft;
import dev.gxlg.librgetter.utils.reflection.Texts;
import java.util.ArrayList;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1646;
import net.minecraft.class_1887;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_638;
import net.minecraft.class_746;

public class LibrGetCommand {
    public static int remove(CommandContext<?> context) {
        return LibrGetCommand.enchanter(context, true);
    }

    public static int add(CommandContext<?> context) {
        return LibrGetCommand.enchanter(context, false);
    }

    public static int list(CommandContext<?> context) {
        Texts.list(context.getSource());
        return 0;
    }

    public static <T> int config(CommandContext<?> context, Config.Configurable<T> config) {
        Object value = config.get();
        try {
            value = context.getArgument("value", config.type());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Texts.sendFeedback(context.getSource(), "librgetter.config", null, config.name(), value);
        config.set(value);
        LibrGetter.config.save();
        return 0;
    }

    public static int autostart(CommandContext<?> context) {
        class_310 client = class_310.method_1551();
        class_746 player = client.field_1724;
        if (player == null) {
            Texts.sendError(context.getSource(), "librgetter.internal", "player");
            return 1;
        }
        class_638 world = client.field_1687;
        if (world == null) {
            Texts.sendError(context.getSource(), "librgetter.internal", "world");
            return 1;
        }
        class_2338 lec = null;
        for (int dis = 1; dis < 5; ++dis) {
            for (int dx = -dis; dx <= dis; ++dx) {
                for (int dy = -dis; dy <= dis; ++dy) {
                    for (int dz = -dis; dz <= dis; ++dz) {
                        class_2338 pos;
                        if (dis != Math.abs(dx) && dis != Math.abs(dy) && dis != Math.abs(dz) || !world.method_8320(pos = player.method_24515().method_10069(dx, dy, dz)).method_27852(class_2246.field_16330)) continue;
                        lec = pos;
                        break;
                    }
                    if (lec != null) break;
                }
                if (lec != null) break;
            }
            if (lec != null) break;
        }
        if (lec == null) {
            Texts.sendError(context.getSource(), "librgetter.find_lectern", new Object[0]);
            return 1;
        }
        Iterable all = world.method_18112();
        class_1646 vi = null;
        float d = Float.MAX_VALUE;
        for (class_1297 e : all) {
            float dd;
            class_1646 v;
            if (!(e instanceof class_1646) || !Minecraft.isVillagerLibrarian(v = (class_1646)e) || !((dd = v.method_5739((class_1297)player)) < d) || !(dd < 10.0f)) continue;
            vi = v;
            d = dd;
        }
        if (vi == null) {
            Texts.sendError(context.getSource(), "librgetter.find_librarian", new Object[0]);
            return 1;
        }
        Worker.setSource(context.getSource());
        Worker.setBlock(lec);
        Worker.setVillager(vi);
        Worker.start();
        return 0;
    }

    private static int enchanter(CommandContext<?> context, boolean remove) {
        ArrayList<Either<class_1887, String>> list = new ArrayList<Either<class_1887, String>>();
        if (!Commands.getEnchantments(list, context)) {
            return 1;
        }
        int lvl = -1;
        try {
            lvl = (Integer)context.getArgument("level", Integer.class);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        int price = 64;
        try {
            price = (Integer)context.getArgument("maxprice", Integer.class);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        for (Either either : list) {
            if (either.left().isPresent()) {
                class_1887 enchantment = (class_1887)either.left().get();
                class_2960 id = Minecraft.enchantmentId(enchantment);
                if (lvl > enchantment.method_8183() && LibrGetter.config.warning) {
                    Texts.sendFeedback(context.getSource(), "librgetter.level", class_124.field_1054, id, enchantment.method_8183());
                }
                int level = lvl;
                if (lvl == -1) {
                    level = enchantment.method_8183();
                }
                if (!Minecraft.canBeTraded(enchantment) && LibrGetter.config.warning) {
                    Texts.sendFeedback(context.getSource(), "librgetter.notrade", class_124.field_1054, id);
                }
                if (id == null) {
                    Texts.sendError(context.getSource(), "librgetter.internal", "id");
                    return 1;
                }
                Worker.setSource(context.getSource());
                if (remove) {
                    Worker.remove(id.toString(), level);
                    continue;
                }
                Worker.add(id.toString(), level, price, false);
                continue;
            }
            if (!either.right().isPresent()) continue;
            String custom = (String)either.right().get();
            class_2960 enchantment = class_2960.method_12829((String)custom);
            if (enchantment == null) {
                Texts.sendError(context.getSource(), "librgetter.parse", new Object[0]);
                return 1;
            }
            if (!remove && LibrGetter.config.warning) {
                Texts.sendFeedback(context.getSource(), "librgetter.custom", class_124.field_1054, enchantment);
            }
            Worker.setSource(context.getSource());
            if (remove) {
                Worker.remove(enchantment.toString(), lvl);
                continue;
            }
            Worker.add(enchantment.toString(), lvl, price, true);
        }
        return 0;
    }

    public static int clear(CommandContext<?> context) {
        Worker.setSource(context.getSource());
        Worker.clear();
        return 0;
    }

    public static int stop(CommandContext<?> context) {
        Worker.setSource(context.getSource());
        Worker.stop();
        return 0;
    }

    public static int start(CommandContext<?> context) {
        Worker.setSource(context.getSource());
        Worker.start();
        return 0;
    }

    public static int selector(CommandContext<?> context) {
        Worker.setSource(context.getSource());
        if (Worker.getState() != Worker.State.STANDBY) {
            Texts.sendError(context.getSource(), "librgetter.running", new Object[0]);
            return 1;
        }
        class_310 client = class_310.method_1551();
        class_638 world = client.field_1687;
        if (world == null) {
            Texts.sendError(context.getSource(), "librgetter.internal", "world");
            return 1;
        }
        class_746 player = client.field_1724;
        if (player == null) {
            Texts.sendError(context.getSource(), "librgetter.internal", "player");
            return 1;
        }
        class_239 hit = client.field_1765;
        if (hit == null) {
            Texts.sendError(context.getSource(), "librgetter.internal", "hit");
            return 1;
        }
        class_239.class_240 hitType = hit.method_17783();
        if (hitType == class_239.class_240.field_1333) {
            Texts.sendError(context.getSource(), "librgetter.nothing", new Object[0]);
            return 1;
        }
        if (hitType == class_239.class_240.field_1332) {
            class_2338 blockPos = ((class_3965)hit).method_17777();
            if (!world.method_8320(blockPos).method_27852(class_2246.field_16330)) {
                Texts.sendError(context.getSource(), "librgetter.not_lectern", new Object[0]);
                return 1;
            }
            Worker.setBlock(blockPos);
            Texts.sendFeedback(context.getSource(), "librgetter.lectern", null, new Object[0]);
        } else if (hitType == class_239.class_240.field_1331) {
            class_3966 entityHitResult = (class_3966)hit;
            class_1297 entity = entityHitResult.method_17782();
            if (!(entity instanceof class_1646)) {
                Texts.sendError(context.getSource(), "librgetter.not_villager", new Object[0]);
                return 1;
            }
            class_1646 villager = (class_1646)entity;
            if (!Minecraft.isVillagerLibrarian(villager)) {
                Texts.sendError(context.getSource(), "librgetter.not_librarian", new Object[0]);
                return 1;
            }
            Texts.sendFeedback(context.getSource(), "librgetter.librarian", null, new Object[0]);
            Worker.setVillager(villager);
        }
        return 0;
    }
}

