/*
 * Decompiled with CFR 0.152.
 */
package dev.gxlg.librgetter.utils.reflection;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.datafixers.util.Either;
import dev.gxlg.librgetter.Config;
import dev.gxlg.librgetter.Reflection;
import dev.gxlg.librgetter.command.LibrGetCommand;
import dev.gxlg.librgetter.utils.reflection.Texts;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.class_1887;

public class Commands {
    public static boolean getEnchantments(List<Either<class_1887, String>> list, CommandContext<?> context) {
        if (Reflection.getVersion().higher("1.19.3") || Reflection.getVersion().equals("1.19.3")) {
            Object argument;
            Class<?> pred = Reflection.clazz("net.minecraft.class_7737$class_7741", "net.minecraft.command.argument.RegistryEntryPredicateArgumentType$EntryPredicate");
            try {
                argument = pred.cast(context.getArgument("enchantment", pred));
            }
            catch (IllegalArgumentException ignored) {
                list.add((Either<class_1887, String>)Either.right((Object)((String)context.getArgument("enchantment_custom", String.class))));
                return true;
            }
            Object key = Reflection.getVersion().higher("1.21") || Reflection.getVersion().equals("1.21") ? Reflection.getField(Reflection.clazz("net.minecraft.class_7924", "net.minecraft.registry.RegistryKeys"), null, "field_41265", "ENCHANTMENT") : Reflection.invokeMethodTyped(Reflection.clazz("net.minecraft.class_2378", "net.minecraft.registry.Registry"), Reflection.getField(Reflection.clazz("net.minecraft.class_7923", "net.minecraft.registry.Registries"), null, "field_41176", "ENCHANTMENT"), new Object[0], new Class[0], "method_30517", "getKey");
            Optional opt = (Optional)Reflection.invokeMethodTyped(pred, argument, new Object[]{key}, new Class[]{Reflection.clazz("net.minecraft.class_5321", "net.minecraft.registry.RegistryKey")}, "method_45648", "tryCast");
            if (opt.isEmpty()) {
                Texts.sendError(context, "librgetter.argument", new Object[0]);
                return false;
            }
            Object predicate = opt.get();
            Either entry = (Either)Reflection.invokeMethodTyped(pred, predicate, new Object[0], new Class[0], "method_45647", "getEntry");
            Optional optrefl = entry.left();
            Optional optrefr = entry.right();
            Class<?> entryClass = Reflection.clazz("net.minecraft.class_6880$class_6883", "net.minecraft.registry.entry.RegistryEntry$Reference");
            if (optrefl.isEmpty()) {
                if (optrefr.isEmpty()) {
                    Texts.sendError(context, "librgetter.wrong", new Object[0]);
                    return false;
                }
                Stream stream = (Stream)Reflection.invokeMethodTyped(Reflection.clazz("net.minecraft.class_6885$class_6888", "net.minecraft.registry.entry.RegistryEntryList$Named"), optrefr.get(), new Object[0], new Class[0], "method_40239", "stream");
                stream.forEach(ref -> list.add(Either.left((Object)((class_1887)Reflection.invokeMethodTyped(entryClass, ref, new Object[0], new Class[0], "comp_349", "value")))));
            } else {
                class_1887 enchantment = (class_1887)Reflection.invokeMethodTyped(entryClass, optrefl.get(), new Object[0], new Class[0], "comp_349", "value");
                list.add((Either<class_1887, String>)Either.left((Object)enchantment));
            }
        } else {
            try {
                class_1887 enchantment = (class_1887)context.getArgument("enchantment", class_1887.class);
                list.add((Either<class_1887, String>)Either.left((Object)enchantment));
            }
            catch (IllegalArgumentException ignored) {
                list.add((Either<class_1887, String>)Either.right((Object)((String)context.getArgument("enchantment_custom", String.class))));
            }
        }
        return true;
    }

    private static ArgumentType<?> enchantmentArgument(Object registryAccess) {
        if (Reflection.getVersion().higher("1.19.3") || Reflection.getVersion().equals("1.19.3")) {
            Object key = Reflection.getVersion().higher("1.21") || Reflection.getVersion().equals("1.21") ? Reflection.getField(Reflection.clazz("net.minecraft.class_7924", "net.minecraft.registry.RegistryKeys"), null, "field_41265", "ENCHANTMENT") : Reflection.invokeMethodTyped(Reflection.clazz("net.minecraft.class_2378", "net.minecraft.registry.Registry"), Reflection.getField(Reflection.clazz("net.minecraft.class_7923", "net.minecraft.registry.Registries"), null, "field_41176", "ENCHANTMENT"), new Object[0], new Class[0], "method_30517", "getKey");
            return (ArgumentType)Reflection.invokeMethodTyped(Reflection.clazz("net.minecraft.class_7737", "net.minecraft.command.argument.RegistryEntryPredicateArgumentType"), null, new Object[]{registryAccess, key}, new Class[]{Reflection.clazz("net.minecraft.class_7157", "net.minecraft.command.CommandRegistryAccess"), Reflection.clazz("net.minecraft.class_5321", "net.minecraft.registry.RegistryKey")}, "method_45637", "registryEntryPredicate");
        }
        return (ArgumentType)Reflection.invokeMethodTyped(Reflection.clazz("net.minecraft.class_2194", "net.minecraft.command.argument.EnchantmentArgumentType", "net.minecraft.command.argument.ItemEnchantmentArgumentType"), null, new Object[0], new Class[0], "method_9336", "enchantment", "itemEnchantment");
    }

    public static void registerCommand() {
        if (Reflection.getVersion().higher("1.19") || Reflection.getVersion().equals("1.19")) {
            Class<?> cb = Reflection.clazz("net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback");
            Class<?> cra = Reflection.clazz("net.minecraft.class_7157", "net.minecraft.command.CommandRegistryAccess");
            Class<?> ccm = Reflection.clazz("net.fabricmc.fabric.api.client.command.v2.ClientCommandManager");
            Object listener = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{cb}, (proxy, method, args) -> {
                if (method.getName().equals("register")) {
                    Object registryAccess = cra.cast(args[1]);
                    Commands.command(ccm, (CommandDispatcher)args[0], registryAccess);
                    return null;
                }
                return method.invoke(proxy, args);
            });
            Reflection.invokeMethodTyped(Reflection.clazz("net.fabricmc.fabric.api.event.Event"), Reflection.getField(cb, null, "EVENT"), new Object[]{listener}, new Class[]{Object.class}, "register");
        } else {
            Class<?> ccm = Reflection.clazz("net.fabricmc.fabric.api.client.command.v1.ClientCommandManager");
            Commands.command(ccm, (CommandDispatcher)Reflection.getField(ccm, null, "DISPATCHER"), null);
        }
    }

    private static ArgumentBuilder<?, ?> literal(Class<?> ccm, String command) {
        return (ArgumentBuilder)Reflection.invokeMethodTypeless(ccm, null, new Object[]{command}, "literal");
    }

    private static ArgumentBuilder<?, ?> argument(Class<?> ccm, String command, ArgumentType<?> argumentType) {
        return (ArgumentBuilder)Reflection.invokeMethodTyped(ccm, null, new Object[]{command, argumentType}, new Class[]{String.class, ArgumentType.class}, "argument");
    }

    private static <T> Command<T> runner(Function<CommandContext<T>, Integer> function) {
        return function::apply;
    }

    private static <T, U> Command<T> runner(BiFunction<CommandContext<T>, Config.Configurable<U>, Integer> function, Config.Configurable<U> config) {
        return t -> (Integer)function.apply(t, config);
    }

    public static void command(Class<?> ccm, CommandDispatcher<?> dispatcher, Object registryAccess) {
        Object base = Commands.literal(ccm, "librget");
        Command add = Commands.runner(LibrGetCommand::add);
        Object l = Commands.literal(ccm, "add");
        Object a = Commands.argument(ccm, "enchantment", Commands.enchantmentArgument(registryAccess));
        a = Reflection.invokeMethodTyped(ArgumentBuilder.class, a, new Object[]{add}, new Class[]{Command.class}, "executes");
        Object r = Commands.argument(ccm, "level", IntegerArgumentType.integer((int)1));
        r = Reflection.invokeMethodTyped(ArgumentBuilder.class, r, new Object[]{add}, new Class[]{Command.class}, "executes");
        Object d = Commands.argument(ccm, "maxprice", IntegerArgumentType.integer((int)1, (int)64));
        d = Reflection.invokeMethodTyped(ArgumentBuilder.class, d, new Object[]{add}, new Class[]{Command.class}, "executes");
        r = Reflection.invokeMethodTyped(ArgumentBuilder.class, r, new Object[]{d}, new Class[]{ArgumentBuilder.class}, "then");
        a = Reflection.invokeMethodTyped(ArgumentBuilder.class, a, new Object[]{r}, new Class[]{ArgumentBuilder.class}, "then");
        l = Reflection.invokeMethodTyped(ArgumentBuilder.class, l, new Object[]{a}, new Class[]{ArgumentBuilder.class}, "then");
        a = Commands.argument(ccm, "enchantment_custom", StringArgumentType.string());
        r = Commands.argument(ccm, "level", IntegerArgumentType.integer((int)1));
        r = Reflection.invokeMethodTyped(ArgumentBuilder.class, r, new Object[]{add}, new Class[]{Command.class}, "executes");
        d = Commands.argument(ccm, "maxprice", IntegerArgumentType.integer((int)1, (int)64));
        d = Reflection.invokeMethodTyped(ArgumentBuilder.class, d, new Object[]{add}, new Class[]{Command.class}, "executes");
        r = Reflection.invokeMethodTyped(ArgumentBuilder.class, r, new Object[]{d}, new Class[]{ArgumentBuilder.class}, "then");
        a = Reflection.invokeMethodTyped(ArgumentBuilder.class, a, new Object[]{r}, new Class[]{ArgumentBuilder.class}, "then");
        l = Reflection.invokeMethodTyped(ArgumentBuilder.class, l, new Object[]{a}, new Class[]{ArgumentBuilder.class}, "then");
        base = Reflection.invokeMethodTyped(ArgumentBuilder.class, base, new Object[]{l}, new Class[]{ArgumentBuilder.class}, "then");
        Command remove = Commands.runner(LibrGetCommand::remove);
        l = Commands.literal(ccm, "remove");
        a = Commands.argument(ccm, "enchantment", Commands.enchantmentArgument(registryAccess));
        r = Commands.argument(ccm, "level", IntegerArgumentType.integer((int)1));
        r = Reflection.invokeMethodTyped(ArgumentBuilder.class, r, new Object[]{remove}, new Class[]{Command.class}, "executes");
        a = Reflection.invokeMethodTyped(ArgumentBuilder.class, a, new Object[]{r}, new Class[]{ArgumentBuilder.class}, "then");
        l = Reflection.invokeMethodTyped(ArgumentBuilder.class, l, new Object[]{a}, new Class[]{ArgumentBuilder.class}, "then");
        a = Commands.argument(ccm, "enchantment_custom", StringArgumentType.string());
        r = Commands.argument(ccm, "level", IntegerArgumentType.integer((int)1));
        r = Reflection.invokeMethodTyped(ArgumentBuilder.class, r, new Object[]{remove}, new Class[]{Command.class}, "executes");
        a = Reflection.invokeMethodTyped(ArgumentBuilder.class, a, new Object[]{r}, new Class[]{ArgumentBuilder.class}, "then");
        l = Reflection.invokeMethodTyped(ArgumentBuilder.class, l, new Object[]{a}, new Class[]{ArgumentBuilder.class}, "then");
        base = Reflection.invokeMethodTyped(ArgumentBuilder.class, base, new Object[]{l}, new Class[]{ArgumentBuilder.class}, "then");
        l = Commands.literal(ccm, "clear").executes(LibrGetCommand::clear);
        base = Reflection.invokeMethodTyped(ArgumentBuilder.class, base, new Object[]{l}, new Class[]{ArgumentBuilder.class}, "then");
        l = Commands.literal(ccm, "list").executes(LibrGetCommand::list);
        base = Reflection.invokeMethodTyped(ArgumentBuilder.class, base, new Object[]{l}, new Class[]{ArgumentBuilder.class}, "then");
        l = Commands.literal(ccm, "stop").executes(LibrGetCommand::stop);
        base = Reflection.invokeMethodTyped(ArgumentBuilder.class, base, new Object[]{l}, new Class[]{ArgumentBuilder.class}, "then");
        l = Commands.literal(ccm, "start").executes(LibrGetCommand::start);
        base = Reflection.invokeMethodTyped(ArgumentBuilder.class, base, new Object[]{l}, new Class[]{ArgumentBuilder.class}, "then");
        l = Commands.literal(ccm, "auto").executes(LibrGetCommand::autostart);
        base = Reflection.invokeMethodTyped(ArgumentBuilder.class, base, new Object[]{l}, new Class[]{ArgumentBuilder.class}, "then");
        l = Commands.literal(ccm, "config");
        for (Config.Configurable configurable : Config.getConfigurables()) {
            String name = configurable.name();
            a = Commands.literal(ccm, name);
            r = Commands.argument(ccm, "value", configurable.argument());
            Command runner = Commands.runner(LibrGetCommand::config, configurable);
            r = Reflection.invokeMethodTyped(ArgumentBuilder.class, r, new Object[]{runner}, new Class[]{Command.class}, "executes");
            a = Reflection.invokeMethodTyped(ArgumentBuilder.class, a, new Object[]{r}, new Class[]{ArgumentBuilder.class}, "then");
            a = Reflection.invokeMethodTyped(ArgumentBuilder.class, a, new Object[]{runner}, new Class[]{Command.class}, "executes");
            l = Reflection.invokeMethodTyped(ArgumentBuilder.class, l, new Object[]{a}, new Class[]{ArgumentBuilder.class}, "then");
        }
        base = Reflection.invokeMethodTyped(ArgumentBuilder.class, base, new Object[]{l}, new Class[]{ArgumentBuilder.class}, "then");
        Command selector = Commands.runner(LibrGetCommand::selector);
        base = Reflection.invokeMethodTyped(ArgumentBuilder.class, base, new Object[]{selector}, new Class[]{Command.class}, "executes");
        Reflection.invokeMethodTypeless(CommandDispatcher.class, dispatcher, new Object[]{base}, "register");
    }
}

