/*
 * Decompiled with CFR 0.152.
 */
package com.gxlg.librgetter;

import com.gxlg.librgetter.Config;
import com.gxlg.librgetter.utils.MultiVersion;
import com.gxlg.librgetter.utils.Updater;
import com.gxlg.librgetter.utils.reflection.Commands;
import com.gxlg.librgetter.utils.reflection.Keybinds;
import java.util.Optional;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LibrGetter
implements ClientModInitializer {
    public static final String MOD_ID = "librgetter";
    public static final Logger LOGGER = LogManager.getLogger((String)"librgetter");
    public static Config config;

    public void onInitializeClient() {
        if (!MultiVersion.isApiLevel(MultiVersion.ApiLevel.BASE)) {
            throw new RuntimeException("This version is not supported by LibrGetter!");
        }
        LOGGER.info("Hello World from LibrGetter! Running on {}", (Object)MultiVersion.getVersion());
        LOGGER.info("Supported MultiVersion APIs: {}", MultiVersion.getAPIList());
        config = Config.init();
        Commands.registerCommand();
        Keybinds.registerKeybinds();
        if (LibrGetter.config.checkUpdate) {
            Updater.checkUpdates();
        }
    }

    public static String getVersion() {
        Optional container = FabricLoader.getInstance().getModContainer(MOD_ID);
        return container.map(modContainer -> "v" + modContainer.getMetadata().getVersion().getFriendlyString()).orElse(null);
    }
}

