/*
 * Decompiled with CFR 0.152.
 */
package com.gxlg.librgetter.utils;

import com.gxlg.librgetter.mixin.AbstractBlockAccessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.PriorityQueue;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;

public class PathFinding {
    private static int manhattan(class_2338 from, class_2338 to) {
        return Math.abs(from.method_10263() - to.method_10263()) + Math.abs(from.method_10264() - to.method_10264()) + Math.abs(from.method_10260() - to.method_10260());
    }

    private static boolean notEnoughHeight(class_2338 pos, class_638 world, int minHeight) {
        for (int i = 0; i < minHeight; ++i) {
            if (!((AbstractBlockAccessor)world.method_8320(pos.method_10086(i)).method_26204()).getCollidable()) continue;
            return true;
        }
        return false;
    }

    private static boolean isAirMove(class_2338 pos, class_638 world, class_2350 dir) {
        if (dir == class_2350.field_11033) {
            return false;
        }
        return !((AbstractBlockAccessor)world.method_8320(pos.method_10074()).method_26204()).getCollidable() && !((AbstractBlockAccessor)world.method_8320(pos.method_10093(dir).method_10074()).method_26204()).getCollidable();
    }

    public static List<class_2338> findPath(class_2338 from, class_2338 to, class_638 world, int minHeight) {
        class_2680 original = world.method_8320(to);
        world.method_8501(to, class_2246.field_10124.method_9564());
        List<class_2338> path = PathFinding.findPathInternal(from, to, world, minHeight);
        world.method_8501(to, original);
        return path;
    }

    private static List<class_2338> findPathInternal(class_2338 from, class_2338 to, class_638 world, int minHeight) {
        if (PathFinding.notEnoughHeight(from, world, minHeight)) {
            return null;
        }
        if (PathFinding.notEnoughHeight(to, world, minHeight)) {
            return null;
        }
        PriorityQueue<Tail> open = new PriorityQueue<Tail>();
        HashSet<class_2338> close = new HashSet<class_2338>();
        open.add(new Tail(0, PathFinding.manhattan(from, to), from, null));
        while (!open.isEmpty()) {
            Tail current = (Tail)open.poll();
            if (current.pos.equals((Object)to)) {
                ArrayList<class_2338> path = new ArrayList<class_2338>();
                Tail tail = current;
                while (current != null) {
                    path.add(tail.pos);
                    current = current.parent;
                }
                Collections.reverse(path);
                return path;
            }
            close.add(current.pos);
            for (class_2350 dir : new class_2350[]{class_2350.field_11043, class_2350.field_11034, class_2350.field_11035, class_2350.field_11039, class_2350.field_11036, class_2350.field_11033}) {
                class_2338 nextpos = current.pos.method_10093(dir);
                if (PathFinding.notEnoughHeight(nextpos, world, minHeight) || PathFinding.isAirMove(nextpos, world, dir) || close.contains(nextpos) || current.gCost > 20) continue;
                Optional<Tail> same = open.stream().filter(t -> t.pos.equals((Object)nextpos)).findFirst();
                same.ifPresent(open::remove);
                Tail next = Tail.construct(current, nextpos, to);
                open.add(next);
            }
        }
        return null;
    }

    private record Tail(int gCost, int hCost, class_2338 pos, Tail parent) implements Comparable<Tail>
    {
        public int getFCost() {
            return this.gCost + this.hCost;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.gCost, this.hCost, this.pos);
        }

        @Override
        public int compareTo(@NotNull Tail tail) {
            return Integer.compare(this.getFCost(), tail.getFCost());
        }

        public static Tail construct(Tail parent, class_2338 pos, class_2338 to) {
            return new Tail(parent.gCost() + 1, PathFinding.manhattan(pos, to), pos, parent);
        }
    }
}

