/*
 * Decompiled with CFR 0.152.
 */
package com.gxlg.librgetter.utils.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;

public class Reflection {
    static Object construct(Class<?> clazz, Object[] args, Class<?> ... params) {
        try {
            Constructor<?> con = clazz.getConstructor(params);
            return con.newInstance(args);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static Method method(Class<?> clazz, Class<?>[] args, String ... methods) {
        for (String method : methods) {
            try {
                return clazz.getMethod(method, args);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        throw new RuntimeException("method not found from " + Arrays.toString(methods) + " for class " + clazz.getName() + " with args " + Arrays.toString(args));
    }

    static Object invokeMethod(Class<?> clazz, Object instance, Object[] args, String ... methods) {
        if (args == null) {
            args = new Object[]{};
        }
        Class[] search = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            search[i] = args[i].getClass();
        }
        return Reflection.invokeMethod(clazz, instance, args, search, methods);
    }

    static Object invokeMethod(Class<?> clazz, Object instance, Object[] args, Class<?>[] search, String ... methods) {
        if (args == null) {
            args = new Object[]{};
        }
        if (search == null) {
            search = new Class[]{};
        }
        Method method = Reflection.method(clazz, search, methods);
        try {
            return method.invoke(instance, args);
        }
        catch (IllegalAccessException | NoSuchMethodError | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static Class<?> clazz(String ... classes) {
        for (String clazz : classes) {
            try {
                return Thread.currentThread().getContextClassLoader().loadClass(clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        throw new RuntimeException("Class not found from " + Arrays.toString(classes));
    }

    static Object field(Class<?> clazz, Object instance, String ... fields) {
        for (String field : fields) {
            try {
                Field f = clazz.getField(field);
                return f.get(instance);
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            }
        }
        throw new RuntimeException("Field not found from " + Arrays.toString(fields));
    }

    static void setField(Class<?> clazz, Object instance, Object value, String ... fields) {
        for (String field : fields) {
            try {
                Field f = clazz.getField(field);
                f.set(instance, value);
                return;
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            }
        }
        throw new RuntimeException("Field not found from " + Arrays.toString(fields));
    }
}

