/*
 * Decompiled with CFR 0.152.
 */
package com.nopoisonregen;

import com.nopoisonregen.Constants;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class CommonClass {
    public static final Map<Holder<MobEffect>, Holder<MobEffect>> cancelableEffectMap = new HashMap<Holder<MobEffect>, Holder<MobEffect>>();

    public static void refreshCache(List<? extends String> cancelableEffects) {
        Constants.LOGGER.info("Refreshing NMPR canceling effects");
        cancelableEffectMap.clear();
        for (String string : cancelableEffects) {
            String[] values;
            if (!string.contains(",") || (values = string.split(",")).length != 2) continue;
            String value1 = values[0];
            ResourceLocation location1 = ResourceLocation.tryParse((String)value1);
            String value2 = values[1];
            ResourceLocation location2 = ResourceLocation.tryParse((String)value2);
            if (location1 == null || location2 == null) continue;
            Holder effect1 = BuiltInRegistries.MOB_EFFECT.get(location1).orElse(null);
            Holder effect2 = BuiltInRegistries.MOB_EFFECT.get(location2).orElse(null);
            if (effect1 == null || effect2 == null) continue;
            cancelableEffectMap.put((Holder<MobEffect>)effect1, (Holder<MobEffect>)effect2);
        }
    }

    public static boolean isEffectApplicable(MobEffectInstance effectInstance, LivingEntity livingEntity) {
        MobEffect applicableEffect = (MobEffect)effectInstance.getEffect().value();
        Level level = livingEntity.level();
        if (!level.isClientSide() && !cancelableEffectMap.isEmpty()) {
            for (Map.Entry<Holder<MobEffect>, Holder<MobEffect>> entry : cancelableEffectMap.entrySet()) {
                MobEffectInstance instance1;
                int secondEffectTime;
                int firstEffectTime;
                int remainingTime;
                Holder<MobEffect> effect1 = entry.getKey();
                Holder<MobEffect> effect2 = entry.getValue();
                if (effect1 == null || effect2 == null) continue;
                if (effect1 == applicableEffect && livingEntity.hasEffect(effect2)) {
                    MobEffectInstance instance2 = livingEntity.getEffect(effect2);
                    if (instance2 == null || (remainingTime = (firstEffectTime = instance2.getDuration() * (instance2.getAmplifier() + 1)) - (secondEffectTime = effectInstance.getDuration() * (effectInstance.getAmplifier() + 1))) != 0) continue;
                    livingEntity.removeEffect(effect2);
                    return false;
                }
                if (effect2 != applicableEffect || !livingEntity.hasEffect(effect1) || (instance1 = livingEntity.getEffect(effect1)) == null || (remainingTime = (firstEffectTime = instance1.getDuration() * (instance1.getAmplifier() + 1)) - (secondEffectTime = effectInstance.getDuration() * (effectInstance.getAmplifier() + 1))) != 0) continue;
                livingEntity.removeEffect(effect1);
                return false;
            }
        }
        return true;
    }

    public static void onLivingTick(LivingEntity livingEntity) {
        Level level = livingEntity.level();
        if (!level.isClientSide() && level.getGameTime() % 20L == 0L && !cancelableEffectMap.isEmpty()) {
            for (Map.Entry<Holder<MobEffect>, Holder<MobEffect>> entry : cancelableEffectMap.entrySet()) {
                Holder<MobEffect> effect1 = entry.getKey();
                Holder<MobEffect> effect2 = entry.getValue();
                if (effect1 == null || effect2 == null || !livingEntity.hasEffect(effect1) || !livingEntity.hasEffect(effect2)) continue;
                MobEffectInstance instance1 = livingEntity.getEffect(effect1);
                MobEffectInstance instance2 = livingEntity.getEffect(effect2);
                if (instance1 == null || instance2 == null) continue;
                int firstEffectTime = instance1.getDuration() * (instance1.getAmplifier() + 1);
                int secondEffectTime = instance2.getDuration() * (instance2.getAmplifier() + 1);
                int remainingTime = firstEffectTime - secondEffectTime;
                livingEntity.removeEffect(effect1);
                livingEntity.removeEffect(effect2);
                if (remainingTime < 0) {
                    livingEntity.addEffect(new MobEffectInstance(effect2, -remainingTime));
                    continue;
                }
                if (remainingTime <= 0) continue;
                livingEntity.addEffect(new MobEffectInstance(effect1, remainingTime));
            }
        }
    }
}

