/*
 * Decompiled with CFR 0.152.
 */
package com.nopoisonregen;

import com.nopoisonregen.CommonClass;
import com.nopoisonregen.NeoForgeNMPRConfig;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

@Mod(value="nopoisonregen")
public class NMPRNeoForge {
    public NMPRNeoForge(IEventBus eventBus, Dist dist, ModContainer container) {
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)NeoForgeNMPRConfig.commonSpec);
        eventBus.register(NeoForgeNMPRConfig.class);
        NeoForge.EVENT_BUS.addListener(this::isEffectApplicable);
        NeoForge.EVENT_BUS.addListener(this::onLivingTick);
        if (dist.isClient()) {
            container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
        }
    }

    private void isEffectApplicable(MobEffectEvent.Applicable event) {
        boolean isApplicable = CommonClass.isEffectApplicable(event.getEffectInstance(), event.getEntity());
        if (!isApplicable) {
            event.setResult(MobEffectEvent.Applicable.Result.DO_NOT_APPLY);
        }
    }

    private void onLivingTick(EntityTickEvent.Post event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEvent = (LivingEntity)entity;
            CommonClass.onLivingTick(livingEvent);
        }
    }
}

