/**
 * Finds the ID of the platform closest to the given model coordinates.
 *
 * @param {mtr.data.ClientData} ClientData - The client data object from the Minecraft Transit Railway (MTR) mod containing platform information.
 * @param {cn.zbx1425.sowcer.math.Vector3f} modelVector3f - The 3D position vector from the MTR-NTE mod representing the model's coordinates.
 * @returns {number|null} The ID of the closest platform. Returns `null` if no platforms exist or if `ClientData` or `modelVector3f` are not provided.
 */
function getClosestPlatform(ClientData, modelVector3f) {
  let debugVar = null;
  let closestPlatform = null;

  if (!ClientData) {
    print("JOANNET NEUE ERROR>> getClosestPlatform(): You must add the MTR Client Data");
    return closestPlatform
  }

  if (!modelVector3f) {
    print("JOANNET NEUE ERROR>> getClosestPlatform(): You must give the model's Vector3f");
    return closestPlatform
  }

  if (ClientData.PLATFORMS.size() === 0) {
    print("JOANNET NEUE WARNING>> getClosestPlatform(): This world doesn't have any platforms. Function will always return null");
  }

  let minDistSq = Number.MAX_VALUE;
  for (let platform of ClientData.PLATFORMS) {
    let chosenPlatform = new Vector3f(platform.getMidPos());
    let distSq = modelVector3f.distanceSq(chosenPlatform);

    if (distSq < minDistSq) {
      minDistSq = distSq;
      closestPlatform = platform.id;
      debugVar = platform //<- DEBUG PURPOSES
    }
  }

  //print(`JOANNET NEUE DEBUG>> getClosestPlatform(): Closest platform found is ${closestPlatform} (type is ${typeof closestPlatform}) in ${new Vector3f(debugVar.getMidPos()).x()}, ${new Vector3f(debugVar.getMidPos()).y()}, ${new Vector3f(debugVar.getMidPos()).z()}`);
  return closestPlatform;
}