/**
 * Retrieves detailed platform data for a given platform ID.
 *
 * @param {mtr.data.ClientData} ClientData - The client data object from the Minecraft Transit Railway (MTR) mod containing platform information.
 * @param {number} platformId - The ID of the platform to retrieve.
 * @returns {Object|null} A JS-friendly object containing the platform’s data if found, or `null` if no platform exists with the given ID, if `ClientData` is null, or if `platformId` is invalid.
 */
function getPlatform(ClientData, platformId) {
  let platformMatch = null;
  if (!ClientData) {
    print("JOANNET NEUE ERROR>> getPlatform(): You must add the MTR Client Data");
    return platformMatch;
  }

  if (!platformId) {
    print("JOANNET NEUE ERROR>> getPlatform(): You must provide the platform's ID");
    return platformMatch;
  }

  if (ClientData.PLATFORMS.size() === 0) {
    print("JOANNET NEUE WARNING>> getPlatform(): This world doesn't have any platforms. Function will always return null value");
  }

  for (let platform of ClientData.PLATFORMS) {
    if (Number(platform.id) === Number(platformId)) {
      platformMatch = platform;
      break;
    }
  }

  if (platformMatch) {
    return {
      id: Number(platformMatch.id),
      transportMode: String(platformMatch.transportMode),
      name: String(platformMatch.name),
      color: Number(platformMatch.color),
      dwellTime: Number(platformMatch.dwellTime),
      departureTime: Number(platformMatch.dwellTime) / 2,
      positions: platformMatch.positions,
      _raw: platformMatch
    };
  } else {
    print("JOANNET NEUE INFO>> getPlatform(): No platform with ID \"" + platformId + "\" found. Returning null...");
    return null;
  }
}