/**
 * Retrieves all platform IDs associated with a given station.
 *
 * @param {mtr.data.ClientData} ClientData - The client data object from the Minecraft Transit Railway (MTR) mod containing station and platform information.
 * @param {mtr.data.Station} Station - The station instance from the Minecraft Transit Railway (MTR) mod.
 * @returns {number[]|null} An array of platform IDs within the station. Returns an empty array if none are found, or null if `ClientData` or `Station` is not provided.
 */
function getPlatformsFromStation(ClientData, Station) {
  if (!ClientData) {
    print("JOANNET NEUE ERROR>> getPlatformsFromStation(): You must add the MTR Client Data");
    return null;
  }

  if (!Station) {
    print("JOANNET NEUE ERROR>> getPlatformsFromStation(): You must add an Station instance");
    return null;
  }

  if (ClientData.PLATFORMS.size() === 0) {
    print("JOANNET NEUE WARNING>> getPlatformsFromStation(): This world doesn't have any platforms. Function will always return an empty array.");
  }

  const platformIDsInStation = [];
  for (let platform of ClientData.PLATFORMS) {
    let platformCoords = new Vector3f(platform.getMidPos());
    if (Station.inArea(platformCoords.x(), platformCoords.z())) {
      platformIDsInStation.push(Number(platform.id));
    }
  }

  if (platformIDsInStation.length === 0) {
    print("JOANNET NEUE INFO>> getPlatformsFromStation(): Station \"" + Station.id + "\" has no platforms. Returning empty array...");
  }

  return platformIDsInStation;
}