/**
 * Retrieves the route data for a given route ID.
 *
 * @param {mtr.data.ClientData} ClientData - The client data object from the Minecraft Transit Railway (MTR) mod containing route information.
 * @param {number} routeId - The unique ID of the route to search for.
 * @returns {Object|null} A JS-friendly object representing the route, or `null` if no route is found, if `ClientData` is null, or if `routeId` is invalid.
 */
function getRoute(ClientData, routeId) {
  let routeMatch = null;
  if (!ClientData) {
    print("JOANNET NEUE ERROR>> getRoute(): You must add the MTR Client Data");
    return routeMatch;
  }

  if (!routeId) {
    print("JOANNET NEUE ERROR>> getRoute(): You must provide the route's ID");
    return routeMatch;
  }

  if (ClientData.ROUTES.size() === 0) {
    print("JOANNET NEUE WARNING>> getRoute(): This world doesn't have any routes. Function will always return null.");
  }

  for (let route of ClientData.ROUTES) {
    if (Number(route.id) === Number(routeId)) {
      routeMatch = route;
      break;
    }
  }

  if (routeMatch) {
    let platformIdsArray = [];
    for (let pID of routeMatch.platformIds) {
      platformIdsArray.push({
        customDestination: String(pID.customDestination),
        platformId: Number(pID.platformId)
      });
    }

    return {
      id: Number(routeMatch.id),
      transportMode: String(routeMatch.transportMode),
      name: String(routeMatch.name),
      color: Number(routeMatch.color),
      routeType: String(routeMatch.routeType),
      isLightRailRoute: Boolean(routeMatch.isLightRailRoute),
      isHidden: Boolean(routeMatch.isHidden),
      disableNextStationAnnouncements: Boolean(routeMatch.disableNextStationAnnouncements),
      circularState: String(routeMatch.circularState),
      lightRailRouteNumber: String(routeMatch.lightRailRouteNumber),
      platformIds: platformIdsArray,
      _raw: routeMatch
    }
  } else {
    print("JOANNET NEUE INFO>> getRoute(): No route with ID \"" + routeId + "\" found. Returning null...");
    return null;
  }
}