/**
 * Retrieves all route IDs where a specified platform stops.
 *
 * @param {mtr.client.ClientData} ClientData - The client data object from the Minecraft Transit Railway (MTR) mod containing route and platform information.
 * @param {number} platformId - The ID of the platform to search for.
 * @returns {number[]|null} An array of route IDs where the platform stops. Returns an empty array if the platform is not part of any route, or `null` if `ClientData` is null or `platformId` is not provided.
 */
function getRoutesFromPlatform(ClientData, platformId) {
  if (!ClientData) {
    print("JOANNET NEUE ERROR>> You must add the MTR Client Data");
    return null;
  }

  if (!platformId) {
    print("JOANNET NEUE ERROR>> You must add the platformId");
    return null;
  }

  if (ClientData.ROUTES.size() === 0) {
    print("JOANNET NEUE WARNING>> getRoute(): This world doesn't have any routes. Function will always return an empty array.");
  }

  const stoppingRouteIDS = [];
  for (let route of ClientData.ROUTES) {
    for (let i = 0; i < route.platformIds.size(); i++) {
      let routePlatform = route.platformIds.get(i);

      if (routePlatform.platformId === platformId) {
        stoppingRouteIDS.push(Number(route.id));
        break;
      }
    }
  }

  return stoppingRouteIDS;
}