/**
 * Retrieves detailed station data for a given station ID.
 *
 * @param {mtr.data.ClientData} ClientData - The client data object from the Minecraft Transit Railway (MTR) mod containing station information.
 * @param {number} stationId - The ID of the station to retrieve.
 * @returns {Object|null} A JS-friendly object containing the station’s data if found, or `null` if no station exists with the given ID, if `ClientData` is null, or if `stationId` is invalid.
 */
function getStation(ClientData, stationId) {
  let stationMatch = null;

  if (!ClientData) {
    print("JOANNET NEUE ERROR>> getStation(): You must add the MTR Client Data");
    return stationMatch;
  }

  if (!stationId) {
    print("JOANNET NEUE ERROR>> getStation(): You must provide the station's ID");
    return stationMatch;
  }

  if (ClientData.STATIONS.size() === 0) {
    print("JOANNET NEUE WARNING>> getStation(): This world doesn't have any stations. Function will always return null.");
  }

  for (let station of ClientData.STATIONS) {
    if (Number(station.id) === Number(stationId)) {
      stationMatch = station;
      break;
    }
  }

  if (stationMatch) {
    return {
      id: Number(stationMatch.id),
      transportMode: String(stationMatch.transportMode),
      name: String(stationMatch.name),
      color: Number(stationMatch.color),
      coords: stationMatch.getCenter(),
      zone: Number(stationMatch.zone),
      exits: stationMatch.exits,
      _raw: stationMatch
    };
  } else {
    print("JOANNET NEUE INFO>> getStation(): No station with ID \"" + stationId + "\" found. Returning null...");
    return null;
  }
}