/**
 * Get the station ID where the model is located based on its coordinates.
 * @param {mtr.data.ClientData} ClientData - ClientData from the Minecraft Transit Railway.
 * @param {cn.zbx1425.sowcer.math.Vector3f} modelVector3f - Vector3f from the MTR-NTE mod.
 * @return {Number|null} The station ID where the model is located. Returns null if none is found or model is not in any station zone or if ClientData and/or modelVector3f are null.
 */
function getStationInArea(ClientData, modelVector3f) {
  let foundStationId = null;

  if (!ClientData) {
    print("JOANNET NEUE ERROR>> getStationInArea(): You must add the MTR Client Data");
    return foundStationId;
  }

  if (!modelVector3f) {
    print("JOANNET NEUE ERROR>> getStationInArea(): You must give the model's Vector3f");
    return foundStationId;
  }

  if (ClientData.STATIONS.size() === 0) {
    print("JOANNET NEUE WARNING>> getStationInArea(): This world doesn't have any stations. Function will always return null.");
  }

  for (let station of ClientData.STATIONS) {
    if (station.inArea(modelVector3f.x(), modelVector3f.z())) {
      foundStationId = Number(station.id);
      break;
    }
  }

  return foundStationId;
}