/**
 * Draws a text stretched to exactly fill a given box.
 *
 * The text may appear stretched or compressed depending on its size and the available space.
 * This function creates a copy of the Graphics to apply scaling without affecting other drawings.
 *
 * @param {java.awt.Graphics} ctx The Graphics object where the text will be drawn.
 * @param {java.awt.Font} font    The base font that will be used for drawing.
 * @param {string} str            The text to be drawn.
 * @param {number} x              The upper left X coordinate of the box.
 * @param {number} y              The upper left Y coordinate of the box.
 * @param {number} width          The width of the box that the text should occupy.
 * @param {number} height         The height of the box that the text should occupy.
 */
function drawTextBox(ctx, font, str, x, y, width, height) {
  try {
    let fm = ctx.getFontMetrics(font);
    let textWidth = fm.stringWidth(str);
    let textHeight = fm.getHeight();
    let xScale = width / textWidth;
    let yScale = height / textHeight;

    let g = ctx.create();
    g.translate(x, y);
    g.scale(xScale, yScale);
    g.setFont(font);
    g.drawString(str, 0, fm.getAscent());
    g.dispose();
  } catch(e) {
    print(`JOANNET NEUE ERROR>> drawTextBox(): ${e}`);
  }
}
