/**
 * Calculates the pixel width of a given text string with a specified font on a Graphics2D context.
 *
 * @param {java.awt.Graphics2D} ctx - The Graphics2D context used to render the text.
 * @param {string} text - The text string to measure.
 * @param {java.awt.Font} font - The font used for the text.
 * @returns {number} The width of the text in pixels. Returns 0 if text or font is not provided.
 */
function getTextWidth(ctx, text, font) {
  if (!text || !font) return 0;
  return ctx.getFontMetrics(font).stringWidth(text);
}
