/**
 * Formats a given time as a string in "HH:MM" format.
 *
 * @param {number} [ms] - Time in milliseconds. If `null` or `undefined`, the current system time will be used.
 * @returns {string} The formatted time as "HH:MM".
 */
function formatTime(ms) {
    let millis;
    if (ms) {
        millis = ms;
    } else {
        millis = Date.now()
    }

    const now = new Date(millis)
    const hh = String(now.getHours()).padStart(2, "0");
    const mm = String(now.getMinutes()).padStart(2, "0");
    return `${hh}:${mm}`;
}